/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.Option;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import smc.PartialCoalescentState4BackForwardKernel;

public class BackForwardKernel
implements LazyParticleFilter.LazyParticleKernel<PartialCoalescentState4BackForwardKernel>,
ParticleKernel<PartialCoalescentState4BackForwardKernel> {
    @Option
    public static boolean printBranchLengthMagnitudes = false;
    private final PartialCoalescentState4BackForwardKernel initial;

    public BackForwardKernel(PartialCoalescentState4BackForwardKernel initial) {
        this.initial = initial;
    }

    public PartialCoalescentState4BackForwardKernel getInitial() {
        return this.initial;
    }

    public int nIterationsLeft(PartialCoalescentState4BackForwardKernel partialState) {
        return partialState.getCurrentState().nIterationsLeft();
    }

    public Object _next0(Random rand, PartialCoalescentState4BackForwardKernel current, boolean isPeek) {
        double delta = Sampling.sampleExponential((Random)rand, (double)((this.initial.getCurrentState().isClock() ? 0.1 : 0.05) / BackForwardKernel.nChoose2(current.getCurrentState().nRoots())));
        if (delta < Math.pow(10.0, -10.0)) {
            delta = Math.pow(10.0, -10.0);
        }
        List sampledIndices = Sampling.sampleWithoutReplacement((Random)rand, (int)current.getCurrentState().nRoots(), (int)2);
        int i0 = (Integer)sampledIndices.get(0);
        int i1 = (Integer)sampledIndices.get(1);
        double leftIncrement = 0.0;
        double rightIncrement = 0.0;
        if (!this.initial.getCurrentState().isClock()) {
            double incr = Sampling.sampleExponential((Random)rand, (double)0.1);
            if (rand.nextBoolean()) {
                leftIncrement += incr;
            } else {
                rightIncrement += incr;
            }
        }
        PartialCoalescentState4BackForwardKernel result = null;
        Double logw = null;
        if (isPeek) {
            logw = current.getCurrentState().peekLogLikelihoodRatio(i0, i1, delta, leftIncrement, rightIncrement);
        } else {
            PartialCoalescentState resultpcs = current.getCurrentState().coalesce(i0, i1, delta, leftIncrement, rightIncrement);
            result = new PartialCoalescentState4BackForwardKernel(resultpcs, current.getCurrentState(), null, current, delta, new int[]{i0, i1});
        }
        if (isPeek) {
            return logw;
        }
        return Pair.makePair((Object)result, (Object)result.getCurrentState().logLikelihoodRatio());
    }

    public Object _next1(Random rand, PartialCoalescentState4BackForwardKernel current, boolean isPeek) {
        double oldLogLikelihoodRatio = 0.0;
        double logExpDensityDeltaOld = 0.0;
        PartialCoalescentState4BackForwardKernel parent = current.parentState();
        PartialCoalescentState result00 = current.getCurrentState();
        PartialCoalescentState result0 = null;
        PartialCoalescentState result1 = null;
        List sampledIndices0 = Sampling.sampleWithoutReplacement((Random)rand, (int)parent.getCurrentState().nRoots(), (int)2);
        int i00 = (Integer)sampledIndices0.get(0);
        int i01 = (Integer)sampledIndices0.get(1);
        int[] currentIndx = current.getIndxState();
        oldLogLikelihoodRatio = current.getCurrentState().logLikelihoodRatio();
        double deltaOld = current.getDelta();
        double param0 = (this.initial.getCurrentState().isClock() ? 0.1 : 0.05) / BackForwardKernel.nChoose2(parent.getCurrentState().nRoots());
        double tempdelta0 = Sampling.sampleExponential((Random)rand, (double)param0);
        for (int deltaIter = 0; tempdelta0 < Math.pow(10.0, -10.0) && deltaIter < 5; ++deltaIter) {
            tempdelta0 = Sampling.sampleExponential((Random)rand, (double)param0);
        }
        if (tempdelta0 < Math.pow(10.0, -10.0)) {
            tempdelta0 = Math.pow(10.0, -10.0);
        }
        double delta0 = tempdelta0;
        double leftIncrement0 = 0.0;
        double rightIncrement0 = 0.0;
        result0 = current.getMidState().coalesce(i00, i01, delta0, leftIncrement0, rightIncrement0);
        List sampledIndices1 = Sampling.sampleWithoutReplacement((Random)rand, (int)result0.nRoots(), (int)2);
        int i10 = (Integer)sampledIndices1.get(0);
        int i11 = (Integer)sampledIndices1.get(1);
        double nPossiblePairs = BackForwardKernel.nChoose2(current.getCurrentState().nRoots());
        double param1 = (this.initial.getCurrentState().isClock() ? 0.1 : 0.05) / nPossiblePairs;
        double delta1 = Sampling.sampleExponential((Random)rand, (double)param1);
        double leftIncrement1 = 0.0;
        double rightIncrement1 = 0.0;
        PartialCoalescentState4BackForwardKernel result = null;
        Double loglikeRatio0 = result0.logLikelihoodRatio();
        result1 = result0.coalesce(i10, i11, delta1, leftIncrement1, rightIncrement1);
        Double logw = null;
        logw = loglikeRatio0 + result1.logLikelihoodRatio() - oldLogLikelihoodRatio;
        result = new PartialCoalescentState4BackForwardKernel(result1, result0, current.getMidState(), current, delta1, new int[]{i10, i11});
        if (isPeek) {
            return logw;
        }
        return Pair.makePair((Object)result, (Object)(result.getCurrentState().logLikelihoodRatio() + loglikeRatio0 - oldLogLikelihoodRatio));
    }

    public static double nChoose2(double n) {
        return n * (n - 1.0) / 2.0;
    }

    public Object _next(Random rand, PartialCoalescentState4BackForwardKernel current, boolean isPeek) {
        if (current.hasParent()) {
            return this._next1(rand, current, isPeek);
        }
        return this._next0(rand, current, isPeek);
    }

    public Pair<PartialCoalescentState4BackForwardKernel, Double> next(Random rand, PartialCoalescentState4BackForwardKernel current) {
        return (Pair)this._next(rand, current, false);
    }

    public double peekNext(Random rand, PartialCoalescentState4BackForwardKernel current) {
        return (Double)this._next(rand, current, true);
    }
}

