/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.Parallelizer;
import fig.prob.Multinomial;
import goblin.BayesRiskMinimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import monaco.process.ResampleStatus;
import nuts.lang.ArrayUtils;
import nuts.math.Fct;
import nuts.math.Id;
import nuts.math.MeasureZeroException;
import nuts.math.Sampling;
import nuts.maxent.SloppyMath;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.Hasher;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;

public final class PGASParticleFilter<S> {
    @Option
    public boolean verbose = false;
    @Option
    public int N = 100;
    @Option
    public Random rand = new Random(1L);
    @Option
    public boolean resampleLastRound = true;
    @Option
    public int nThreads = 1;
    @Option
    public ResamplingStrategy resamplingStrategy = ResamplingStrategy.ALWAYS;
    public static final double essRatioThreshold = 0.5;
    @Option
    public boolean usePGAS = true;
    private List<S> conditional = null;
    private double[] conditionalUnnormWeights = null;
    private ProcessSchedule schedule = null;
    private long[] seeds;
    private List<S> samples;
    private double[] logWeights;
    private double[] normalizedWeights;
    private double lognorm = 0.0;

    public void setProcessSchedule(ProcessSchedule schedule) {
        this.schedule = schedule;
    }

    public void setConditional(List<S> conditional, double[] conditionalUnnormWeights) {
        if (conditional.size() != conditionalUnnormWeights.length) {
            throw new RuntimeException();
        }
        this.conditional = conditional;
        this.conditionalUnnormWeights = conditionalUnnormWeights;
    }

    public void setUnconditional() {
        this.conditional = null;
        this.conditionalUnnormWeights = null;
    }

    public boolean isConditional() {
        return this.conditional != null;
    }

    public static double ess(double[] ws) {
        double sumOfSqr = 0.0;
        for (double w : ws) {
            sumOfSqr += w * w;
        }
        return 1.0 / sumOfSqr;
    }

    public static <S> void bootstrapFilter(ParticleKernel<S> kernel, ParticleProcessor<S> processor, int N, Random rand) {
        PGASParticleFilter<S> PF = new PGASParticleFilter<S>();
        PF.N = N;
        PF.rand = rand;
        PF.resampleLastRound = false;
        PF.resamplingStrategy = ResamplingStrategy.ALWAYS;
        PF.sample(kernel, processor);
    }

    public List<S> getSamples() {
        return this.samples;
    }

    public double[] getLogWeights() {
        return this.logWeights;
    }

    private void propagateAndComputeWeights(final ParticleKernel<S> kernel, final int t) {
        if (this.verbose) {
            LogInfo.track((Object)"Processing...", (boolean)false);
        }
        this.seeds = Sampling.createSeeds((int)this.N, (Random)this.rand);
        Parallelizer parallelizer = new Parallelizer(this.nThreads);
        parallelizer.setPrimaryThread();
        parallelizer.process(CollUtils.ints((int)this.N), (Parallelizer.Processor)new Parallelizer.Processor<Integer>(){

            public void process(Integer x, int _i, int _n, boolean log) {
                if (log && (x + 1) % 5 == 0 && PGASParticleFilter.this.verbose) {
                    LogInfo.logs((Object)("Particle " + (x + 1) + "/" + PGASParticleFilter.this.N));
                }
                Random rand = new Random(PGASParticleFilter.this.seeds[x]);
                if (x == 0 && PGASParticleFilter.this.isConditional()) {
                    PGASParticleFilter.this.samples.set(x, PGASParticleFilter.this.conditional.get(t));
                    ((PGASParticleFilter)PGASParticleFilter.this).logWeights[x.intValue()] = PGASParticleFilter.this.conditionalUnnormWeights[t];
                } else {
                    Pair current = kernel.next(rand, PGASParticleFilter.this.samples.get(x));
                    if (current == null) {
                        PGASParticleFilter.this.samples.set(x, null);
                        ((PGASParticleFilter)PGASParticleFilter.this).logWeights[x.intValue()] = Double.NEGATIVE_INFINITY;
                    } else {
                        PGASParticleFilter.this.samples.set(x, current.getFirst());
                        ((PGASParticleFilter)PGASParticleFilter.this).logWeights[x.intValue()] = (Double)current.getSecond();
                    }
                }
            }
        });
        if (this.verbose) {
            LogInfo.end_track();
        }
    }

    public double estimateNormalizer() {
        return this.lognorm;
    }

    private void init(ParticleKernel<S> kernel) {
        this.lognorm = 0.0;
        this.samples = new ArrayList<S>(this.N);
        Object initial = kernel.getInitial();
        for (int n = 0; n < this.N; ++n) {
            this.samples.add(initial);
        }
        this.logWeights = new double[this.N];
        this.normalizedWeights = new double[this.N];
        for (int i = 0; i < this.normalizedWeights.length; ++i) {
            this.normalizedWeights[i] = 1.0 / (double)this.N;
        }
    }

    private void newProcess(int t, double[] normalizedWeights, ParticleProcessor<S> processor, int T) {
        if (this.schedule == null && t == T - 1 || this.schedule != null && this.schedule.shouldProcess(new ProcessScheduleContext(t, t == T - 1, ResampleStatus.NA))) {
            if (this.verbose) {
                LogInfo.track((Object)"Processing particles");
            }
            for (int n = 0; n < normalizedWeights.length; ++n) {
                if (this.verbose) {
                    LogInfo.logs((Object)("Particle " + (n + 1) + "/" + normalizedWeights.length));
                }
                if (this.samples.get(n) == null) continue;
                processor.process(this.samples.get(n), normalizedWeights[n]);
            }
            if (this.verbose) {
                LogInfo.end_track();
            }
        }
    }

    public void sample(ParticleKernel<S> kernel, ParticleProcessor<S> processor) {
        this.init(kernel);
        int T = kernel.nIterationsLeft(kernel.getInitial());
        if (this.isConditional() && this.conditional.size() != T) {
            throw new RuntimeException();
        }
        for (int t = 0; t < T; ++t) {
            if (this.verbose) {
                LogInfo.track((Object)("Particle generation " + (t + 1) + "/" + T), (boolean)true);
            }
            this.propagateAndComputeWeights(kernel, t);
            if (t > 0) {
                this.lognorm += SloppyMath.logAdd((double[])this.logWeights);
            }
            this.normalizedWeights = (double[])this.logWeights.clone();
            NumUtils.expNormalize((double[])this.normalizedWeights);
            if (this.verbose) {
                LogInfo.logs((Object)("LargestNormalizedWeights=" + ArrayUtils.max((double[])this.normalizedWeights)));
            }
            if (this.verbose) {
                LogInfo.logs((Object)("RelativeESS=" + PGASParticleFilter.ess(this.normalizedWeights) / (double)this.normalizedWeights.length));
            }
            this.newProcess(t, this.normalizedWeights, processor, T);
            if (t < T - 1 && (this.hasNulls(this.samples) || this.resamplingStrategy.needResample(this.normalizedWeights))) {
                this.normalizedWeights = (double[])this.logWeights.clone();
                NumUtils.expNormalize((double[])this.normalizedWeights);
                this.samples = this.resample(this.samples, this.normalizedWeights, this.rand);
                for (int i = 0; i < this.normalizedWeights.length; ++i) {
                    this.normalizedWeights[i] = 1.0 / (double)this.N;
                }
            }
            if (this.verbose) {
                LogInfo.end_track();
            }
            if (t == T - 1 && this.schedule != null) {
                if (this.resampleLastRound) {
                    Pair<List<S>, double[]> resampled = this.resampleAndPack(this.samples, this.normalizedWeights, this.rand);
                    this.samples = (List)resampled.getFirst();
                    this.normalizedWeights = (double[])resampled.getSecond();
                }
                if (this.verbose) {
                    LogInfo.track((Object)"Processing particles");
                }
                for (int n = 0; n < this.normalizedWeights.length; ++n) {
                    if (this.verbose) {
                        LogInfo.logs((Object)("Particle " + (n + 1) + "/" + this.normalizedWeights.length));
                    }
                    if (this.samples.get(n) == null) continue;
                    processor.process(this.samples.get(n), this.normalizedWeights[n]);
                    this.samples.set(n, null);
                }
                if (this.verbose) {
                    LogInfo.end_track();
                }
            }
            if (this.schedule == null) continue;
            this.schedule.monitor(new ProcessScheduleContext(t, t == T - 1, ResampleStatus.NA));
        }
        this.setUnconditional();
    }

    private boolean hasNulls(List<S> samples) {
        for (S item : samples) {
            if (item != null) continue;
            return true;
        }
        return false;
    }

    private <S> Pair<List<S>, double[]> resampleAndPack(List<S> list, double[] w, Random rand) {
        if (!NumUtils.normalize((double[])w)) {
            throw new MeasureZeroException();
        }
        if (list.size() != w.length) {
            throw new RuntimeException();
        }
        Counter packed = Sampling.ResamplingScheme.Systematic.Resampling(rand, w, w.length);
        double[] resultWeight = new double[packed.size()];
        ArrayList<S> resultList = new ArrayList<S>(packed.size());
        int i = 0;
        Iterator iterator = packed.keySet().iterator();
        while (iterator.hasNext()) {
            int itemIdx = (Integer)iterator.next();
            S item = list.get(itemIdx);
            resultList.add(item);
            resultWeight[i++] = packed.getCount((Object)itemIdx);
        }
        return Pair.makePair(resultList, (Object)resultWeight);
    }

    private List<S> resample(List<S> list, double[] w, Random rand) {
        if (!NumUtils.normalize((double[])w)) {
            throw new MeasureZeroException();
        }
        if (list.size() != w.length) {
            throw new RuntimeException();
        }
        Counter packed = Sampling.ResamplingScheme.Systematic.Resampling(rand, w, w.length);
        ArrayList<S> result = new ArrayList<S>(list.size());
        Iterator iterator = packed.keySet().iterator();
        while (iterator.hasNext()) {
            int itemIdx = (Integer)iterator.next();
            S item = list.get(itemIdx);
            int cur = 0;
            while ((double)cur < packed.getCount((Object)itemIdx)) {
                result.add(item);
                ++cur;
            }
        }
        return result;
    }

    public static class MAPDecoder<D>
    implements ParticleProcessor<D> {
        private D argmax = null;
        private double max = Double.NEGATIVE_INFINITY;

        @Override
        public void process(D state, double weight) {
            if (weight > this.max) {
                this.argmax = state;
                this.max = weight;
            }
        }

        public D map() {
            return this.argmax;
        }
    }

    public static class PCSHash
    implements ParticleProcessor<PartialCoalescentState> {
        private Hasher hasher = new Hasher();

        @Override
        public void process(PartialCoalescentState state, double weight) {
            this.hasher.add(weight).add(state.logLikelihood()).add(state.topHeight()).add((Object)state.getUnlabeledArbre().deepToLispString());
        }

        public int getHash() {
            return this.hasher.hashCode();
        }
    }

    public static class ParticleMapperProcessor<D, I>
    implements ParticleProcessor<D> {
        private final Fct<D, I> prj;
        private final Counter<I> counter = new Counter();

        public static <S> ParticleMapperProcessor<S, S> saveParticlesProcessor() {
            return new ParticleMapperProcessor(new Id());
        }

        public static ParticleMapperProcessor<PartialCoalescentState, PartialCoalescentState> saveCoalescentParticlesProcessor() {
            return ParticleMapperProcessor.saveParticlesProcessor();
        }

        public ParticleMapperProcessor(Fct<D, I> prj) {
            this.prj = prj;
        }

        @Override
        public void process(D state, double weight) {
            this.counter.incrementCount(this.prj.evalAt(state), weight);
        }

        public I centroid(BayesRiskMinimizer.LossFct<I> loss) {
            return (I)new BayesRiskMinimizer(loss).findMin(this.counter);
        }

        public String printweights() {
            String s = "";
            for (Object key : this.counter) {
                double value = this.counter.getCount(key);
                s = s + value + ",";
            }
            return s;
        }

        public I map() {
            return (I)this.counter.argMax();
        }

        public I sample(Random rand) {
            double[] probs = new double[this.counter.size()];
            ArrayList states = new ArrayList();
            int i = 0;
            for (Object key : this.counter.keySet()) {
                states.add(key);
                probs[i++] = this.counter.getCount(key);
            }
            int j = Multinomial.sample((Random)rand, (double[])probs);
            return (I)states.get(j);
        }

        public Counter<I> getCounter() {
            return this.counter;
        }
    }

    public static class ForkedProcessor<S>
    implements ParticleProcessor<S> {
        public List<ParticleProcessor<S>> processors = new ArrayList<ParticleProcessor<S>>();

        public ForkedProcessor(ParticleProcessor<S> ... items) {
            this.processors = new ArrayList<ParticleProcessor<S>>(Arrays.asList(items));
        }

        public ForkedProcessor(Collection<ParticleProcessor<S>> items) {
            this.processors = CollUtils.list(items);
        }

        @Override
        public void process(S state, double weight) {
            for (ParticleProcessor<S> processor : this.processors) {
                processor.process(state, weight);
            }
        }
    }

    public static class DoNothingProcessor<S>
    implements ParticleProcessor<S> {
        @Override
        public void process(S state, double w) {
        }
    }

    public static class StoreProcessor<S>
    implements ParticleProcessor<S> {
        public List<S> particles = CollUtils.list();
        public List<Double> ws = CollUtils.list();

        @Override
        public void process(S state, double weight) {
            this.particles.add(state);
            this.ws.add(weight);
        }

        public S sample(Random rand) {
            int idx = Sampling.sample((Random)rand, this.ws);
            return this.particles.get(idx);
        }

        public S argmax() {
            int argmax = -1;
            double value = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.ws.size(); ++i) {
                if (!(this.ws.get(i) > value)) continue;
                value = this.ws.get(i);
                argmax = i;
            }
            return this.particles.get(argmax);
        }
    }

    public static interface ParticleProcessor<S> {
        public void process(S var1, double var2);
    }

    public static enum ResamplingStrategy {
        ALWAYS{

            @Override
            public boolean needResample(double[] w) {
                return true;
            }
        }
        ,
        NEVER{

            @Override
            public boolean needResample(double[] w) {
                return false;
            }
        }
        ,
        ESS{

            @Override
            public boolean needResample(double[] weights) {
                double threshold;
                double ess = PGASParticleFilter.ess(weights);
                return ess < (threshold = 0.5 * (double)weights.length);
            }
        };


        abstract boolean needResample(double[] var1);
    }
}

