/*
 * Decompiled with CFR 0.152.
 */
package conifer.data;

import conifer.data.TaxonDatum;
import conifer.data.TaxonIndexedData;
import conifer.evol.CalculatorOptions;
import conifer.evol.EvolutionaryOptions;
import goblin.Taxon;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.io.IO;
import nuts.util.CollUtils;
import pty.Observations;
import pty.io.Dataset;

public class AlignedData
implements TaxonIndexedData,
Observations,
Dataset {
    final MSAPoset alignment;
    final SequenceType sequenceType;
    final Dataset dataset;
    final int nTaxa;
    final Map<Taxon, double[][]> raw;

    public MSAPoset getAlignment() {
        return this.alignment;
    }

    public AlignedData(MSAPoset alignment, SequenceType st) {
        this.sequenceType = st;
        this.alignment = alignment;
        this.dataset = Dataset.DatasetUtils.fromAlignment(alignment, this.sequenceType);
        this.raw = this.dataset.observations();
        this.nTaxa = this.raw.keySet().size();
    }

    @Override
    public Map<Taxon, TaxonDatum> getIndexedData(EvolutionaryOptions evoOptions, CalculatorOptions calcOptions) {
        HashMap<Taxon, TaxonDatum> result = CollUtils.map();
        for (Taxon t : this.raw.keySet()) {
            AlignedDatum current = new AlignedDatum(this.raw.get(t));
            result.put(t, current);
        }
        return result;
    }

    @Override
    public int nSites() {
        return this.dataset.nSites();
    }

    @Override
    public int nCharacter(int site) {
        return this.dataset.nCharacter(site);
    }

    @Override
    public Map<Taxon, double[][]> observations() {
        return this.raw;
    }

    @Override
    public int nTaxa() {
        return this.nTaxa;
    }

    @Override
    public void writeToDisk(File f) {
        if (!f.mkdir()) {
            throw new RuntimeException();
        }
        this.alignment.toFASTA(new File(f, "alignment.fasta"));
        IO.writeToDisk(new File(f, "sequence-type"), "" + (Object)((Object)this.sequenceType));
    }

    @Override
    public boolean hasReferenceClusters() {
        throw new RuntimeException();
    }

    @Override
    public Map<Taxon, String> getReferenceClusters() {
        throw new RuntimeException();
    }

    public class AlignedDatum
    implements TaxonDatum {
        public final double[][] cacheInit;

        public AlignedDatum(double[][] cacheInit) {
            this.cacheInit = cacheInit;
        }
    }
}

