/*
 * Decompiled with CFR 0.152.
 */
package conifer.fastpf;

import conifer.ml.data.PhylogeneticHeldoutDataset;
import fig.basic.IOUtils;
import fig.basic.NumUtils;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.io.IO;
import nuts.math.PlotHistogram;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pty.RootedTree;

public class TaxaOrderHeuristic
implements Runnable {
    public static PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions phyloOptions = new PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions();

    public static void main(String[] args) throws Exception {
        IO.run(args, new TaxaOrderHeuristic(), "data", phyloOptions);
    }

    public static List<Taxon> heuristicOrder(Map<Taxon, double[][]> obs) {
        double[][] d = CollUtils.pick(obs.values());
        int nSites = d.length;
        int nChars = d[0].length;
        d = null;
        throw new RuntimeException();
    }

    public static List<Taxon> fromFile(File f) {
        ArrayList<Taxon> result = new ArrayList<Taxon>();
        for (String line : IO.i(f)) {
            if ((line = line.replaceAll("\\s*", "")).isEmpty()) continue;
            result.add(new Taxon(line));
        }
        return result;
    }

    @Override
    public void run() {
        File outFile = new File(Execution.getFile("taxa-order.txt"));
        PrintWriter out = IOUtils.openOutHard(outFile);
        TaxaOrderHeuristic.phyloOptions.holdOutFre = 0.0;
        TaxaOrderHeuristic.phyloOptions.alignmentFile = "/Users/bouchard/Documents/data/small-test-data/synthetic-phylo-10/alignment.fasta";
        TaxaOrderHeuristic.phyloOptions.treeFile = "/Users/bouchard/Documents/data/small-test-data/synthetic-phylo-10/tree.newick";
        PhylogeneticHeldoutDataset phyloData = PhylogeneticHeldoutDataset.loadData(phyloOptions);
        Map<Taxon, double[][]> obs = phyloData.obs.observations();
        if (obs.size() < 100) {
            System.out.println(phyloData.rootedTree);
        }
        List<Taxon> result = TaxaOrderHeuristic.heuristicOrder(obs);
        for (Taxon t : result) {
            out.println(t);
        }
        out.close();
        this.testOrder(phyloData, result);
    }

    private void testOrder(PhylogeneticHeldoutDataset phyloData, List<Taxon> taxa) {
        PlotHistogram ph = new PlotHistogram();
        RootedTree rt = phyloData.rootedTree;
        Random rand = new Random(1L);
        for (int i = 0; i < 1000; ++i) {
            int idx = rand.nextInt(taxa.size());
            Taxon t = taxa.get(idx);
            Arbre<Taxon> node = Arbre.findFirstNodeWithContents(rt.topology(), t);
            ArrayList<Integer> indices = new ArrayList<Integer>();
            try {
                for (Arbre<Taxon> sister : node.getParent().getChildren()) {
                    indices.add(taxa.indexOf(sister.getContents()));
                }
                if ((Integer)indices.get(0) != -1 && (Integer)indices.get(1) != -1) {
                    int pt = Math.abs((Integer)indices.get(0) - (Integer)indices.get(1));
                    ph.addPoint(pt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(i);
        }
        ph.savePlot(new File(Execution.getFile("hist.pdf")));
    }

    public static double[] simpleKey(double[][] datum, Taxon t) {
        Random rand = new Random(t.hashCode());
        int nSites = datum.length;
        int nChars = datum[0].length;
        double[] key = new double[nChars * nSites];
        int index = 0;
        for (int site = 0; site < nSites; ++site) {
            int c;
            double[] cur = (double[])datum[site].clone();
            for (c = 0; c < nChars; ++c) {
                cur[c] = cur[c] + rand.nextDouble() * 0.01;
            }
            NumUtils.normalize(cur);
            for (c = 0; c < nChars; ++c) {
                key[index++] = cur[c];
            }
        }
        return key;
    }
}

