/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ErrorFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class TruncatedNormalDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return TruncatedNormalDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return TruncatedNormalDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return TruncatedNormalDistribution.this.upper;
        }
    };
    private double m;
    private double sd;
    private double lower;
    private double upper;
    private double T;

    public double getMean() {
        return this.m;
    }

    public void setMdean(double m) {
        this.m = m;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double sd) {
        this.sd = sd;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public TruncatedNormalDistribution(double mean, double sd, double lower, double upper) {
        if (lower == upper) {
            upper += 1.0E-4;
        }
        if (sd == 0.0) {
            sd = 1.0E-5;
        }
        this.m = mean;
        this.sd = sd;
        this.lower = lower;
        this.upper = upper;
        double upperCDF = upper != Double.POSITIVE_INFINITY ? TruncatedNormalDistribution.standardNormalCdf((upper - mean) / sd) : 1.0;
        double lowerCDF = lower != Double.NEGATIVE_INFINITY ? TruncatedNormalDistribution.standardNormalCdf((lower - mean) / sd) : 0.0;
        this.T = upperCDF - lowerCDF;
    }

    @Override
    public double pdf(double x) {
        if (x >= this.upper || x < this.lower) {
            return 0.0;
        }
        return TruncatedNormalDistribution.standardNormalPdf((x - this.m) / this.sd) / this.sd / this.T;
    }

    @Override
    public double logPdf(double x) {
        return Math.log(this.pdf(x));
    }

    @Override
    public double cdf(double x) {
        double cdf = x < this.lower ? 0.0 : (x >= this.lower && x < this.upper ? (this.lower != Double.NEGATIVE_INFINITY ? (TruncatedNormalDistribution.standardNormalCdf((x - this.m) / this.sd) - TruncatedNormalDistribution.standardNormalCdf((this.lower - this.m) / this.sd)) / this.T : TruncatedNormalDistribution.standardNormalCdf((x - this.m) / this.sd) / this.T) : 1.0);
        return cdf;
    }

    @Override
    public double quantile(double y) {
        if (y == 0.0) {
            return this.lower;
        }
        if (y == 1.0) {
            return this.upper;
        }
        return this.quantileSearch(y, this.lower, this.upper, 20);
    }

    private double quantileSearch(double y, double l, double u, int step) {
        double q = (u + l) / 2.0;
        if (step == 0 || q == l || q == u) {
            return q;
        }
        double a = this.cdf(q);
        if (y <= a) {
            return this.quantileSearch(y, l, q, step - 1);
        }
        return this.quantileSearch(y, q, u, step - 1);
    }

    @Override
    public double mean() {
        return TruncatedNormalDistribution.mean(this.m, this.sd, this.lower, this.upper);
    }

    @Override
    public double variance() {
        return TruncatedNormalDistribution.mean(this.m, this.sd, this.lower, this.upper);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double standardNormalPdf(double x) {
        double a = 1.0 / Math.sqrt(Math.PI * 2);
        double b = -x * x / 2.0;
        return a * Math.exp(b);
    }

    public static double logStandardNormalPdf(double x) {
        return Math.log(TruncatedNormalDistribution.standardNormalPdf(x));
    }

    public static double standardNormalCdf(double x) {
        double a = x / Math.sqrt(2.0);
        return 0.5 * (1.0 + ErrorFunction.erf(a));
    }

    public static double mean(double m, double sd, double lower, double upper) {
        double au = (upper - m) / sd;
        double al = (lower - m) / sd;
        double pu = TruncatedNormalDistribution.standardNormalPdf(au);
        double pl = TruncatedNormalDistribution.standardNormalPdf(al);
        double cu = TruncatedNormalDistribution.standardNormalCdf(au);
        double cl = TruncatedNormalDistribution.standardNormalCdf(al);
        return m - sd * (pu - pl) / (cu - cl);
    }

    public static double variance(double m, double sd, double lower, double upper) {
        double au = (upper - m) / sd;
        double al = (lower - m) / sd;
        double pu = TruncatedNormalDistribution.standardNormalPdf(au);
        double pl = TruncatedNormalDistribution.standardNormalPdf(al);
        double cu = TruncatedNormalDistribution.standardNormalCdf(au);
        double cl = TruncatedNormalDistribution.standardNormalCdf(al);
        double T1 = (au * pu - al * pl) / (cu - cl);
        double T2 = (pu - pl) / (cu - cl);
        return sd * sd * (1.0 - T1 - T2 * T2);
    }
}

