/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Author;

public class Citation {
    Author[] authors;
    String title;
    int year;
    String journal;
    int volume;
    int startpage;
    int endpage;
    Status status;

    public Citation() {
    }

    public Citation(Author[] authors, Status status) {
        this(authors, null, -1, null, -1, -1, -1, status);
        if (status != Status.IN_PREPARATION) {
            throw new CitationException("Only citations in preparation may not contain titles or journals");
        }
    }

    public Citation(Author[] authors, String title, String journal, Status status) {
        this(authors, title, -1, journal, -1, -1, -1, status);
        if (status == Status.PUBLISHED) {
            throw new CitationException("Published citations must have years, volumes and pages");
        }
    }

    public Citation(Author[] authors, String title, int year, String journal, int volume, int startpage, int endpage, Status status) {
        this.authors = authors;
        this.title = title;
        this.year = year;
        this.journal = journal;
        this.volume = volume;
        this.startpage = startpage;
        this.endpage = endpage;
        this.status = status;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.authors[0].toString());
        for (int i = 1; i < this.authors.length; ++i) {
            builder.append(", ");
            builder.append(this.authors[i].toString());
        }
        builder.append(" (");
        switch (this.status) {
            case PUBLISHED: {
                builder.append(this.year);
                break;
            }
            default: {
                builder.append(this.status.getText());
            }
        }
        builder.append(") ");
        if (this.title != null) {
            builder.append(this.title);
        }
        if (this.journal != null) {
            builder.append(". ");
            builder.append(this.journal);
        }
        if (this.status == Status.PUBLISHED) {
            builder.append(". ");
            builder.append(this.volume);
            builder.append(", ");
            builder.append(this.startpage);
            if (this.endpage > 0) {
                builder.append("-").append(this.endpage);
            }
        }
        return builder.toString();
    }

    public String toHTML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append(this.authors[0].toString());
        for (int i = 1; i < this.authors.length; ++i) {
            builder.append(", ");
            builder.append(this.authors[i].toString());
        }
        builder.append(" (").append(this.year).append(") ");
        builder.append(this.title).append(". ");
        builder.append("<i>").append(this.journal).append("</i>");
        builder.append(" <b>").append(this.volume).append("</b>:");
        builder.append(this.startpage);
        if (this.endpage > 0) {
            builder.append("-").append(this.endpage);
        }
        builder.append("</html>");
        return builder.toString();
    }

    class CitationException
    extends RuntimeException {
        CitationException(String message) {
            super(message);
        }
    }

    public static enum Status {
        IN_PREPARATION("in preparation"),
        IN_SUBMISSION("in submission"),
        IN_PRESS("in press"),
        ACCEPTED("accepted"),
        PUBLISHED("published");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

