/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import conifer.evol.GTR;
import ev.ex.TreeGenerators;
import ev.io.PreprocessGutellData;
import ev.poi.PoissonModelSimulator;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import fig.prob.Gamma;
import fig.prob.SampleUtils;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MSAParser;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import nuts.io.IO;
import nuts.math.RateMtxUtils;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Indexer;
import pepper.Encodings;
import pty.RandomRootedTrees;
import pty.RootedTree;

public class DataGenerator {
    private final RootedTree phylogeny;
    private final double[][] rateMatrix;
    private final Indexer<Character> indexer;
    private final double[] stationaryDistribution;
    private Map<Taxon, Character> generatedMap;
    private boolean generateDNAdata;

    public DataGenerator(RootedTree phylogeny, double[][] rateMatrix, Indexer<Character> indexer, double[] stationaryDistribution) {
        this.phylogeny = phylogeny;
        this.rateMatrix = rateMatrix;
        this.indexer = indexer;
        this.stationaryDistribution = stationaryDistribution;
    }

    public DataGenerator(RootedTree phylogeny) {
        this.phylogeny = phylogeny;
        this.indexer = Encodings.rnaEncodings().nonGapCharactersIndexer();
        this.rateMatrix = RateMatrixLoader.k2p();
        this.stationaryDistribution = RateMtxUtils.getStationaryDistribution(this.rateMatrix);
    }

    public DataGenerator(boolean generateDNA, RootedTree phylogeny) {
        this.generateDNAdata = generateDNA;
        this.phylogeny = phylogeny;
        this.indexer = this.generateDNAdata ? Encodings.dnaEncodings().nonGapCharactersIndexer() : Encodings.rnaEncodings().nonGapCharactersIndexer();
        this.rateMatrix = RateMatrixLoader.k2p();
        this.stationaryDistribution = RateMtxUtils.getStationaryDistribution(this.rateMatrix);
    }

    public void setGenerateDNAdata(boolean generatednadata) {
        this.generateDNAdata = generatednadata;
    }

    public boolean getGenerateDNAdata() {
        return this.generateDNAdata;
    }

    public static MSAPoset generateDataFromGTRIGamma(Random rand, RootedTree tree, Indexer<Character> indexer, boolean generateDNAdata, int len, double pInv, double alpha, double[] stationaryDistribution, double[] subsRates) {
        double[][] rateMatrix0 = GTR.gtrFromOverParam(stationaryDistribution, subsRates, 4);
        double[][] rateMatrix = GTR.scaleGTRrateMat(stationaryDistribution, rateMatrix0);
        DataGenerator generator = new DataGenerator(tree, rateMatrix, indexer, stationaryDistribution);
        generator.setGenerateDNAdata(generateDNAdata);
        return generator.generate(rand, len, pInv, alpha);
    }

    public MSAPoset generate(Random rand, int len, double pInv, double alpha) {
        ArrayList<Map<Taxon, Character>> columns = CollUtils.list();
        for (int i = 0; i < len; ++i) {
            double r = 0.0;
            r = Gamma.sample(rand, alpha, alpha);
            columns.add(this.generateColumn(rand, r));
        }
        Map<Taxon, String> sequences = PoissonModelSimulator.sequences(columns, this.phylogeny);
        MSAPoset result = new MSAPoset(sequences);
        result.disableLinearization();
        HashMap<Taxon, Integer> map = CollUtils.map();
        for (int i = 0; i < len; ++i) {
            for (Taxon t : this.phylogeny.topology().leaveContents()) {
                map.put(t, i);
            }
            if (result.tryAdding(map)) continue;
            throw new RuntimeException();
        }
        result.enableLinearization();
        return result;
    }

    public Map<Taxon, Character> generateColumn(Random rand, double r) {
        this.generatedMap = new HashMap<Taxon, Character>();
        this.recurse(this.phylogeny.topology().root(), rand, r);
        for (Arbre<Taxon> node : this.phylogeny.topology().nodes()) {
            if (node.isLeaf()) continue;
            this.generatedMap.remove(node.getContents());
        }
        return this.generatedMap;
    }

    public void recurse(Arbre<Taxon> pos, Random rand, double r) {
        if (pos.isRoot()) {
            this.generatedMap.put(pos.getContents(), this.indexer.i2o(SampleUtils.sampleMultinomial(rand, this.stationaryDistribution)));
        }
        for (Arbre<Taxon> children : pos.getChildren()) {
            double t = this.phylogeny.branchLengths().get(children.getContents());
            double[][] probMatrix = RateMtxUtils.marginalTransitionMtx(this.rateMatrix, t * r);
            int index = this.indexer.o2i(this.generatedMap.get(pos.getContents()));
            int index2 = SampleUtils.sampleMultinomial(rand, probMatrix[index]);
            this.generatedMap.put(children.getContents(), this.indexer.i2o(index2));
            this.recurse(children, rand, r);
        }
    }

    public MSAPoset generate(Random rand, int len) {
        ArrayList<Map<Taxon, Character>> columns = CollUtils.list();
        for (int i = 0; i < len; ++i) {
            columns.add(this.generateColumn(rand));
        }
        Map<Taxon, String> sequences = PoissonModelSimulator.sequences(columns, this.phylogeny);
        MSAPoset result = new MSAPoset(sequences);
        result.disableLinearization();
        HashMap<Taxon, Integer> map = CollUtils.map();
        for (int i = 0; i < len; ++i) {
            for (Taxon t : this.phylogeny.topology().leaveContents()) {
                map.put(t, i);
            }
            if (result.tryAdding(map)) continue;
            throw new RuntimeException();
        }
        result.enableLinearization();
        return result;
    }

    public Map<Taxon, Character> generateColumn(Random rand) {
        this.generatedMap = new HashMap<Taxon, Character>();
        this.recurse(this.phylogeny.topology().root(), rand);
        for (Arbre<Taxon> node : this.phylogeny.topology().nodes()) {
            if (node.isLeaf()) continue;
            this.generatedMap.remove(node.getContents());
        }
        return this.generatedMap;
    }

    public void recurse(Arbre<Taxon> pos, Random rand) {
        if (pos.isRoot()) {
            this.generatedMap.put(pos.getContents(), this.indexer.i2o(SampleUtils.sampleMultinomial(rand, this.stationaryDistribution)));
        }
        for (Arbre<Taxon> children : pos.getChildren()) {
            double t = this.phylogeny.branchLengths().get(children.getContents());
            double[][] probMatrix = RateMtxUtils.marginalTransitionMtx(this.rateMatrix, t);
            int index = this.indexer.o2i(this.generatedMap.get(pos.getContents()));
            int index2 = SampleUtils.sampleMultinomial(rand, probMatrix[index]);
            this.generatedMap.put(children.getContents(), this.indexer.i2o(index2));
            this.recurse(children, rand);
        }
    }

    public static void main(String[] args) {
        IO.run(args, new DataGeneratorMain());
    }

    public static class DataGeneratorMain
    implements Runnable {
        @Option
        public int nTaxa = 10;
        @Option
        public int nReplica = 10;
        @Option
        public double treeRate = 1.0;
        @Option
        public String outputDirName = "output";
        @Option
        public int len = 100;
        @Option
        public Random rand = new Random(1L);
        @Option
        public boolean useNonclock = true;
        @Option
        public boolean useSlightNonclock = true;
        @Option
        public double sdScale = 0.2;
        @Option
        public boolean useGutellData = false;
        @Option
        public File gutellLocation;
        @Option
        public boolean useYule = false;
        @Option
        public boolean useUnif = false;
        @Option
        public boolean useFullGutellLocFile = false;
        @Option
        public boolean miniTest = false;
        @Option
        public double q = 0.5;
        @Option
        public boolean useDataGen4GTRGammaI = false;
        @Option
        public double pInv = 0.0;
        @Option
        public double alpha = 0.5;
        @Option
        public double[] stationaryDistribution = new double[]{0.2, 0.26, 0.33, 0.21};
        @Option
        public double[] subsRates = new double[]{0.26, 0.18, 0.17, 0.15, 0.11, 0.13};
        @Option
        public boolean useSeqGen = false;
        @Option
        public String seqGenPath = "/Users/liangliang/software/Seq-Gen.v1.3.3/source/seq-gen";
        @Option
        public boolean generateDNAdata = true;
        @Option
        public boolean useJC = false;
        public File output;

        public RootedTree getMiniTestTree() {
            LogInfo.logs("Using mini test!");
            String newickStr = "((A:1.0,C:" + this.q + "):0.5,(B:1.0,D:" + this.q + "):0.5);";
            return RootedTree.Util.fromNewickString(newickStr);
        }

        @Override
        public void run() {
            if (this.useYule && this.useUnif) {
                throw new RuntimeException();
            }
            if (this.useGutellData && this.len != Integer.MAX_VALUE) {
                throw new RuntimeException();
            }
            this.output = new File(Execution.getFile(this.outputDirName));
            this.output.mkdir();
            Random tempRand = new Random(this.rand.nextLong());
            List<MSAPoset> allMsas = null;
            if (this.useGutellData) {
                if (this.useFullGutellLocFile) {
                    if (this.nTaxa != Integer.MAX_VALUE) {
                        throw new RuntimeException();
                    }
                    if (this.nReplica != 1) {
                        throw new RuntimeException();
                    }
                    allMsas = Collections.singletonList(MSAParser.parseMSA(this.gutellLocation));
                } else {
                    allMsas = PreprocessGutellData.randomDataSet(this.gutellLocation, this.nReplica, this.nTaxa, this.rand);
                }
            }
            for (int i = 0; i < this.nReplica; ++i) {
                String currentName = null;
                MSAPoset msa = null;
                if (this.useGutellData) {
                    currentName = "gut-" + this.nTaxa + "-" + tempRand.nextInt();
                    msa = allMsas.get(i);
                } else {
                    currentName = "sim-" + this.rand.nextInt();
                    LogInfo.track((Object)("Creating replicon " + i + "/" + this.nReplica), true);
                    RootedTree tree = null;
                    if (this.useNonclock) {
                        if (this.useSlightNonclock && this.miniTest) {
                            throw new RuntimeException();
                        }
                        if (this.miniTest && this.nTaxa != 4) {
                            throw new RuntimeException();
                        }
                        tree = this.useSlightNonclock ? TreeGenerators.sampleExpSlightNonclock(this.rand, this.nTaxa, this.treeRate, this.sdScale) : (this.miniTest ? this.getMiniTestTree() : TreeGenerators.sampleExpNonclock(this.rand, this.nTaxa, this.treeRate));
                    } else {
                        tree = this.useYule ? RandomRootedTrees.sampleYule(this.rand, this.nTaxa, this.treeRate) : (this.useUnif ? RandomRootedTrees.sampleUnif(this.rand, this.nTaxa) : RandomRootedTrees.sampleCoalescent(this.rand, this.nTaxa, this.treeRate));
                    }
                    LogInfo.logs(tree);
                    File treeName = new File(this.output, currentName + ".newick");
                    IO.writeToDisk(treeName, RootedTree.Util.toNewick(tree));
                    if (this.useDataGen4GTRGammaI) {
                        if (!this.useSeqGen) {
                            Indexer<Character> indexer = this.generateDNAdata ? Encodings.dnaEncodings().nonGapCharactersIndexer() : Encodings.rnaEncodings().nonGapCharactersIndexer();
                            msa = DataGenerator.generateDataFromGTRIGamma(this.rand, tree, indexer, this.generateDNAdata, this.len, this.pInv, this.alpha, this.stationaryDistribution, this.subsRates);
                        } else {
                            String cmdStr = "cat " + currentName + ".newick | sed 's/internal_[0-9]*//g' > " + currentName + "-SG.newick";
                            String msg0 = IO.call("bash -s", cmdStr, this.output);
                            LogInfo.logs(msg0);
                            String cmdStrSeqGen = this.seqGenPath + " -mGTR -f" + this.arrayToString(this.stationaryDistribution) + " -r" + this.arrayToString(this.subsRates) + " -i" + this.pInv + " -l" + this.len + " -a" + this.alpha + " -n1  -op " + currentName + "-SG.newick";
                            String msg = IO.call(cmdStrSeqGen, null, this.output);
                            String segenout = currentName + "-seqgen-stdout";
                            IO.writeToDisk(new File(this.output, segenout), msg);
                            String cmd0 = "cat " + segenout + " | tail -n " + this.nTaxa + " > " + currentName + ".msf";
                            String msg00 = IO.call("bash -s", cmd0, this.output);
                            LogInfo.logs(msg00);
                        }
                    } else {
                        if (this.useJC) {
                            RateMatrixLoader.DEFAULT_TRANS2TRANV = 1.0;
                        }
                        DataGenerator generator = new DataGenerator(this.generateDNAdata, tree);
                        msa = generator.generate(this.rand, this.len);
                    }
                    if (!this.useSeqGen) {
                        LogInfo.logs(msa);
                    }
                    LogInfo.end_track();
                }
                if (this.useDataGen4GTRGammaI && this.useSeqGen) continue;
                File current = new File(this.output, currentName + ".msf");
                msa.toMultiAlignmentObject().saveToMSF(current);
                File currentFASTA = new File(this.output, currentName + ".fasta");
                msa.toFASTA(currentFASTA);
            }
        }

        public String arrayToString(double[] vec) {
            String str = "";
            for (int k = 0; k < vec.length - 1; ++k) {
                str = str + vec[k] + ",";
            }
            str = str + vec[vec.length - 1];
            return str;
        }
    }
}

