/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import goblin.Taxon;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import ma.GreedyDecoder;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.util.Counter;

public class OracleDecode {
    public static void main(String[] args) throws IOException {
        Set<Taxon> s2;
        MultiAlignment ma = MultiAlignment.parseMSFToMultiAlignment("data/gutell/processed/simple/output/block_7.msf", null, "block_7/");
        Counter<GreedyDecoder.Edge> gold = new Counter<GreedyDecoder.Edge>();
        GreedyDecoder.addToEdgeCounter(ma, gold);
        Counter<GreedyDecoder.Edge> c = new Counter<GreedyDecoder.Edge>();
        boolean headerRead = false;
        for (String line : IO.i("scratch/decode/block_7")) {
            if (line.equals("# Edge posteriors:")) {
                headerRead = true;
                continue;
            }
            if (!headerRead) continue;
            String[] fields = line.split("\\t");
            GreedyDecoder.Edge e = GreedyDecoder.Edge.fromString(fields[0]);
            double post = Double.parseDouble(fields[1]);
            c.incrementCount(e, post);
        }
        Set<Taxon> s1 = OracleDecode.getLangs(c);
        if (!s1.equals(s2 = OracleDecode.getLangs(gold))) {
            throw new RuntimeException(s1 + " vs " + s2);
        }
        for (GreedyDecoder.Edge key : c) {
            System.out.println("" + key + "\t" + c.getCount(key) + "\t" + gold.containsKey(key));
        }
    }

    private static Set<Taxon> getLangs(Counter<GreedyDecoder.Edge> c) {
        HashSet<Taxon> result = new HashSet<Taxon>();
        for (GreedyDecoder.Edge e : c.keySet()) {
            result.add(e.lang1());
            result.add(e.lang2());
        }
        return result;
    }
}

