/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.Fmt;
import fig.basic.StopWatch;
import fig.exec.servlet.Exceptions;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileException;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.Item;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.ResponseStream;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import fig.exec.servlet.WebState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

public class FileItem
extends Item {
    protected long fileSize;
    protected long lastModifiedTime;

    public FileItem(Trail trail, FileSource source) {
        this.trail = trail;
        this.source = source;
        this.fileSize = -1L;
        this.lastModifiedTime = -1L;
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("Size")) {
            return this.getFileSizeValue();
        }
        if (name.equals("Last modified")) {
            return this.getLastModifiedTimeValue();
        }
        return super.getFieldValue(name);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(new Field("Size", "Size of file"));
        fields.add(new Field("Last modified", "Time of last modification"));
        return fields;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        File path = this.source.getPath();
        if (path.exists()) {
            this.fileSize = path.length();
            this.lastModifiedTime = path.lastModified();
        } else {
            this.fileSize = -1L;
            this.lastModifiedTime = -1L;
        }
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.getOp();
        File path = this.source.getPath();
        if (op.equals("summary")) {
            return new ResponseParams("Will be supported soon");
        }
        if (op.equals("cmd")) {
            if (!perm.canExecute) {
                throw Exceptions.cantExecute("Permission denied");
            }
            String cmd = req.getReq("cmd");
            cmd = "cat " + path + " | " + cmd;
            String[] args = new String[]{"bash", "-c", cmd};
            WebState.logs("Executing: " + cmd);
            try {
                Process proc = Runtime.getRuntime().exec(args);
                return new ResponseStream(proc.getInputStream());
            }
            catch (IOException e) {
                throw Exceptions.cantExecute(e);
            }
        }
        if (op.equals("download")) {
            try {
                if (!path.getCanonicalPath().toString().startsWith(perm.accessRootDir.toString())) {
                    throw Exceptions.filePermissionDenied("Can only access " + perm.accessRootDir);
                }
                return new ResponseStream(new FileInputStream(path));
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }
        if (op.equals("purge")) {
            if (!perm.canModify) {
                throw Exceptions.filePermissionDenied("Can't purge files");
            }
            boolean ok = path.delete();
            WebState.logs("Remove " + path + ": " + ok);
            if (!ok) {
                throw Exceptions.filePermissionDenied("Can't delete " + path);
            }
            return new ResponseParams("Purged " + path);
        }
        return super.handleOperation(req, perm);
    }

    public Value getFileSizeValue() {
        if (this.fileSize == -1L) {
            return badValue;
        }
        return new Value(Fmt.bytesToString(this.fileSize), "" + this.fileSize);
    }

    public Value getLastModifiedTimeValue() {
        if (this.lastModifiedTime == -1L) {
            return badValue;
        }
        return new Value(Fmt.formatEasyDateTime(this.lastModifiedTime), "" + this.lastModifiedTime);
    }

    public Value getSinceLastModifiedTimeValue() {
        if (this.lastModifiedTime == -1L) {
            return badValue;
        }
        long time = this.getSinceLastModifiedTime();
        return new Value(new StopWatch(time).toString(), "" + time);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getSinceLastModifiedTime() {
        return new Date().getTime() - this.lastModifiedTime;
    }

    @Override
    public String toString() {
        return this.source.getPath().toString();
    }
}

