/*
 * Decompiled with CFR 0.152.
 */
package gep.util;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nuts.io.CSV;
import nuts.io.OutputProducer;
import nuts.util.CollUtils;

public class OutputManager
implements OutputProducer {
    private List<Object> additionalKeys = new ArrayList<Object>();
    private List<Object> additionalValues = new ArrayList<Object>();
    private Map<String, PrintWriter> _writers = CollUtils.map();
    private File _resultsFolder = null;
    private final int flushInterval = 5;
    private int current = 0;

    public void printWrite(String masterKey, Object ... keyValues) {
        this.write(masterKey, keyValues);
        StringBuilder toPrint = new StringBuilder();
        toPrint.append(masterKey + ": ");
        int len = keyValues.length / 2;
        for (int i = 0; i < len; ++i) {
            toPrint.append("" + keyValues[i * 2] + "=" + keyValues[i * 2 + 1] + (i == len - 1 ? "" : ", "));
        }
        LogInfo.logsForce(toPrint);
    }

    public void write(String masterKey, Object ... keyValues) {
        int i;
        if (keyValues.length % 2 != 0) {
            LogInfo.warning("Malformed OutputManager.print():" + Arrays.toString(keyValues));
            return;
        }
        boolean needPrintHeader = !this.hasWriter(masterKey);
        int len = keyValues.length / 2;
        int nExtras = this.additionalKeys.size();
        Object[] heads = needPrintHeader ? new Object[len + nExtras] : null;
        Object[] values = new Object[len + nExtras];
        for (i = 0; i < nExtras; ++i) {
            values[i] = this.additionalValues.get(i);
            if (!needPrintHeader) continue;
            heads[i] = this.additionalKeys.get(i);
        }
        for (i = 0; i < len; ++i) {
            Object key = keyValues[i * 2];
            Object value = keyValues[i * 2 + 1];
            if (needPrintHeader) {
                heads[i + nExtras] = key;
            }
            values[i + nExtras] = value;
        }
        if (needPrintHeader) {
            this.printHeader(masterKey, heads);
        }
        this.printBody(masterKey, values);
    }

    public OutputManager child(Object ... keyValues) {
        OutputManager result = new OutputManager();
        result.setOutputFolder(this.getOutputFolder());
        result.additionalKeys.addAll(this.additionalKeys);
        result.additionalValues.addAll(this.additionalValues);
        if (keyValues.length % 2 != 0) {
            LogInfo.warning("Malformed OutputManager.print():" + Arrays.toString(keyValues));
            return result;
        }
        int len = keyValues.length / 2;
        for (int i = 0; i < len; ++i) {
            Object key = keyValues[i * 2];
            Object value = keyValues[i * 2 + 1];
            result.additionalKeys.add(key);
            result.additionalValues.add(value);
        }
        return result;
    }

    public void close() {
        for (PrintWriter out : this._writers.values()) {
            out.close();
        }
    }

    public void flush() {
        for (PrintWriter out : this._writers.values()) {
            out.flush();
        }
    }

    private PrintWriter getWriter(String key) {
        PrintWriter result;
        if (++this.current % 5 == 0) {
            this.flush();
        }
        if ((result = this._writers.get(key)) != null) {
            return result;
        }
        result = IOUtils.openOutHard(new File(this.getResultsFolder(), key + ".csv"));
        this._writers.put(key, result);
        return result;
    }

    private boolean hasWriter(String key) {
        return this._writers.containsKey(key);
    }

    private File getResultsFolder() {
        if (this._resultsFolder != null) {
            return this._resultsFolder;
        }
        this._resultsFolder = new File(Execution.getFile("results"));
        this._resultsFolder.mkdir();
        return this._resultsFolder;
    }

    private void printHeader(String key, Object ... objects) {
        this.getWriter(key).println(CSV.header(objects));
    }

    private void printBody(String key, Object ... objects) {
        this.getWriter(key).println(CSV.body(objects));
    }

    @Override
    public void setOutputFolder(File f) {
        this._resultsFolder = f;
    }

    public File getOutputFolder() {
        return this.getResultsFolder();
    }
}

