/*
 * Decompiled with CFR 0.152.
 */
package ma;

import ev.io.PreprocessGutellData;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.util.CollUtils;
import org.junit.Assert;
import org.junit.Test;

public class MSATest {
    @Test
    public void testDelete() throws IOException {
        MultiAlignment ma2 = MultiAlignment.parse("/Users/bouchard/Documents/data/BAliBASE/ref1/test1/1aab.msf");
        MSAPoset msa3 = MSAPoset.fromMultiAlignmentObject(ma2);
        System.out.println(msa3);
        HashSet<Map> removed = CollUtils.set();
        Random r = new Random(1L);
        for (int i = 0; i < 100000; ++i) {
            List<MSAPoset.Column> list = msa3.linearizedColumns();
            MSAPoset.Column c = list.get(r.nextInt(list.size()));
            if (c.getPoints().size() <= 1) continue;
            System.out.println("Removing");
            removed.add(new HashMap<Taxon, Integer>(c.getPoints()));
            Taxon aTax = CollUtils.pick(c.getPoints().keySet());
            msa3.split(c, Collections.singleton(aTax));
        }
        Assert.assertTrue((!ma2.equals(msa3.toMultiAlignmentObject()) ? 1 : 0) != 0);
        System.out.println("==\n" + msa3);
        for (Map rem : removed) {
            msa3.tryAdding(rem);
        }
        MultiAlignment ma4 = msa3.toMultiAlignmentObject();
        Assert.assertEquals((Object)ma2, (Object)ma4);
        System.out.println("==\n" + msa3);
    }

    @Test
    public void testParseFasta() {
        int nTax = 10;
        MSAPoset._useParseDebug = false;
        MSAPoset gutmsa = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/Documents/data/gutell/16S.3.alnfasta"), 1, nTax, new Random(1L)).get(0);
        MSAPoset._useParseDebug = true;
        MSAPoset gutmsa2 = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/Documents/data/gutell/16S.3.alnfasta"), 1, nTax, new Random(1L)).get(0);
        MSAPoset._useParseDebug = false;
        Assert.assertEquals((Object)gutmsa.toMultiAlignmentObject(), (Object)gutmsa2.toMultiAlignmentObject());
    }

    @Test
    public void testProcessBench() {
        int nTax = 10;
        PreprocessGutellData._processBenchDebugSwitch = false;
        MSAPoset gutmsa = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/Documents/data/gutell/16S.3.alnfasta"), 1, nTax, new Random(1L)).get(0);
        PreprocessGutellData._processBenchDebugSwitch = true;
        MSAPoset gutmsa2 = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/Documents/data/gutell/16S.3.alnfasta"), 1, nTax, new Random(1L)).get(0);
        PreprocessGutellData._processBenchDebugSwitch = false;
        Assert.assertEquals((Object)gutmsa.toMultiAlignmentObject(), (Object)gutmsa2.toMultiAlignmentObject());
    }

    @Test
    public void testParse() throws IOException {
        MultiAlignment ma2 = MultiAlignment.parse("/Users/bouchard/Documents/data/BAliBASE/ref1/test1/1aab.msf");
        MSAPoset msa3 = MSAPoset.fromMultiAlignmentObject(ma2);
        MultiAlignment ma4 = msa3.toMultiAlignmentObject();
        Assert.assertEquals((Object)ma2, (Object)ma4);
        File temp = File.createTempFile("Test-msa", null);
        msa3.toFASTA(temp);
        MSAPoset msa4 = MSAPoset.parseFASTA(temp);
        MultiAlignment ma5 = msa4.toMultiAlignmentObject();
        Assert.assertEquals((Object)ma2, (Object)ma5);
        for (int nTax = 200; nTax < 211; nTax *= 2) {
            long cur = System.currentTimeMillis();
            MSAPoset gutmsa = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/Documents/data/gutell/16S.3.alnfasta"), 1, nTax, new Random(1L)).get(0);
            System.out.println("nTax=" + nTax + ",time=" + (double)(System.currentTimeMillis() - cur) / 1000.0 + "s");
        }
    }

    public static void main(String[] args) throws IOException {
        new MSATest().testParse();
    }
}

