/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import java.util.ArrayList;
import java.util.List;
import nuts.math.Fct;
import nuts.math.Sampler;

public class MCIntegrator<D> {
    private Sampler<D> sampler;
    private int iterations = 100;

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public MCIntegrator(Sampler<D> sampler) {
        this.sampler = sampler;
    }

    public List<Double> integrate(List<? extends Fct<D, Double>> fs) {
        List<Double> sums = MCIntegrator.listOfZeroes(fs.size());
        List<Double> denominators = MCIntegrator.listOfZeroes(fs.size());
        for (int i = 0; i < this.iterations; ++i) {
            D sample = this.sampler.sample();
            double weight = this.sampler.previousSampleWeigth();
            for (int j = 0; j < fs.size(); ++j) {
                double curEval = fs.get(j).evalAt(sample);
                sums.set(j, sums.get(j) + curEval * weight);
                denominators.set(j, denominators.get(j) + weight);
            }
        }
        for (int j = 0; j < fs.size(); ++j) {
            sums.set(j, sums.get(j) / denominators.get(j));
        }
        return sums;
    }

    public double integrate(Fct<D, Double> f) {
        ArrayList<Fct<D, Double>> fcs = new ArrayList<Fct<D, Double>>();
        fcs.add(f);
        List<Double> result = this.integrate(fcs);
        return result.get(0);
    }

    public static List<Double> listOfZeroes(int n) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            result.add(0.0);
        }
        return result;
    }
}

