/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;
import org.mvel2.templates.TemplateRuntime;

public class CVGenerator
implements Runnable {
    @Option
    public String templateLocation = "cv-ubc.tex";
    @Option
    public int nLatexRuns = 1;
    public List<Map<String, String>> awards = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> talks = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> services = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> pubs = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> nonrefpubs = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> subrefpubs = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> teachings = new ArrayList<Map<String, String>>();
    public List<Map<String, String>> students = new ArrayList<Map<String, String>>();
    @Option
    public String awardLocation = "/Users/bouchard/Documents/cv/autocv-v1/awards.csv";
    @Option
    public String classesLocation = "/Users/bouchard/Documents/cv/autocv-v1/classes.csv";
    @Option
    public String servicesLocation = "/Users/bouchard/Documents/cv/autocv-v1/services.csv";
    @Option
    public String talksLocation = "/Users/bouchard/Documents/cv/autocv-v1/talks.csv";
    @Option
    public String studentsLocation = "/Users/bouchard/Documents/cv/autocv-v1/students.csv";
    @Option
    public String refsLocation = "/Users/bouchard/Documents/web/ref.csv";
    @Option
    public String nonrefsLocation = "/Users/bouchard/Documents/web/nonref.csv";
    @Option
    public String subrefsLocation = "/Users/bouchard/Documents/web/subref.csv";
    @Option
    public ArrayList<String> dependencies = new ArrayList<String>(Arrays.asList("/Users/bouchard/Documents/grants/Google/google-grant-latex/res.cls"));
    @Option
    public String outFile = "cv.tex";
    static final int year = Calendar.getInstance().get(1);
    public static Comparator<Map<String, String>> mapSorter = new Comparator<Map<String, String>>(){

        @Override
        public int compare(Map<String, String> o1, Map<String, String> o2) {
            String s2;
            int c1 = 0;
            if (c1 != 0) {
                return c1;
            }
            String s1 = CollUtils.getNoNull(o1, "years", "").replaceAll(".*[-]", "").toLowerCase().replaceAll("Present", "" + year);
            int c2 = s1.compareTo(s2 = CollUtils.getNoNull(o2, "years", "").replaceAll(".*[-]", "").toLowerCase().replaceAll("Present", "" + year));
            if (c2 != 0) {
                return c2;
            }
            int c3 = CollUtils.getNoNull(o1, "years", "").replaceAll("[-].*", "").compareTo(CollUtils.getNoNull(o2, "years", "").replaceAll("[-].*", ""));
            if (c3 != 0) {
                return c3;
            }
            return CollUtils.getNoNull(o1, "name", "").compareTo(CollUtils.getNoNull(o2, "name", ""));
        }
    };

    public List<Map<String, String>> filter(List<Map<String, String>> data, String key, String value) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map<String, String> entry : data) {
            if (!value.equals(entry.get(key))) continue;
            result.add(entry);
        }
        return result;
    }

    public String f(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String printVolume(Map<String, String> pub) {
        String vol = pub.get("bib-volume");
        if (vol == null) {
            return "";
        }
        String pages = pub.get("bib-pages");
        pages = pages == null ? "" : ":" + pages;
        return vol + pages;
    }

    @Override
    public void run() {
        for (Map<String, String> line : IO.iCSVMap(this.awardLocation)) {
            this.awards.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.classesLocation)) {
            this.teachings.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.servicesLocation)) {
            this.services.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.talksLocation)) {
            this.talks.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.refsLocation)) {
            this.pubs.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.nonrefsLocation)) {
            this.nonrefpubs.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.subrefsLocation)) {
            this.subrefpubs.add(line);
        }
        for (Map<String, String> line : IO.iCSVMap(this.studentsLocation)) {
            this.students.add(line);
        }
        Collections.reverse(this.nonrefpubs);
        Collections.reverse(this.subrefpubs);
        Collections.reverse(this.pubs);
        Collections.reverse(this.talks);
        Collections.reverse(this.services);
        Collections.reverse(this.awards);
        Collections.sort(this.teachings, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String s1 = CollUtils.getNoNull(o1, "session", "");
                String s2 = CollUtils.getNoNull(o2, "session", "");
                return s1.compareTo(s2);
            }
        });
        Collections.reverse(this.teachings);
        Collections.sort(this.students, mapSorter);
        Collections.reverse(this.students);
        Collections.sort(this.services, mapSorter);
        Collections.reverse(this.services);
        String template = IO.f2s(this.templateLocation);
        LogInfo.track("Applying template");
        String result = (String)TemplateRuntime.eval((String)template, (Object)this);
        LogInfo.logsForce(result);
        LogInfo.end_track();
        LogInfo.track("Running pdflatex");
        File texFile = new File(Execution.getFile(this.outFile));
        IO.writeToDisk(texFile, result);
        for (String dep : this.dependencies) {
            IO.call("/bin/cp " + dep + " " + texFile.getParentFile().getAbsolutePath());
        }
        String pdflatexOut = "LATEX NOT RUN, SET nLatexRuns TO MORE THAN ZERO";
        for (int i = 0; i < this.nLatexRuns; ++i) {
            pdflatexOut = IO.call("pdflatex " + texFile.getName(), "x\nx\nx\nx\nx\nx\n", IO.ResultCodeBehavior.WARN, 10000L, texFile.getParentFile());
        }
        LogInfo.logsForce(pdflatexOut);
        LogInfo.end_track();
        IO.call("/usr/bin/open " + Execution.getFile(this.outFile.replaceAll("tex$", "pdf")));
    }

    public static void main(String[] args) {
        IO.run(args, new CVGenerator());
    }
}

