/*
 * Decompiled with CFR 0.152.
 */
package pedi.pheno;

import fenchel.factor.multihmm.MultiInputHMM;
import fenchel.factor.multihmm.MultiInputHMMComputations;
import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.ArrayList;
import java.util.Random;
import nuts.math.MeasureZeroException;
import pedi.main.PediMain;

public enum DiseaseTypes {
    PENETRANCE{

        @Override
        public double[][] getHiddenTransition(boolean affected) {
            return new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        }

        @Override
        public double[][] getHiddenToAlleleN(boolean affected, int allele) {
            if (allele == 0) {
                return new double[][]{{1.0, 1.0}, {1.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}};
        }

        @Override
        public double[][][] getHiddenToDiseaseIndic(boolean affected) {
            double[][][] result = new double[2][][];
            double a = PediMain.globalPenetranceParams.p2;
            double b = PediMain.globalPenetranceParams.p1;
            double c = PediMain.globalPenetranceParams.p0;
            if (!affected) {
                a = 1.0 - a;
                b = 1.0 - b;
                c = 1.0 - c;
            }
            result[0] = 1.getPenetranceModelDiseaseIndics(a, b, c);
            result[1] = new double[][]{{1.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}};
            return result;
        }

        @Override
        public double[] getInitDistribution(boolean affected) {
            return new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0};
        }

        @Override
        public double[] getEndDistribution(boolean affected) {
            return new double[]{0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        }
    }
    ,
    RECESSIVE{

        @Override
        public double[][] getHiddenTransition(boolean affected) {
            if (affected) {
                return new double[][]{{1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}};
        }

        @Override
        public double[][] getHiddenToAlleleN(boolean affected, int allele) {
            if (affected) {
                return new double[][]{{1.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}};
            }
            if (allele == 0) {
                return new double[][]{{1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {1.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        }

        @Override
        public double[][][] getHiddenToDiseaseIndic(boolean affected) {
            if (affected) {
                return new double[][][]{new double[][]{{1.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}}};
            }
            return new double[][][]{new double[][]{{1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}}};
        }

        @Override
        public double[] getInitDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[3];
                dArray2[0] = 1.0;
                dArray2[1] = 1.0;
                dArray = dArray2;
                dArray2[2] = 0.0;
            } else {
                double[] dArray3 = new double[4];
                dArray3[0] = 1.0;
                dArray3[1] = 1.0;
                dArray3[2] = 1.0;
                dArray = dArray3;
                dArray3[3] = 0.0;
            }
            return dArray;
        }

        @Override
        public double[] getEndDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[3];
                dArray2[0] = 0.0;
                dArray2[1] = 1.0;
                dArray = dArray2;
                dArray2[2] = 1.0;
            } else {
                double[] dArray3 = new double[4];
                dArray3[0] = 0.0;
                dArray3[1] = 1.0;
                dArray3[2] = 1.0;
                dArray = dArray3;
                dArray3[3] = 1.0;
            }
            return dArray;
        }
    }
    ,
    RECESSIVE2{

        @Override
        public double[][] getHiddenTransition(boolean affected) {
            if (affected) {
                return new double[][]{{1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        }

        @Override
        public double[][] getHiddenToAlleleN(boolean affected, int allele) {
            if (affected) {
                return new double[][]{{1.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
            }
            if (allele == 0) {
                return new double[][]{{1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}};
        }

        @Override
        public double[][][] getHiddenToDiseaseIndic(boolean affected) {
            if (affected) {
                return new double[][][]{new double[][]{{1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}}, new double[][]{{1.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}}};
            }
            return new double[][][]{new double[][]{{1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}}, new double[][]{{1.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}}};
        }

        @Override
        public double[] getInitDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[4];
                dArray2[0] = 1.0;
                dArray2[1] = 1.0;
                dArray2[2] = 1.0;
                dArray = dArray2;
                dArray2[3] = 0.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 1.0;
                dArray3[1] = 1.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 1.0;
                dArray = dArray3;
                dArray3[5] = 0.0;
            }
            return dArray;
        }

        @Override
        public double[] getEndDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[4];
                dArray2[0] = 0.0;
                dArray2[1] = 1.0;
                dArray2[2] = 1.0;
                dArray = dArray2;
                dArray2[3] = 1.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.0;
                dArray3[1] = 1.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 1.0;
                dArray = dArray3;
                dArray3[5] = 1.0;
            }
            return dArray;
        }
    }
    ,
    NEW_RECESSIVE{

        @Override
        public double[][] getHiddenTransition(boolean affected) {
            if (affected) {
                return new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}};
            }
            return new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}};
        }

        @Override
        public double[][] getHiddenToAlleleN(boolean affected, int allele) {
            if (affected) {
                return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}};
            }
            if (allele == 0) {
                return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}};
            }
            return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {1.0, 1.0}};
        }

        @Override
        public double[][][] getHiddenToDiseaseIndic(boolean affected) {
            if (affected) {
                return new double[][][]{new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}}};
            }
            return new double[][][]{new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}}};
        }

        @Override
        public double[] getInitDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[5];
                dArray2[0] = 1.0;
                dArray2[1] = 0.0;
                dArray2[2] = 1.0;
                dArray2[3] = 0.0;
                dArray = dArray2;
                dArray2[4] = 0.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 1.0;
                dArray3[1] = 0.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.0;
                dArray = dArray3;
                dArray3[5] = 0.0;
            }
            return dArray;
        }

        @Override
        public double[] getEndDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[5];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 1.0;
                dArray2[3] = 0.0;
                dArray = dArray2;
                dArray2[4] = 1.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.0;
                dArray = dArray3;
                dArray3[5] = 1.0;
            }
            return dArray;
        }
    }
    ,
    NEW_RECESSIVE2{

        @Override
        public double[][] getHiddenTransition(boolean affected) {
            if (affected) {
                return new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}};
            }
            return new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}};
        }

        @Override
        public double[][] getHiddenToAlleleN(boolean affected, int allele) {
            if (affected) {
                return new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
            }
            if (allele == 0) {
                return new double[][]{{1.0, 0.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
            }
            return new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}, {1.0, 1.0}};
        }

        @Override
        public double[][][] getHiddenToDiseaseIndic(boolean affected) {
            if (affected) {
                return new double[][][]{new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}}};
            }
            return new double[][][]{new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 0.0}}};
        }

        @Override
        public double[] getInitDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[5];
                dArray2[0] = 1.0;
                dArray2[1] = 0.0;
                dArray2[2] = 1.0;
                dArray2[3] = 0.0;
                dArray = dArray2;
                dArray2[4] = 0.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 1.0;
                dArray3[1] = 0.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.0;
                dArray = dArray3;
                dArray3[5] = 0.0;
            }
            return dArray;
        }

        @Override
        public double[] getEndDistribution(boolean affected) {
            double[] dArray;
            if (affected) {
                double[] dArray2 = new double[5];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 1.0;
                dArray2[3] = 0.0;
                dArray = dArray2;
                dArray2[4] = 1.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                dArray3[2] = 1.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.0;
                dArray = dArray3;
                dArray3[5] = 1.0;
            }
            return dArray;
        }
    };


    public abstract double[][] getHiddenTransition(boolean var1);

    public abstract double[][] getHiddenToAlleleN(boolean var1, int var2);

    public abstract double[][][] getHiddenToDiseaseIndic(boolean var1);

    public abstract double[] getInitDistribution(boolean var1);

    public abstract double[] getEndDistribution(boolean var1);

    public int nDiseaseNodes() {
        int result = this.getHiddenToDiseaseIndic(false).length;
        if (result != this.getHiddenToDiseaseIndic(true).length) {
            throw new RuntimeException();
        }
        return result;
    }

    public MultiInputHMM getMSHMM(boolean affected) {
        return DiseaseTypes.createMSHMM(this.getHiddenTransition(affected), this.getHiddenToAlleleN(affected, 0), this.getHiddenToAlleleN(affected, 1), this.getHiddenToDiseaseIndic(affected), this.getInitDistribution(affected), this.getEndDistribution(affected));
    }

    public static MultiInputHMM createMSHMM(double[][] hiddenTrans, double[][] hidden2FirstAllele, double[][] hidden2SecondAllele, double[][][] hidden2DiseaseIndic, double[] initDist, double[] endDist) {
        double[][][] emi = new double[2 + hidden2DiseaseIndic.length][][];
        emi[0] = hidden2FirstAllele;
        emi[1] = hidden2SecondAllele;
        for (int i = 0; i < hidden2DiseaseIndic.length; ++i) {
            emi[2 + i] = hidden2DiseaseIndic[i];
        }
        return new MultiInputHMM(hiddenTrans, initDist, endDist, emi);
    }

    public boolean sampleAffection(Random rand, double[][] firstAllelePots, double[][] secondAllelePots, double[][][] diseaseIndicsPots) {
        double[] norms = new double[2];
        try {
            norms[0] = DiseaseTypes.logNorm(firstAllelePots, secondAllelePots, diseaseIndicsPots, this.getMSHMM(false));
        }
        catch (MeasureZeroException mze) {
            norms[0] = Double.NEGATIVE_INFINITY;
        }
        try {
            norms[1] = DiseaseTypes.logNorm(firstAllelePots, secondAllelePots, diseaseIndicsPots, this.getMSHMM(true));
        }
        catch (MeasureZeroException mze) {
            norms[1] = Double.NEGATIVE_INFINITY;
        }
        NumUtils.expNormalize(norms);
        return SampleUtils.sampleMultinomial(rand, norms) != 0;
    }

    private static double logNorm(double[][] firstAllelePots, double[][] secondAllelePots, double[][][] diseaseIndicsPots, MultiInputHMM hmm) {
        ArrayList<double[][]> inputs = new ArrayList<double[][]>();
        inputs.add(firstAllelePots);
        inputs.add(secondAllelePots);
        for (double[][] item : diseaseIndicsPots) {
            inputs.add(item);
        }
        return MultiInputHMMComputations.logNorm(inputs, hmm);
    }

    public static double[][] getPenetranceModelDiseaseIndics(double a, double b, double c) {
        return new double[][]{{1.0, 0.0}, {0.0, a}, {0.0, b}, {0.0, b}, {0.0, c}, {0.0, a}, {0.0, b}, {0.0, b}, {0.0, c}, {1.0, 0.0}};
    }
}

