/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import fig.prob.SampleUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import nuts.io.IO;
import pepper.Encodings;
import pepper.editmodel.EditParam;
import pepper.editmodel.SinkWordSampler;

public class DataGenerator {
    private String[] topLang;
    private String[] bottomLang;
    private final EditParam params;
    private int vocabSize;

    private Encodings enc() {
        return this.params.getEncodings();
    }

    public DataGenerator(String[] words, EditParam evolutionaryParams) {
        this.bottomLang = new String[words.length];
        this.topLang = words;
        this.params = evolutionaryParams;
        this.vocabSize = words.length;
    }

    public String[] generate() {
        for (int j = 0; j < this.vocabSize; ++j) {
            SinkWordSampler sampler = new SinkWordSampler(new Random(), this.params, this.topLang[j]);
            sampler.sample();
            this.bottomLang[j] = sampler.getSampledWord();
        }
        return this.bottomLang;
    }

    public static void main(String[] args) throws IOException {
        DataGeneratorOptions dgo = new DataGeneratorOptions();
        Execution.init(args, "options", dgo, "Encodings", Encodings.class);
        dgo.go();
        Execution.finish();
    }

    public static class DataGeneratorOptions {
        @Option(gloss="File to load the \"ancient\" language from", required=true)
        public String ancientLangFile;
        @Option(gloss="Where to output the result", required=true)
        public String outputPrefix;
        @Option(gloss="Edit parameters. If null, they will be generate")
        public String editParamsFile = null;
        @Option(gloss="Number of rules to generate.")
        public int numberOfGenRules = 10;
        @Option(gloss="Stick breaking param to generate them")
        public double alpha = 1.0;
        @Option(gloss="Poisson mean of number of possibilities")
        public double branchingMean = 2.0;
        @Option
        public Random rand;

        public void go() throws IOException {
            Encodings enc = Encodings.realEncoding();
            System.out.println("Current encodings:");
            IO.so("" + enc);
            EditParam params = null;
            params = this.editParamsFile != null ? EditParam.parseEditParam(enc, this.editParamsFile) : this.generateRules(enc);
            ArrayList<String> ancientLang = new ArrayList<String>();
            for (String line : IO.i(this.ancientLangFile)) {
                ancientLang.add(line);
            }
            String[] words = new String[ancientLang.size()];
            for (int i = 0; i < words.length; ++i) {
                String word;
                words[i] = word = (String)ancientLang.get(i);
            }
            DataGenerator generator = new DataGenerator(words, params);
            generator.generate();
            PrintWriter out = IOUtils.openOut(this.outputPrefix + ".gen");
            for (int j = 0; j < ancientLang.size(); ++j) {
                out.append(generator.bottomLang[j] + "\n");
            }
            out.close();
        }

        private EditParam generateRules(Encodings enc) throws IOException {
            int C = enc.getNumberOfPhonemes();
            int N2 = enc.getNumberOfEqClasses();
            double[][][] deletionCosts = new double[N2][C][N2];
            double[][][][] substitutionCosts = new double[N2][C][N2][C];
            double[][][][][] fissionCosts = new double[N2][C][N2][C][C];
            boolean[][][] envSelected = new boolean[N2][C][N2];
            int nRules = 0;
            block0: for (String line : IO.i(this.ancientLangFile)) {
                for (int i = 0; i < line.length(); ++i) {
                    int c2;
                    if (nRules >= this.numberOfGenRules) break block0;
                    int x = enc.char2PhoneId(line.charAt(i));
                    int c1 = enc.topc(line, i - 1);
                    if (envSelected[c1][x][c2 = enc.topc(line, i + 1)]) continue;
                    envSelected[c1][x][c2] = true;
                    ++nRules;
                    int branching = (int)SampleUtils.samplePoisson(this.rand, this.branchingMean);
                    for (int cBranch = 0; cBranch < branching; ++cBranch) {
                        int random = this.rand.nextInt(1 + 2 * C);
                        if (random != 0) continue;
                    }
                }
            }
            return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
        }
    }
}

