/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pepper.Effect;
import pepper.Encodings;
import pepper.Environment;
import pepper.PhonemeEqClass;

public class Edit
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int c1;
    public final int c2;
    public final int x;
    public final int y;
    public final int z;
    private final Encodings enc;
    private static Pattern deletionPattern = Pattern.compile("\\s*([^ ])\\s+[-][>]\\s+[/]\\s+([^ ]+)\\s+[_]\\s([^ ]+)\\s*");
    private static Pattern substitutionPattern = Pattern.compile("\\s*([^ ])\\s+[-][>]\\s+([^ ])\\s+[/]\\s+([^ ]+)\\s+[_]\\s([^ ]+)\\s*");
    private static Pattern fissionPattern = Pattern.compile("\\s*([^ ])\\s+[-][>]\\s+([^ ])\\s+([^ ])\\s+[/]\\s+([^ ]+)\\s+[_]\\s([^ ]+)\\s*");

    public Encodings getEncodings() {
        return this.enc;
    }

    public Edit(Encodings enc, int c1, int x, int c2, int y, int z) {
        this.c1 = c1;
        this.x = x;
        this.c2 = c2;
        this.y = y;
        this.z = z;
        this.enc = enc;
    }

    public Edit(Encodings enc, int c1, int x, int c2, int y) {
        this.c1 = c1;
        this.x = x;
        this.c2 = c2;
        this.y = y;
        this.z = -1;
        this.enc = enc;
    }

    public Edit(Encodings enc, int c1, int x, int c2) {
        this.c1 = c1;
        this.x = x;
        this.c2 = c2;
        this.y = -1;
        this.z = -1;
        this.enc = enc;
    }

    public Edit(Encodings enc, Environment env, Effect eff) {
        this.c1 = env.c1;
        this.x = env.x;
        this.c2 = env.c2;
        this.y = eff.y;
        this.z = eff.z;
        this.enc = enc;
    }

    public Environment getEnvironment() {
        return new Environment(this.enc, this.c1, this.x, this.c2);
    }

    public Effect getEffect() {
        return new Effect(this.enc, this.y, this.z);
    }

    public EditType getEditType() {
        if (this.y == -1) {
            return EditType.DELETION;
        }
        if (this.z == -1) {
            return EditType.SUBSTITUTION;
        }
        return EditType.FISSION;
    }

    public boolean isDeletion() {
        return this.getEditType().equals((Object)EditType.DELETION);
    }

    public boolean isSubstitution() {
        return this.getEditType().equals((Object)EditType.SUBSTITUTION);
    }

    public boolean isFission() {
        return this.getEditType().equals((Object)EditType.FISSION);
    }

    public boolean isInDelSub() {
        if (this.isDeletion()) {
            return true;
        }
        if (this.isSubstitution()) {
            return true;
        }
        return this.isInsertion();
    }

    public boolean isInsertion() {
        if (this.isLeftInsertion()) {
            return true;
        }
        return this.isRightInsertion();
    }

    public boolean isLeftInsertion() {
        if (!this.isFission()) {
            return false;
        }
        if (this.x == this.y && this.x == this.z) {
            return false;
        }
        return this.x == this.z;
    }

    public boolean isRightInsertion() {
        if (!this.isFission()) {
            return false;
        }
        return this.x == this.y;
    }

    public String toString() {
        if (this.y == -1) {
            return String.format("%c -> / %s _ %s", Character.valueOf(this.x2s(this.x)), this.c2s(this.c1), this.c2s(this.c2));
        }
        if (this.z == -1) {
            return String.format("%c -> %c / %s _ %s", Character.valueOf(this.x2s(this.x)), Character.valueOf(this.x2s(this.y)), this.c2s(this.c1), this.c2s(this.c2));
        }
        return String.format("%c -> %c %c / %s _ %s", Character.valueOf(this.x2s(this.x)), Character.valueOf(this.x2s(this.y)), Character.valueOf(this.x2s(this.z)), this.c2s(this.c1), this.c2s(this.c2));
    }

    public boolean isSelfSubstitution() {
        return this.getEditType().equals((Object)EditType.SUBSTITUTION) && this.x == this.y;
    }

    public String contextFreeToString() {
        if (this.y == -1) {
            return String.format("%c -> ", Character.valueOf(this.x2s(this.x)));
        }
        if (this.z == -1) {
            return String.format("%c -> %c", Character.valueOf(this.x2s(this.x)), Character.valueOf(this.x2s(this.y)));
        }
        return String.format("%c -> %c %c ", Character.valueOf(this.x2s(this.x)), Character.valueOf(this.x2s(this.y)), Character.valueOf(this.x2s(this.z)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Edit)) {
            return false;
        }
        Edit o_cast = (Edit)o;
        if (this.c1 != o_cast.c1) {
            return false;
        }
        if (this.c2 != o_cast.c2) {
            return false;
        }
        if (this.x != o_cast.x) {
            return false;
        }
        if (this.y != o_cast.y) {
            return false;
        }
        return this.z == o_cast.z;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + this.c1;
        hashCode = 29 * hashCode + this.c2;
        hashCode = 29 * hashCode + this.x;
        hashCode = 29 * hashCode + this.y;
        hashCode = 29 * hashCode + this.z;
        return hashCode;
    }

    private char x2s(int x) {
        return this.enc.phoneId2Char(x);
    }

    private String c2s(int c) {
        return this.enc.getEqClassDescription(c);
    }

    public static Set<Environment> allEnvironments(Encodings enc) {
        HashSet<Environment> allEnvironments = new HashSet<Environment>();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int x = 0; x < alpha; ++x) {
                for (int c2 = 0; c2 < NC; ++c2) {
                    allEnvironments.add(new Environment(enc, c1, x, c2));
                }
            }
        }
        return allEnvironments;
    }

    public static Set<Edit> allEdits(Encodings enc) {
        HashSet<Edit> allEdits = new HashSet<Edit>();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int x = 0; x < alpha; ++x) {
                for (int c2 = 0; c2 < NC; ++c2) {
                    allEdits.add(new Edit(enc, c1, x, c2));
                    for (int y = 0; y < alpha; ++y) {
                        allEdits.add(new Edit(enc, c1, x, c2, y));
                        for (int z = 0; z < alpha; ++z) {
                            allEdits.add(new Edit(enc, c1, x, c2, y, z));
                        }
                    }
                }
            }
        }
        return allEdits;
    }

    public static Edit parseEdit(Encodings enc, String stringRepn) {
        if (stringRepn.matches("\\s*[^ ]\\s+[-][>]\\s+[/]\\s+[^ ]+\\s+[_]\\s[^ ]+\\s*")) {
            Matcher m = deletionPattern.matcher(stringRepn);
            m.find();
            String x = m.group(1);
            int xCode = enc.char2PhoneId(x.charAt(0));
            PhonemeEqClass c1 = new PhonemeEqClass(m.group(2));
            int c1Code = enc.getEqClassIndex(c1);
            PhonemeEqClass c2 = new PhonemeEqClass(m.group(3));
            int c2Code = enc.getEqClassIndex(c2);
            if (xCode == -1 || c1Code == -1 || c2Code == -1) {
                throw new RuntimeException("Parsing error: " + stringRepn);
            }
            return new Edit(enc, c1Code, xCode, c2Code);
        }
        if (stringRepn.matches("\\s*[^ ]\\s+[-][>]\\s+[^ ]\\s+[/]\\s+[^ ]+\\s+[_]\\s[^ ]+\\s*")) {
            Matcher m = substitutionPattern.matcher(stringRepn);
            m.find();
            String x = m.group(1);
            int xCode = enc.char2PhoneId(x.charAt(0));
            String y = m.group(2);
            int yCode = enc.char2PhoneId(y.charAt(0));
            PhonemeEqClass c1 = new PhonemeEqClass(m.group(3));
            int c1Code = enc.getEqClassIndex(c1);
            PhonemeEqClass c2 = new PhonemeEqClass(m.group(4));
            int c2Code = enc.getEqClassIndex(c2);
            if (xCode == -1 || yCode == -1 || c1Code == -1 || c2Code == -1) {
                throw new RuntimeException("Parsing error: " + stringRepn);
            }
            return new Edit(enc, c1Code, xCode, c2Code, yCode);
        }
        if (stringRepn.matches("\\s*[^ ]\\s+[-][>]\\s+[^ ]\\s+[^ ]\\s+[/]\\s+[^ ]+\\s+[_]\\s[^ ]+\\s*")) {
            Matcher m = fissionPattern.matcher(stringRepn);
            m.find();
            String x = m.group(1);
            int xCode = enc.char2PhoneId(x.charAt(0));
            String y = m.group(2);
            int yCode = enc.char2PhoneId(y.charAt(0));
            String z = m.group(3);
            int zCode = enc.char2PhoneId(z.charAt(0));
            PhonemeEqClass c1 = new PhonemeEqClass(m.group(4));
            int c1Code = enc.getEqClassIndex(c1);
            PhonemeEqClass c2 = new PhonemeEqClass(m.group(5));
            int c2Code = enc.getEqClassIndex(c2);
            if (xCode == -1 || yCode == -1 || zCode == -1 || c1Code == -1 || c2Code == -1) {
                throw new RuntimeException("Parsing error: " + stringRepn);
            }
            return new Edit(enc, c1Code, xCode, c2Code, yCode, zCode);
        }
        throw new RuntimeException("Parsing exception: " + stringRepn);
    }

    public static String printEdits(List<Edit> edits) {
        if (edits == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int j = 0;
        for (int i = 0; i < edits.size(); ++i) {
            Edit edit = edits.get(i);
            if (edit.isSelfSubstitution()) continue;
            if (j != 0) {
                builder.append("; ");
            }
            ++j;
            builder.append(edit.toString());
        }
        return builder.toString();
    }

    public static enum EditType {
        FISSION,
        SUBSTITUTION,
        DELETION;

    }
}

