/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.util.Iterator;
import nuts.util.Counter;
import pepper.FeatureVector;

public class SparseFeatureVector
implements FeatureVector {
    private Counter<String> counter = new Counter();
    private String stringRepn = null;

    public SparseFeatureVector() {
    }

    public SparseFeatureVector(FeatureVector model) {
        for (String key : model) {
            double count = model.getValue(key);
            this.counter.setCount(key, count);
        }
    }

    @Override
    public double getValue(String feature) {
        return this.counter.getCount(feature);
    }

    @Override
    public void setValue(String feature, double value) {
        this.counter.setCount(feature, value);
    }

    @Override
    public void incrValue(String feature, double value) {
        this.counter.incrementCount(feature, value);
    }

    @Override
    public void add(FeatureVector v2, double scalingFactor) {
        for (String key : v2) {
            double increment = v2.getValue(key) * scalingFactor;
            this.counter.incrementCount(key, increment);
        }
    }

    public String toString() {
        if (this.stringRepn != null) {
            return this.stringRepn;
        }
        int c = 0;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String key : this.counter) {
            if (c > 0) {
                sb.append(' ');
            }
            if (++c > 10) {
                sb.append(" ...");
                break;
            }
            sb.append(key + ":" + this.counter.getCount(key));
        }
        sb.append(']');
        return sb.toString();
    }

    public void setStringRepn(String stringRepn) {
        this.stringRepn = stringRepn;
    }

    @Override
    public Iterator<String> iterator() {
        return this.counter.iterator();
    }
}

