/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.Option;
import java.util.Random;

public class MainOptions {
    @Option(gloss="Number of modern words that should be kept for held-out, default=0")
    public int heldOutSize = 0;
    @Option(gloss="Interval at which stats will be dumped")
    public int statDumpInterval = 2;
    @Option(gloss="Randomness")
    public Random random = new Random(1L);
    @Option(gloss="Limit the number of words to load.")
    public int wordsLimit = Integer.MAX_VALUE;
    @Option(gloss="Maximum number of iterations")
    public int maxIters = 30;
    @Option(gloss="Type of rules to create")
    public RuleType ruleType = RuleType.IN_DEL_SUB;
    @Option(gloss="Rules below this will be pruned during sampling.")
    public double lowPrThreshold = 0.0;
    @Option(gloss="The topology of the evolutionary model that should be used.")
    public Topology topology = Topology.GENERAL_TREE_SAMPLER;
    @Option(gloss="File where the rules should be loaded from.", condReq="pepper.ruleType=FILE")
    public String ruleFile = null;
    @Option(gloss="Words where the corpus is loaded from", required=true)
    public String languages;
    @Option(gloss="Code for unknown word entries.")
    public String UNK = "?";
    @Option(gloss="Enable automatic maximum deviations.")
    public boolean maxDeviationEnabled = false;
    @Option(gloss="Bound on max dev (if enabled) = ,max delta length in the markov blanket + maxAdditionalDeviation.")
    public int maxAdditionalDeviation = 3;
    @Option(gloss="Spec. of the heldout props, format ([lang]:[prop]/)*. ")
    public String heldOutProps = "";
    @Option(gloss="Discound on the LM.")
    public double lmDiscount = 1.0;
    @Option(gloss="Specifications of the tree topology.", required=true)
    public String treeTopologySpecification;
    @Option(gloss="Type of initialization")
    public InitType initType = InitType.STANDARD;
    @Option(gloss="Initialization prior for rules x->x")
    public double initSelfSub = 90.0;
    @Option(gloss="Initialization prior for rules x->y")
    public double initSub = 8.0;
    @Option(gloss="Initialization prior for rules x->")
    public double initDel = 1.0;
    @Option(gloss="Initialization prior for rules x->y x or x->y x")
    public double initFis = 1.0;
    @Option(gloss="Use the true answer for initialization (for debug)")
    public boolean cheatInit = false;
    @Option(gloss="Number of sample to print in the stats for each word")
    public int numberOfSamples = 0;
    @Option(gloss="Number of E step to do in each sampling/EM iterations (in the inner loop of the word sampling)")
    public int eIters = 20;
    @Option(gloss="Number of E step to do in each sampling/EM iterations (in the outer loop--much slower)")
    public int outerEIters = 1;
    @Option(gloss="Use EM? (otherwise, Gibbs)")
    public boolean useEM = true;
    @Option(gloss="Viterbi EM-style update of the derivations")
    public boolean viterbiEM = false;
    @Option(gloss="Perform viterbi eval?")
    public boolean viterbiEval = true;
    @Option(gloss="Use lm for every lang with observed word?")
    public boolean multiLM = false;
    @Option
    public boolean useOnlyFullEntries = true;
    @Option(gloss="Restrict the support of the EditParam using the pruned representation")
    public boolean restrictSupport = true;
    @Option
    public boolean freqEditsDump = true;

    public static enum Topology {
        CHAIN_SAMPLER,
        GAMMA_TREE_SAMPLER,
        GENERAL_TREE_SAMPLER;

    }

    public static enum InitType {
        STANDARD,
        USING_UNOBSERVEDWORDSAMPLER,
        USING_PRIOR;

    }

    public static enum RuleType {
        IN_DEL_SUB,
        CONS_VOW,
        RESTRICTED,
        FILE;

    }
}

