/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import java.util.Set;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.EditParam;

public class TreeSampler {
    public static EditParam initEditParam(Encodings enc, Set<Edit> sparseStructure, double initDel, double initSelfSub, double initSub, double initFis, boolean allowGenFis) {
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int x = 0; x < alpha; ++x) {
                for (int c2 = 0; c2 < NC; ++c2) {
                    if (sparseStructure == null || sparseStructure.contains(new Edit(enc, c1, x, c2))) {
                        deletionCosts[c1][x][c2] = initDel;
                    }
                    for (int y = 0; y < alpha; ++y) {
                        if (y == x) {
                            substitutionCosts[c1][x][c2][y] = initSelfSub;
                        } else if (sparseStructure == null || sparseStructure.contains(new Edit(enc, c1, x, c2, y))) {
                            substitutionCosts[c1][x][c2][y] = initSub;
                        }
                        for (int z = 0; z < alpha; ++z) {
                            if (!allowGenFis && z != x && y != x || sparseStructure != null && !sparseStructure.contains(new Edit(enc, c1, x, c2, y, z))) continue;
                            fissionCosts[c1][x][c2][y][z] = initFis;
                        }
                    }
                }
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts).normalize();
    }
}

