/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.Pair;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.HLFeatureExtractor;
import goblin.HLParams;
import goblin.Taxon;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Counter;
import pepper.Encodings;

public class FatContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LONG_HORIZON = 5;
    private final Map<Granularity, Object> characteristics;
    private final HLParams.HLContext baseContext;

    private FatContext(HLParams.HLContext base, Map<Granularity, Object> characteristics) {
        this.baseContext = base;
        this.characteristics = characteristics;
    }

    public static FatContext fatContext(HLParams.HLContext context, int cInsL, int cDelL, char topPrev, char topNext, char prevPrev, CognateId id) {
        HashMap<Granularity, Object> charact = new HashMap<Granularity, Object>();
        charact.put(Granularity.GAP_LENGTHS, Pair.makePair(cInsL, cDelL));
        charact.put(Granularity.NEXT_TOP, Character.valueOf(topNext));
        charact.put(Granularity.PREV_TOP, Character.valueOf(topPrev));
        charact.put(Granularity.COGNATE_ID, id);
        charact.put(Granularity.PREVPREV, Character.valueOf(prevPrev));
        return new FatContext(context, charact);
    }

    public static FatContext baseFatContext(HLParams.HLContext context) {
        HashMap<Granularity, Object> charact = new HashMap<Granularity, Object>();
        return new FatContext(context, charact);
    }

    public int insGapLength() {
        Object result = this.characteristics.get((Object)Granularity.GAP_LENGTHS);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Integer)((Pair)result).getFirst();
    }

    public int delGapLength() {
        Object result = this.characteristics.get((Object)Granularity.GAP_LENGTHS);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Integer)((Pair)result).getSecond();
    }

    public boolean isHydrophilic() {
        Object result = this.characteristics.get((Object)Granularity.HYDROPHOBIC);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Boolean)result;
    }

    public Character nextTop() {
        Object result = this.characteristics.get((Object)Granularity.NEXT_TOP);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Character)result;
    }

    public CognateId cognateId() {
        Object result = this.characteristics.get((Object)Granularity.COGNATE_ID);
        if (result == null) {
            throw new RuntimeException();
        }
        return (CognateId)result;
    }

    public Character prevTop() {
        Object result = this.characteristics.get((Object)Granularity.PREV_TOP);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Character)result;
    }

    public Character prevPrev() {
        Object result = this.characteristics.get((Object)Granularity.PREVPREV);
        if (result == null) {
            throw new RuntimeException();
        }
        return (Character)result;
    }

    public boolean equals(Object obj) {
        FatContext other = (FatContext)obj;
        if (!other.baseContext.equals(this.baseContext)) {
            return false;
        }
        return other.characteristics.equals(this.characteristics);
    }

    public int hashCode() {
        return 29 * this.characteristics.hashCode() + this.baseContext.hashCode();
    }

    public String toString() {
        return "" + this.baseContext.toString() + "&" + this.characteristics.toString();
    }

    public static LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> project(LabeledInstance<FatContext, HLParams.HLOutcome> initial) {
        return LabeledInstance.create(initial.getLabel(), initial.getInput().getBaseContext());
    }

    public HLParams.HLContext getBaseContext() {
        return this.baseContext;
    }

    public static void addSuffStats(Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> counter, Arbre<DerivationTree.DerivationNode> a, Set<Granularity> granularities, Encodings enc, CognateId id) {
        FatContext.addSuffStatsFromLineagedTree(counter, DerivationTree.fullLineage(a), granularities, enc, id);
    }

    public static void addSuffStatsFromLineagedTree(Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> counter, Arbre<DerivationTree.LineagedNode> a, Set<Granularity> granularities, Encodings enc, CognateId id) {
        a = a.root();
        for (Arbre<DerivationTree.LineagedNode> node : a.nodes()) {
            if (node.isRoot()) continue;
            FatSuffStatExtractor fssf = new FatSuffStatExtractor(node.getContents().getDerivationNode().getDerivation(), granularities, node.getContents().getDerivationNode().getLanguage(), enc, node.getParent().getContents().getWindow(), node.getContents().getWindow(), id);
            fssf.extract();
            counter.incrementAll(fssf.ctxts);
        }
        FatContext.addRootSuffStats(granularities, counter, a.getContents().getDerivationNode().getWord(), a.getContents().getDerivationNode().getLanguage(), enc, a.getContents().getWindow(), id);
    }

    private static void addRootSuffStats(Set<Granularity> granularities, Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> ctxts, String rootWord, Taxon lang, Encodings enc, DerivationTree.Window originalWindow, CognateId id) {
        String B = "" + enc.phoneId2Char(enc.getBoundaryPhoneId());
        rootWord = B + rootWord + B;
        originalWindow = originalWindow.enlarge(rootWord.length(), FatContext.maxInfluenceRadius(granularities) + 1);
        for (int i = 1; i < rootWord.length(); ++i) {
            if (!originalWindow.contains(i)) continue;
            HashMap<Granularity, Object> characteristics = new HashMap<Granularity, Object>();
            LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> baseSuffStat = HLParams.createRootSuffStat(lang, enc, enc.char2PhoneId(rootWord.charAt(i - 1)), enc.char2PhoneId(rootWord.charAt(i)));
            if (granularities.contains((Object)Granularity.COGNATE_ID)) {
                characteristics.put(Granularity.COGNATE_ID, id);
            }
            if (granularities.contains((Object)Granularity.PREVPREV)) {
                characteristics.put(Granularity.PREVPREV, Character.valueOf(enc.charAt(rootWord, i - 2)));
            }
            ctxts.incrementCount(new LabeledInstance<FatContext, HLParams.HLOutcome>(baseSuffStat.getLabel(), new FatContext(baseSuffStat.getInput(), characteristics)), 1.0);
        }
    }

    public static int maxInfluenceRadius(Set<Granularity> granularities) {
        int max = 0;
        for (Granularity gran : granularities) {
            if (gran.influenceRadius() <= max) continue;
            max = gran.influenceRadius();
        }
        return max;
    }

    public static boolean isLongDel(LabeledInstance<FatContext, HLParams.HLOutcome> instance) {
        return HLFeatureExtractor.isDeletion(FatContext.project(instance)) && instance.getInput().delGapLength() > 0;
    }

    public static boolean isLongIns(LabeledInstance<FatContext, HLParams.HLOutcome> instance) {
        return HLFeatureExtractor.isPhonemeInsertion(FatContext.project(instance)) && instance.getInput().insGapLength() > 0;
    }

    private static class FatSuffStatExtractor
    extends HLParams.StatExtractor {
        private final Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> ctxts = new Counter();
        private final Set<Granularity> granularities;
        private final HLParams.BranchSuffStatExtractor baseExtractor;
        private final Taxon botLang;
        private final CognateId id;
        private int cInsLength = 0;
        private int cDelLength = 0;

        public FatSuffStatExtractor(DerivationTree.Derivation d, Set<Granularity> granularities, Taxon botLang, Encodings enc, DerivationTree.Window originalTopWin, DerivationTree.Window originalBotWin, CognateId id) {
            super(d, originalTopWin, originalBotWin, FatContext.maxInfluenceRadius(granularities));
            this.botLang = botLang;
            this.id = id;
            this.granularities = granularities;
            this.baseExtractor = new HLParams.BranchSuffStatExtractor(new Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>>(), d, botLang, enc, originalTopWin, originalBotWin);
        }

        private void resetInDelLengths() {
            this.cInsLength = 0;
            this.cDelLength = 0;
        }

        private void createAndIncrement(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> baseSuffStat, FatContext ctxt) {
            this.ctxts.incrementCount(new LabeledInstance<FatContext, HLParams.HLOutcome>(baseSuffStat.getLabel(), ctxt), 1.0);
        }

        private void add(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> baseSuffStat, int top, int prevBot) {
            HashMap<Granularity, Serializable> characteristics = new HashMap<Granularity, Serializable>();
            if (this.granularities.contains((Object)Granularity.COGNATE_ID)) {
                characteristics.put(Granularity.COGNATE_ID, this.id);
            }
            if (this.granularities.contains((Object)Granularity.GAP_LENGTHS)) {
                characteristics.put(Granularity.GAP_LENGTHS, Pair.makePair(this.cInsLength, this.cDelLength));
            }
            if (this.granularities.contains((Object)Granularity.NEXT_TOP)) {
                characteristics.put(Granularity.NEXT_TOP, Character.valueOf(this.baseExtractor.enc.charAt(this.d.getAncestorWord(), top + 1)));
            }
            if (this.granularities.contains((Object)Granularity.PREV_TOP)) {
                characteristics.put(Granularity.PREV_TOP, Character.valueOf(this.baseExtractor.enc.charAt(this.d.getAncestorWord(), top - 1)));
            }
            if (this.granularities.contains((Object)Granularity.HYDROPHOBIC)) {
                characteristics.put(Granularity.HYDROPHOBIC, Boolean.valueOf(this.isHydrophobic(this.d.getAncestorWord(), top)));
            }
            if (this.granularities.contains((Object)Granularity.PREVPREV)) {
                characteristics.put(Granularity.PREVPREV, Character.valueOf(this.baseExtractor.enc.charAt(this.d.getCurrentWord(), prevBot - 1)));
            }
            this.createAndIncrement(baseSuffStat, new FatContext(baseSuffStat.getInput(), characteristics));
        }

        private boolean isHydrophobic(String ancestorWord, int top) {
            return this.nHydrophilic(true, ancestorWord, top) + this.nHydrophilic(false, ancestorWord, top) > 4;
        }

        private int nHydrophilic(boolean left, String ancestorWord, int top) {
            int cPos;
            int delta;
            int n = 0;
            int n2 = delta = left ? 1 : 0;
            while (delta < 5 && (cPos = top + delta * (left ? -1 : 1)) >= 0 && cPos < ancestorWord.length()) {
                if (Encodings.HYDROPHILIC.contains(Character.valueOf(ancestorWord.charAt(cPos)))) {
                    ++n;
                }
                ++delta;
            }
            return n;
        }

        @Override
        protected void addDel(int tp, int pbp) {
            this.add(this.baseExtractor.delHLSuffStat(tp, pbp), tp, pbp);
            ++this.cDelLength;
        }

        @Override
        protected void addEoIns(int tp, int bp) {
            this.add(this.baseExtractor.eoInsHLSuffStat(tp, bp), tp, bp - 1);
            this.resetInDelLengths();
        }

        @Override
        protected void addIns(int tp, int bp) {
            this.add(this.baseExtractor.insHLSuffStat(tp, bp), tp, bp - 1);
            ++this.cInsLength;
        }

        @Override
        protected void addSub(int tp, int bp) {
            this.add(this.baseExtractor.subHLSuffStat(tp, bp), tp, bp - 1);
            this.resetInDelLengths();
        }
    }

    public static enum Granularity {
        HYDROPHOBIC(5),
        COGNATE_ID(0),
        NEXT_TOP(1),
        PREV_TOP(1),
        PREVPREV(2),
        GAP_LENGTHS(5);

        private final int influenceRadius;

        private Granularity(int ir) {
            this.influenceRadius = ir;
        }

        public int influenceRadius() {
            return this.influenceRadius;
        }
    }
}

