/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import nuts.io.IO;
import nuts.util.Counter;
import scratch.CrazyGen;

public class CrazyCmp {
    public static Counter<List<String>> readSegmentationDistribution(String file) throws IOException {
        Counter<List<String>> result = new Counter<List<String>>();
        for (String line : IO.i(file)) {
            for (String segmentStr : line.split("\\s*[|]\\s*")) {
                if (segmentStr.length() <= 0) continue;
                result.incrementCount(CrazyGen.PhraseTable.phrase(segmentStr), 1.0);
            }
        }
        result.normalize();
        return result;
    }

    public static double distance(CrazyGen.PhraseTable pt1, CrazyGen.PhraseTable pt2, Counter<List<String>> foreignSegDist, Distance d) {
        d = d.newInstace();
        for (List<String> fPhrase : foreignSegDist.keySet()) {
            double segPr = foreignSegDist.getCount(fPhrase);
            HashSet<List<String>> ePhrases = new HashSet<List<String>>();
            ePhrases.addAll(pt1.table.getCounter(fPhrase).keySet());
            ePhrases.addAll(pt2.table.getCounter(fPhrase).keySet());
            for (List list : ePhrases) {
                double x = segPr * pt1.table.getCount(fPhrase, list);
                double y = segPr * pt2.table.getCount(fPhrase, list);
                d.addCoordinate(x, y);
            }
        }
        return d.computeDistance();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("[spanish segm generated file] [phrasetable 1] [phrasetable 2]");
            return;
        }
        String segments = args[0];
        String pt1path = args[1];
        String pt2path = args[2];
        System.out.println("Computing segmentation distribution");
        Counter<List<String>> segDist = CrazyCmp.readSegmentationDistribution(segments);
        System.out.println("Reading phrase table 1");
        CrazyGen.PhraseTable pt1 = new CrazyGen.PhraseTable();
        pt1.read(pt1path);
        System.out.println("Reading phrase table 2");
        CrazyGen.PhraseTable pt2 = new CrazyGen.PhraseTable();
        pt2.read(pt2path);
        System.out.println("Computing distance");
        double answer = CrazyCmp.distance(pt1, pt2, segDist, new HellingerDistance());
        System.out.println("Answer: " + answer);
    }

    public static class HellingerDistance
    implements Distance {
        private double sum = 0.0;
        private double n = 0.0;

        @Override
        public void addCoordinate(double x, double y) {
            this.n += 1.0;
            double factor = Math.sqrt(x) - Math.sqrt(y);
            this.sum += factor * factor;
        }

        @Override
        public double computeDistance() {
            return 0.5 * this.sum;
        }

        @Override
        public Distance newInstace() {
            return new HellingerDistance();
        }
    }

    public static interface Distance {
        public Distance newInstace();

        public void addCoordinate(double var1, double var3);

        public double computeDistance();
    }
}

