/*
 * Decompiled with CFR 0.152.
 */
package slice.util;

import fig.prob.Dirichlet;
import java.util.Random;
import nuts.math.MCIntegrator;
import nuts.math.Poly;
import nuts.math.Sampler;

public class TruncatedBeta
implements Sampler<Double> {
    private double c;
    private double min;
    private double max;
    private Random rand = new Random();

    public TruncatedBeta(double c, double min, double max) {
        assert (min >= 0.0 && min <= max && max <= 1.0);
        assert (c > 0.0);
        this.c = c;
        this.min = min;
        this.max = max;
    }

    public double sample(Random rand) {
        double P1 = Math.pow(1.0 - this.min, this.c);
        double P2 = Math.pow(1.0 - this.max, this.c);
        double A = P1 / (P1 - P2);
        double B = -1.0 / (P1 - P2);
        double uni = rand.nextDouble();
        return 1.0 - Math.pow((uni - A) / B, 1.0 / this.c);
    }

    @Override
    public double previousSampleWeigth() {
        return 1.0;
    }

    @Override
    public Double sample() {
        return this.sample(this.rand);
    }

    public static void main(String[] args) {
        Random rand = new Random();
        TruncatedBeta tb = new TruncatedBeta(10.0, 0.0, 1.0);
        for (int i = 0; i < 10; ++i) {
            System.out.println(tb.sample(rand));
        }
    }

    public static class UntruncatedBetaAdapter
    implements Sampler<Double> {
        private final double c;
        private Random rand = new Random();

        public UntruncatedBetaAdapter(double c) {
            this.c = c;
        }

        @Override
        public double previousSampleWeigth() {
            return 1.0;
        }

        @Override
        public Double sample() {
            double[] params = new double[]{1.0, this.c};
            return Dirichlet.sample(this.rand, params)[0];
        }
    }

    public static class TruncatedBetaTest {
        public double trueMean(double c) {
            return 1.0 / (1.0 + c);
        }

        public double trueEX2(double c) {
            return c / (1.0 + c) / (1.0 + c) / (2.0 + c) + this.trueMean(c) * this.trueMean(c);
        }

        public double expectation(double c, double min, double max, double moment, boolean useDirCode) {
            Sampler<Double> tb = null;
            if (useDirCode) {
                assert (min == 0.0 && max == 1.0);
                tb = new UntruncatedBetaAdapter(c);
            } else {
                tb = new TruncatedBeta(c, min, max);
            }
            MCIntegrator<Double> integr = new MCIntegrator<Double>(tb);
            integr.setIterations(10000);
            return integr.integrate(new Poly(moment));
        }

        public double expectation(double c, double min, double max, double moment) {
            return this.expectation(c, min, max, moment, false);
        }
    }
}

