/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.io.parsers.HmmscanPerDomainTableParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.DomainId;
import org.forester.protein.Protein;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainCountsDifferenceUtil;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PairwiseGenomeComparator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class surfacing {
    private static final int MINIMAL_NUMBER_OF_SIMILARITIES_FOR_SPLITTING = 1000;
    public static final String DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS = "graph_analysis_out";
    public static final String DOMAIN_COMBINITONS_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_dc.dot";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_fitch_present_dc.dot";
    public static final String DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX = ".dcc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_DOMAINS = "_dollo_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_DOMAINS = "_fitch_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_DOMAINS = "_dollo_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_glc_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_DOMAINS = "_fitch_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_glc_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_BC = "_fitch_gains_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_HTML_BC = "_fitch_gains_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_BC = "_fitch_losses_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_HTML_BC = "_fitch_losses_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC = "_fitch_present_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_HTML_BC = "_fitch_present_dc.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_D = "_dollo_gains_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_HTML_D = "_dollo_gains_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_D = "_dollo_losses_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_HTML_D = "_dollo_losses_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_D = "_dollo_present_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_HTML_D = "_dollo_present_d.html";
    public static final String DOMAINS_PRESENT_NEXUS = "_dom.nex";
    public static final String BDC_PRESENT_NEXUS = "_dc.nex";
    public static final String PRG_NAME = "surfacing";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_d_dollo.xml";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_d_fitch.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_dc_dollo.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_dc_fitch.xml";
    public static final String NEXUS_EXTERNAL_DOMAINS = "_dom.nex";
    public static final String NEXUS_EXTERNAL_DOMAIN_COMBINATIONS = "_dc.nex";
    public static final String NEXUS_SECONDARY_FEATURES = "_secondary_features.nex";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_gl_secondary_features";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_glc_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_SECONDARY_FEATURES = "_dollo_gains_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_SECONDARY_FEATURES = "_dollo_losses_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_SECONDARY_FEATURES = "_dollo_present_secondary_features";
    public static final String SECONDARY_FEATURES_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_secondary_features_dollo.xml";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_ALL_NAMESPACES = "_dollo_goid_d";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_ALL_NAMESPACES = "_fitch_goid_dc";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_DIR_OPTION = "out_dir";
    private static final String SCORING_OPTION = "scoring";
    private static final DomainSimilarity.DomainSimilarityScoring SCORING_DEFAULT = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
    private static final String SCORING_DOMAIN_COUNT_BASED = "domains";
    private static final String SCORING_PROTEIN_COUNT_BASED = "proteins";
    private static final String SCORING_COMBINATION_BASED = "combinations";
    private static final String DETAILEDNESS_OPTION = "detail";
    private static final DomainSimilarityCalculator.Detailedness DETAILEDNESS_DEFAULT = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    private static final String SPECIES_MATRIX_OPTION = "smatrix";
    private static final String DETAILEDNESS_BASIC = "basic";
    private static final String DETAILEDNESS_LIST_IDS = "list_ids";
    private static final String DETAILEDNESS_PUNCTILIOUS = "punctilious";
    private static final String DOMAIN_SIMILARITY_SORT_OPTION = "sort";
    private static final DomainSimilarity.DomainSimilaritySortField DOMAIN_SORT_FILD_DEFAULT = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
    private static final String DOMAIN_SIMILARITY_SORT_MIN = "min";
    private static final String DOMAIN_SIMILARITY_SORT_MAX = "max";
    private static final String DOMAIN_SIMILARITY_SORT_SD = "sd";
    private static final String DOMAIN_SIMILARITY_SORT_MEAN = "mean";
    private static final String DOMAIN_SIMILARITY_SORT_DIFF = "diff";
    private static final String DOMAIN_SIMILARITY_SORT_COUNTS_DIFF = "count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF = "abs_count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_SPECIES_COUNT = "species";
    private static final String DOMAIN_SIMILARITY_SORT_ALPHA = "alpha";
    private static final String DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION = "species_first";
    private static final String DOMAIN_COUNT_SORT_OPTION = "dc_sort";
    private static final GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder DOMAINS_SORT_ORDER_DEFAULT = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
    private static final String DOMAIN_COUNT_SORT_ALPHA = "alpha";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT = "dom";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT = "prot";
    private static final String DOMAIN_COUNT_SORT_COMBINATIONS_COUNT = "comb";
    private static final String CUTOFF_SCORE_FILE_OPTION = "cos";
    private static final String NOT_IGNORE_DUFS_OPTION = "dufs";
    private static final String MAX_E_VALUE_OPTION = "e";
    private static final String MAX_ALLOWED_OVERLAP_OPTION = "mo";
    private static final String NO_ENGULFING_OVERLAP_OPTION = "no_eo";
    private static final String IGNORE_COMBINATION_WITH_SAME_OPTION = "ignore_self_comb";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_PREFIX = "pwc_";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_OPTION = "pwc";
    private static final String OUTPUT_FILE_OPTION = "o";
    private static final String PFAM_TO_GO_FILE_USE_OPTION = "p2g";
    private static final String GO_OBO_FILE_USE_OPTION = "obo";
    private static final String GO_NAMESPACE_LIMIT_OPTION = "go_namespace";
    private static final String GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION = "molecular_function";
    private static final String GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS = "biological_process";
    private static final String GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT = "cellular_component";
    private static final String SECONDARY_FEATURES_PARSIMONY_MAP_FILE = "secondary";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED = "simple_tab";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML = "simple_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML = "detailed_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION = "ds_output";
    private static final PrintableDomainSimilarity.PRINT_OPTION DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT = PrintableDomainSimilarity.PRINT_OPTION.HTML;
    private static final String IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION = "ignore_singlet_domains";
    private static final String IGNORE_VIRAL_IDS = "ignore_viral_ids";
    private static final boolean IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_DEFAULT = false;
    private static final String IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION = "ignore_species_specific_domains";
    private static final boolean IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION_DEFAULT = false;
    private static final String MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score.pwd";
    private static final String MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains.pwd";
    private static final String MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations.pwd";
    private static final String NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score_NJ.xml";
    private static final String NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains_NJ.xml";
    private static final String NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations_NJ.xml";
    private static final String JACKNIFE_OPTION = "jack";
    private static final String JACKNIFE_RANDOM_SEED_OPTION = "seed";
    private static final String JACKNIFE_RATIO_OPTION = "jack_ratio";
    private static final int JACKNIFE_NUMBER_OF_RESAMPLINGS_DEFAULT = 100;
    private static final long JACKNIFE_RANDOM_SEED_DEFAULT = 19L;
    private static final double JACKNIFE_RATIO_DEFAULT = 0.5;
    private static final String INFERRED_SD_BASED_NJ_SPECIES_TREE_SUFFIX = "_sd_nj.nh";
    private static final String INFERRED_SBC_BASED_NJ_SPECIES_TREE_SUFFIX = "_sbc_nj.nh";
    private static final String FILTER_POSITIVE_OPTION = "pos_filter";
    private static final String FILTER_NEGATIVE_OPTION = "neg_filter";
    private static final String FILTER_NEGATIVE_DOMAINS_OPTION = "neg_dom_filter";
    private static final String INPUT_FILES_FROM_FILE_OPTION = "input";
    private static final String INPUT_SPECIES_TREE_OPTION = "species_tree";
    private static final String SEQ_EXTRACT_OPTION = "prot_extract";
    private static final char SEPARATOR_FOR_INPUT_VALUES = '#';
    private static final String PRG_VERSION = "2.250";
    private static final String PRG_DATE = "2012.05.07";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/applications/surfacing";
    private static final boolean IGNORE_DUFS_DEFAULT = true;
    private static final boolean IGNORE_COMBINATION_WITH_SAME_DEFAULLT = false;
    private static final double MAX_E_VALUE_DEFAULT = -1.0;
    private static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private static final String RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION = "random_seed";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS = "consider_bdc_direction";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY = "consider_bdc_adj";
    private static final String SEQ_EXTRACT_SUFFIX = ".prot";
    private static final String PLUS_MINUS_ANALYSIS_OPTION = "plus_minus";
    private static final String PLUS_MINUS_DOM_SUFFIX = "_plus_minus_dom.txt";
    private static final String PLUS_MINUS_DOM_SUFFIX_HTML = "_plus_minus_dom.html";
    private static final String PLUS_MINUS_DC_SUFFIX_HTML = "_plus_minus_dc.html";
    private static final int PLUS_MINUS_ANALYSIS_MIN_DIFF_DEFAULT = 0;
    private static final double PLUS_MINUS_ANALYSIS_FACTOR_DEFAULT = 1.0;
    private static final String PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_all.txt";
    private static final String PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_passing.txt";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS = "all_prot";
    private static final boolean VERBOSE = false;
    private static final String OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_gains_counts";
    private static final String OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_losses_counts";
    private static final String DOMAIN_LENGTHS_ANALYSIS_SUFFIX = "_domain_lengths_analysis";
    private static final boolean PERFORM_DOMAIN_LENGTH_ANALYSIS = true;
    public static final String ALL_PFAMS_ENCOUNTERED_SUFFIX = "_all_encountered_pfams";
    public static final String ALL_PFAMS_ENCOUNTERED_WITH_GO_ANNOTATION_SUFFIX = "_all_encountered_pfams_with_go_annotation";
    public static final String ENCOUNTERED_PFAMS_SUMMARY_SUFFIX = "_encountered_pfams_summary";
    public static final String ALL_PFAMS_GAINED_AS_DOMAINS_SUFFIX = "_all_pfams_gained_as_domains";
    public static final String ALL_PFAMS_LOST_AS_DOMAINS_SUFFIX = "_all_pfams_lost_as_domains";
    public static final String ALL_PFAMS_GAINED_AS_DC_SUFFIX = "_all_pfams_gained_as_dc";
    public static final String ALL_PFAMS_LOST_AS_DC_SUFFIX = "_all_pfams_lost_as_dc";
    public static final String BASE_DIRECTORY_PER_NODE_DOMAIN_GAIN_LOSS_FILES = "PER_NODE_EVENTS";
    public static final String BASE_DIRECTORY_PER_SUBTREE_DOMAIN_GAIN_LOSS_FILES = "PER_SUBTREE_EVENTS";
    public static final String D_PROMISCUITY_FILE_SUFFIX = "_domain_promiscuities";
    private static final String LOG_FILE_SUFFIX = "_log.txt";
    private static final String DATA_FILE_SUFFIX = "_domain_combination_data.txt";
    private static final String DATA_FILE_DESC = "#SPECIES\tPRTEIN_ID\tN_TERM_DOMAIN\tC_TERM_DOMAIN\tN_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tC_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tN_TERM_DOMAIN_COUNTS_PER_PROTEIN\tC_TERM_DOMAIN_COUNTS_PER_PROTEIN";
    private static final HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF INDIVIDUAL_SCORE_CUTOFF_DEFAULT = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.FULL_SEQUENCE;
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique.txt";
    public static final String LIMIT_SPEC_FOR_PROT_EX = null;
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH_MAPPED = "_dc_MAPPED_secondary_features_fitch.xml";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique_MAPPED.txt";
    private static final boolean PERFORM_DC_REGAIN_PROTEINS_STATS = true;

    private static void checkWriteabilityForPairwiseComparisons(PrintableDomainSimilarity.PRINT_OPTION pRINT_OPTION, String[][] stringArray, String string, File file) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                String string2 = stringArray[i][1];
                String string3 = stringArray[j][1];
                String string4 = PAIRWISE_DOMAIN_COMPARISONS_PREFIX + string2 + "_" + string3 + string;
                switch (pRINT_OPTION) {
                    case HTML: {
                        if (string4.endsWith(".html")) break;
                        string4 = string4 + ".html";
                    }
                }
                String string5 = ForesterUtil.isWritableFile(new File(file == null ? string4 : file + ForesterUtil.FILE_SEPARATOR + string4));
                if (ForesterUtil.isEmpty(string5)) continue;
                ForesterUtil.fatalError(PRG_NAME, string5);
            }
        }
    }

    private static StringBuilder createParametersAsString(boolean bl, double d, int n, boolean bl2, File file, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("E-value: " + d);
        if (file != null) {
            stringBuilder.append(", Cutoff-scores-file: " + file);
        } else {
            stringBuilder.append(", Cutoff-scores-file: not-set");
        }
        if (n != -1) {
            stringBuilder.append(", Max-overlap: " + n);
        } else {
            stringBuilder.append(", Max-overlap: not-set");
        }
        if (bl2) {
            stringBuilder.append(", Engulfing-overlaps: not-allowed");
        } else {
            stringBuilder.append(", Engulfing-overlaps: allowed");
        }
        if (bl) {
            stringBuilder.append(", Ignore-dufs: true");
        } else {
            stringBuilder.append(", Ignore-dufs: false");
        }
        stringBuilder.append(", DC type (if applicable): " + (Object)((Object)domainCombinationType));
        return stringBuilder;
    }

    private static void executeFitchGainsAnalysis(File file, List<BinaryDomainCombination> list, int n, SortedSet<BinaryDomainCombination> sortedSet, boolean bl) throws IOException {
        SurfacingUtil.checkForOutputFileWriteability(file);
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file);
        SortedMap<Object, Integer> sortedMap = ForesterUtil.listToSortedCountsMap(list);
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        TreeSet<DomainId> treeSet2 = new TreeSet<DomainId>();
        int n2 = 0;
        int n3 = 0;
        for (Object object : sortedMap.keySet()) {
            BinaryDomainCombination binaryDomainCombination = (BinaryDomainCombination)object;
            int n4 = (Integer)sortedMap.get(object);
            if (n4 < 1) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "count < 1 ");
            }
            bufferedWriter.write(binaryDomainCombination + "\t" + n4 + ForesterUtil.LINE_SEPARATOR);
            if (n4 > 1) {
                treeSet.add(binaryDomainCombination.getId0());
                treeSet.add(binaryDomainCombination.getId1());
                ++n2;
                continue;
            }
            if (n4 != 1) continue;
            treeSet2.add(binaryDomainCombination.getId0());
            treeSet2.add(binaryDomainCombination.getId1());
            ++n3;
        }
        int n5 = sortedSet.size();
        int n6 = -1;
        if (!bl) {
            sortedSet.removeAll(list);
            n6 = sortedSet.size();
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                bufferedWriter.write(binaryDomainCombination + "\t" + "0" + ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (bl) {
            bufferedWriter.write("Sum of all distinct domain combinations appearing once               : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations appearing more than once     : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing only once     : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        } else {
            bufferedWriter.write("Sum of all distinct domain combinations never lost                   : " + n6 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost once                    : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost more than once          : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost only once           : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write("All binary combinations                                              : " + n5 + ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write("All domains                                                          : " + n);
        ((Writer)bufferedWriter).close();
        ForesterUtil.programMessage(PRG_NAME, "Wrote fitch domain combination dynamics counts analysis to \"" + file + "\"");
    }

    private static void executePlusMinusAnalysis(File file, List<String> list, List<String> list2, List<String> list3, List<GenomeWideCombinableDomains> list4, SortedMap<Species, List<Protein>> sortedMap, Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, List<Object> list5) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GenomeWideCombinableDomains object2 : list4) {
            hashSet.add(object2.getSpecies().getSpeciesId());
        }
        File file2 = new File(file + PLUS_MINUS_DOM_SUFFIX_HTML);
        File file3 = new File(file + PLUS_MINUS_DOM_SUFFIX);
        File file4 = new File(file + PLUS_MINUS_DC_SUFFIX_HTML);
        File file5 = new File(file + PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX);
        File file6 = new File(file + PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX);
        File file7 = new File(file + "");
        int n = (Integer)list5.get(0);
        double d = (Double)list5.get(1);
        try {
            DomainCountsDifferenceUtil.calculateCopyNumberDifferences(list4, sortedMap, list, list2, list3, n, d, file3, file2, file4, map, map2, file5, file6, file7);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file2 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file3 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file4 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based passing GO ids to \"" + file6 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based all GO ids to \"" + file5 + "\"");
    }

    private static Phylogeny[] getIntrees(File[] fileArray, int n, String[][] stringArray) {
        Phylogeny[] phylogenyArray = new Phylogeny[fileArray.length];
        int n2 = 0;
        for (File file : fileArray) {
            int n3;
            Object object;
            Phylogeny phylogeny = null;
            String string = ForesterUtil.isReadableFile(file);
            if (!ForesterUtil.isEmpty(string)) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read input tree file [" + file + "]: " + string);
            }
            try {
                object = ParserBasedPhylogenyFactory.getInstance().create(file, ParserUtils.createParserDependingOnFileType(file, true));
                if (((Phylogeny[])object).length < 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + file + "] does not contain any phylogeny in phyloXML format");
                } else if (((Phylogeny[])object).length > 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + file + "] contains more than one phylogeny in phyloXML format");
                }
                phylogeny = object[0];
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read input tree from file [" + file + "]: " + string);
            }
            if (phylogeny == null || phylogeny.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] is empty");
            }
            if (!phylogeny.isRooted()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] is not rooted");
            }
            if (phylogeny.getNumberOfExternalNodes() < n) {
                ForesterUtil.fatalError(PRG_NAME, "number of external nodes [" + phylogeny.getNumberOfExternalNodes() + "] of input tree [" + file + "] is smaller than the number of genomes the be analyzed [" + n + "]");
            }
            if ((n3 = SurfacingUtil.getNumberOfNodesLackingName(phylogeny, (StringBuilder)(object = new StringBuilder()))) > 0) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] has " + n3 + " node(s) lacking a name [parent names:" + object + "]");
            }
            surfacing.preparePhylogenyForParsimonyAnalyses(phylogeny, stringArray);
            if (!phylogeny.isCompletelyBinary()) {
                ForesterUtil.printWarningMessage(PRG_NAME, "input tree [" + file + "] is not completely binary");
            }
            phylogenyArray[n2++] = phylogeny;
        }
        return phylogenyArray;
    }

    private static List<Phylogeny> inferSpeciesTrees(File file, List<BasicSymmetricalDistanceMatrix> list) {
        NeighborJoining neighborJoining = NeighborJoining.createInstance();
        List<Phylogeny> list2 = neighborJoining.execute(list);
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        try {
            phylogenyWriter.toNewHampshire(list2, true, true, file, ";");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to outfile [" + file + "]: " + iOException.getMessage());
        }
        return list2;
    }

    private static void log(String string, Writer writer) {
        try {
            writer.write(string);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var77_115;
        Iterator<Domain> iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        AbstractCollection iOException;
        Object object5;
        Object object6;
        int string9;
        Object object7;
        int object24;
        Object n8;
        boolean bl;
        Object object13;
        Object object14;
        List<GoTerm> list;
        Object object15;
        Object object16;
        Object object17;
        Object object18;
        Object object19;
        String string;
        Object object20;
        Object object21;
        Object object22;
        Object object23;
        long l = new Date().getTime();
        StringBuilder stringBuilder = new StringBuilder();
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        String string2 = ForesterUtil.LINE_SEPARATOR;
        stringBuilder.append("<table>" + string2);
        stringBuilder.append("<tr><td>Produced by:</td><td>surfacing</td></tr>" + string2);
        stringBuilder.append("<tr><td>Version:</td><td>2.250</td></tr>" + string2);
        stringBuilder.append("<tr><td>Release Date:</td><td>2012.05.07</td></tr>" + string2);
        stringBuilder.append("<tr><td>Contact:</td><td>czmasek@burnham.org</td></tr>" + string2);
        stringBuilder.append("<tr><td>WWW:</td><td>www.phylosoft.org/forester/applications/surfacing</td></tr>" + string2);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            surfacing.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 1) {
            surfacing.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NOT_IGNORE_DUFS_OPTION);
        arrayList.add(MAX_E_VALUE_OPTION);
        arrayList.add(DETAILEDNESS_OPTION);
        arrayList.add(OUTPUT_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_OPTION);
        arrayList.add(SPECIES_MATRIX_OPTION);
        arrayList.add(SCORING_OPTION);
        arrayList.add(MAX_ALLOWED_OVERLAP_OPTION);
        arrayList.add(NO_ENGULFING_OVERLAP_OPTION);
        arrayList.add(DOMAIN_COUNT_SORT_OPTION);
        arrayList.add(CUTOFF_SCORE_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION);
        arrayList.add(OUTPUT_DIR_OPTION);
        arrayList.add(IGNORE_COMBINATION_WITH_SAME_OPTION);
        arrayList.add(PFAM_TO_GO_FILE_USE_OPTION);
        arrayList.add(GO_OBO_FILE_USE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_PRINT_OPTION);
        arrayList.add(GO_NAMESPACE_LIMIT_OPTION);
        arrayList.add(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
        arrayList.add(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS);
        arrayList.add(JACKNIFE_OPTION);
        arrayList.add(JACKNIFE_RANDOM_SEED_OPTION);
        arrayList.add(JACKNIFE_RATIO_OPTION);
        arrayList.add(INPUT_SPECIES_TREE_OPTION);
        arrayList.add(FILTER_POSITIVE_OPTION);
        arrayList.add(FILTER_NEGATIVE_OPTION);
        arrayList.add(INPUT_FILES_FROM_FILE_OPTION);
        arrayList.add(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
        arrayList.add(FILTER_NEGATIVE_DOMAINS_OPTION);
        arrayList.add(IGNORE_VIRAL_IDS);
        arrayList.add(SEQ_EXTRACT_OPTION);
        arrayList.add(SECONDARY_FEATURES_PARSIMONY_MAP_FILE);
        arrayList.add(PLUS_MINUS_ANALYSIS_OPTION);
        arrayList.add(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS);
        arrayList.add(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY);
        boolean bl2 = true;
        boolean bl3 = false;
        double d = -1.0;
        int n3 = -1;
        String string3 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string3.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string3);
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS)) {
            bl4 = true;
        }
        if (commandLineArguments.isOptionSet(MAX_E_VALUE_OPTION)) {
            try {
                d = commandLineArguments.getOptionValueAsDouble(MAX_E_VALUE_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (commandLineArguments.isOptionSet(MAX_ALLOWED_OVERLAP_OPTION)) {
            try {
                n3 = commandLineArguments.getOptionValueAsInt(MAX_ALLOWED_OVERLAP_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for maximal allowed domain overlap");
            }
        }
        boolean bl5 = false;
        if (commandLineArguments.isOptionSet(NO_ENGULFING_OVERLAP_OPTION)) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (commandLineArguments.isOptionSet(IGNORE_VIRAL_IDS)) {
            bl6 = true;
        }
        if (commandLineArguments.isOptionSet(NOT_IGNORE_DUFS_OPTION)) {
            bl2 = false;
        }
        if (commandLineArguments.isOptionSet(IGNORE_COMBINATION_WITH_SAME_OPTION)) {
            bl3 = true;
        }
        boolean bl7 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION)) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION)) {
            bl8 = true;
        }
        File file = null;
        if (commandLineArguments.isOptionSet(OUTPUT_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(OUTPUT_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities output file: -o=<file>");
            }
            file = new File(commandLineArguments.getOptionValue(OUTPUT_FILE_OPTION));
            SurfacingUtil.checkForOutputFileWriteability(file);
        }
        File file2 = null;
        Map<String, Double> map = null;
        if (commandLineArguments.isOptionSet(CUTOFF_SCORE_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(CUTOFF_SCORE_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for individual domain score cutoffs file: -cos=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object23 = ForesterUtil.isReadableFile(file2 = new File(commandLineArguments.getOptionValue(CUTOFF_SCORE_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read individual domain score cutoffs file: " + (String)object23);
            }
            try {
                object22 = BasicTableParser.parse(file2, " ");
                map = ((BasicTable)object22).getColumnsAsMapDouble(0, 1);
            }
            catch (IOException iOException2) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from individual score cutoffs file: " + iOException2);
            }
        }
        object23 = BinaryDomainCombination.DomainCombinationType.BASIC;
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS)) {
            object23 = BinaryDomainCombination.DomainCombinationType.DIRECTED;
        }
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY)) {
            object23 = BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT;
        }
        object22 = null;
        if (commandLineArguments.isOptionSet(OUTPUT_DIR_OPTION)) {
            boolean bl9;
            if (!commandLineArguments.isOptionValueSet(OUTPUT_DIR_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for output directory: -out_dir=<dir>");
            }
            if (((File)(object22 = new File(commandLineArguments.getOptionValue(OUTPUT_DIR_OPTION)))).exists() && ((File)object22).listFiles().length > 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + object22 + "\" aready exists and is not empty");
            }
            if (!(((File)object22).exists() || (bl9 = ((File)object22).mkdir()) && ((File)object22).exists())) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create \"" + object22 + "\"");
            }
            if (!((File)object22).canWrite()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot write to \"" + object22 + "\"");
            }
        }
        File file3 = null;
        File file4 = null;
        File file5 = null;
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) && commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative and positive protein filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION) && (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) || commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION))) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative or positive protein filter together wirh a negative domains filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative filter: -neg_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object21 = ForesterUtil.isReadableFile(file4 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file4 + "\": " + (String)object21);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_POSITIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for positive filter: -pos_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object21 = ForesterUtil.isReadableFile(file3 = new File(commandLineArguments.getOptionValue(FILTER_POSITIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file3 + "\": " + (String)object21);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative domains filter: -neg_dom_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object21 = ForesterUtil.isReadableFile(file5 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_DOMAINS_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file5 + "\": " + (String)object21);
            }
        }
        object21 = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        surfacing.processPlusMinusAnalysisOption(commandLineArguments, (List<String>)object21, arrayList2, arrayList3, arrayList4);
        File file6 = null;
        String[] stringArray2 = null;
        if (commandLineArguments.isOptionSet(INPUT_FILES_FROM_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(INPUT_FILES_FROM_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input files file: -input=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object20 = ForesterUtil.isReadableFile(file6 = new File(commandLineArguments.getOptionValue(INPUT_FILES_FROM_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file6 + "\": " + (String)object20);
            }
            try {
                stringArray2 = ForesterUtil.file2array(file6);
            }
            catch (IOException iOException3) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read from \"" + file6 + "\": " + iOException3);
            }
        }
        if (commandLineArguments.getNumberOfNames() < 1 && (stringArray2 == null || stringArray2.length < 1)) {
            ForesterUtil.fatalError(PRG_NAME, "No hmmpfam output file indicated is input: use comand line directly or input=<file>");
        }
        object20 = SCORING_DEFAULT;
        if (commandLineArguments.isOptionSet(SCORING_OPTION)) {
            String string4;
            if (!commandLineArguments.isOptionValueSet(SCORING_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for scoring method for domain combinations similarity calculation: -scoring=<domains|proteins|combinations>\"");
            }
            if ((string4 = commandLineArguments.getOptionValue(SCORING_OPTION)).equals(SCORING_DOMAIN_COUNT_BASED)) {
                object20 = DomainSimilarity.DomainSimilarityScoring.DOMAINS;
            } else if (string4.equals(SCORING_COMBINATION_BASED)) {
                object20 = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
            } else if (string4.equals(SCORING_PROTEIN_COUNT_BASED)) {
                object20 = DomainSimilarity.DomainSimilarityScoring.PROTEINS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string4 + "\" for scoring method for domain combinations similarity calculation: \"-" + SCORING_OPTION + "=<" + SCORING_DOMAIN_COUNT_BASED + "|" + SCORING_PROTEIN_COUNT_BASED + "|" + SCORING_COMBINATION_BASED + ">\"");
            }
        }
        boolean bl10 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION)) {
            bl10 = true;
        }
        boolean bl11 = false;
        if (commandLineArguments.isOptionSet(SPECIES_MATRIX_OPTION)) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (commandLineArguments.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS)) {
            bl12 = true;
        }
        DomainSimilarityCalculator.Detailedness detailedness = DETAILEDNESS_DEFAULT;
        if (commandLineArguments.isOptionSet(DETAILEDNESS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DETAILEDNESS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for -detail=<basic|list_ids|punctilious>\"");
            }
            if ((string = commandLineArguments.getOptionValue(DETAILEDNESS_OPTION).toLowerCase()).equals(DETAILEDNESS_BASIC)) {
                detailedness = DomainSimilarityCalculator.Detailedness.BASIC;
            } else if (string.equals(DETAILEDNESS_LIST_IDS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES;
            } else if (string.equals(DETAILEDNESS_PUNCTILIOUS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string + "\" for detailedness: \"-" + DETAILEDNESS_OPTION + "=<" + DETAILEDNESS_BASIC + "|" + DETAILEDNESS_LIST_IDS + "|" + DETAILEDNESS_PUNCTILIOUS + ">\"");
            }
        }
        string = null;
        boolean bl13 = false;
        boolean bl14 = false;
        if (commandLineArguments.isOptionSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
            bl13 = true;
            if (!commandLineArguments.isOptionValueSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
                bl14 = false;
            } else {
                bl14 = true;
                string = "_" + commandLineArguments.getOptionValue(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
            }
        }
        String string5 = null;
        if (commandLineArguments.isOptionSet(SEQ_EXTRACT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(SEQ_EXTRACT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no domain ids given for sequences with given domains to be extracted : -prot_extract=<ordered domain sequences, domain ids separated by '~', sequences separated by '#'>");
            }
            string5 = commandLineArguments.getOptionValue(SEQ_EXTRACT_OPTION);
        }
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField = DOMAIN_SORT_FILD_DEFAULT;
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField2 = DOMAIN_SORT_FILD_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities sorting: -sort=<alpha|max|min|mean|diff|abs_count_diff|count_diff|species|sd>\"");
            }
            if (((String)(object19 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_SORT_OPTION).toLowerCase())).equals("alpha")) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_MAX)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_MIN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MIN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_MEAN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MEAN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MEAN;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_SPECIES_COUNT)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_SD)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SD;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
            } else if (((String)object19).equals(DOMAIN_SIMILARITY_SORT_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object19 + "\" for domain combinations similarities sorting: \"-" + DOMAIN_SIMILARITY_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_SIMILARITY_SORT_MAX + "|" + DOMAIN_SIMILARITY_SORT_MIN + "|" + DOMAIN_SIMILARITY_SORT_MEAN + "|" + DOMAIN_SIMILARITY_SORT_DIFF + "|" + DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF + "|" + DOMAIN_SIMILARITY_SORT_COUNTS_DIFF + "|" + "|" + DOMAIN_SIMILARITY_SORT_SPECIES_COUNT + "|" + DOMAIN_SIMILARITY_SORT_SD + ">\"");
            }
        }
        object19 = DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for print option: -detailed_html|simple_html|simple_tab>\"");
            }
            if (((String)(object18 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_PRINT_OPTION).toLowerCase())).equals(DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML)) {
                object19 = PrintableDomainSimilarity.PRINT_OPTION.HTML;
            } else if (((String)object18).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML)) {
                ForesterUtil.fatalError(PRG_NAME, "simple HTML output not implemented yet :(");
            } else if (((String)object18).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED)) {
                object19 = PrintableDomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object18 + "\" for print option: -" + DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED + ">\"");
            }
        }
        object18 = DOMAINS_SORT_ORDER_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_COUNT_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_COUNT_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for sorting of domain counts: -dc_sort=<alpha|dom|prot|comb>\"");
            }
            if (((String)(object17 = commandLineArguments.getOptionValue(DOMAIN_COUNT_SORT_OPTION).toLowerCase())).equals("alpha")) {
                object18 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
            } else if (((String)object17).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT)) {
                object18 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT;
            } else if (((String)object17).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT)) {
                object18 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT;
            } else if (((String)object17).equals(DOMAIN_COUNT_SORT_COMBINATIONS_COUNT)) {
                object18 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object17 + "\" for sorting of domain counts: \"-" + DOMAIN_COUNT_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT + "|" + DOMAIN_COUNT_SORT_COMBINATIONS_COUNT + ">\"");
            }
        }
        object17 = null;
        object17 = stringArray2 != null ? surfacing.processInputFileNames(stringArray2) : surfacing.processInputFileNames(commandLineArguments.getNames());
        int n4 = ((String[][])object17).length;
        if (n4 < 2) {
            ForesterUtil.fatalError(PRG_NAME, "cannot analyze less than two files");
        }
        if (n4 < 3 && bl13) {
            ForesterUtil.fatalError(PRG_NAME, "cannot use : -pwc=<suffix> to turn on pairwise analyses with less than three input files");
        }
        surfacing.checkWriteabilityForPairwiseComparisons((PrintableDomainSimilarity.PRINT_OPTION)((Object)object19), (String[][])object17, string, (File)object22);
        for (int i = 0; i < n4; ++i) {
            object16 = new File((String)object17[i][0] + DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX);
            if (object22 != null) {
                object16 = new File(object22 + ForesterUtil.FILE_SEPARATOR + object16);
            }
            SurfacingUtil.checkForOutputFileWriteability((File)object16);
        }
        File file7 = null;
        object16 = null;
        int n5 = 0;
        if (commandLineArguments.isOptionSet(PFAM_TO_GO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(PFAM_TO_GO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for Pfam to GO mapping file: -p2g=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object15 = ForesterUtil.isReadableFile(file7 = new File(commandLineArguments.getOptionValue(PFAM_TO_GO_FILE_USE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read Pfam to GO mapping file: " + (String)object15);
            }
            try {
                list = new PfamToGoParser(file7);
                object14 = ((PfamToGoParser)((Object)list)).parse();
                object16 = SurfacingUtil.createDomainIdToGoIdMap((List<PfamToGoMapping>)object14);
                if (((PfamToGoParser)((Object)list)).getMappingCount() < object16.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getMappingCount() < domain_id_to_go_ids_map.size()");
                }
                n5 = ((PfamToGoParser)((Object)list)).getMappingCount();
            }
            catch (IOException iOException4) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from Pfam to GO mapping file: " + iOException4);
            }
        }
        object15 = null;
        list = null;
        if (commandLineArguments.isOptionSet(GO_OBO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(GO_OBO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -obo=<file>");
            }
            if (object16 == null || object16.size() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO OBO file (-obo=<file>) without Pfam to GO mapping file (p2g=<file>)");
            }
            if (!ForesterUtil.isEmpty((String)(object14 = ForesterUtil.isReadableFile((File)(object15 = new File(commandLineArguments.getOptionValue(GO_OBO_FILE_USE_OPTION))))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read GO OBO file: " + (String)object14);
            }
            try {
                object13 = new OBOparser((File)object15, OBOparser.ReturnType.BASIC_GO_TERM);
                list = ((OBOparser)object13).parse();
                if (((OBOparser)object13).getGoTermCount() != list.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getGoTermCount() != go_terms.size()");
                }
            }
            catch (IOException iOException5) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from GO OBO file: " + iOException5);
            }
        }
        object14 = null;
        if (object16 != null && object16.size() > 0 && list != null && list.size() > 0) {
            object14 = GoUtils.createGoIdToGoTermMap(list);
        }
        object13 = null;
        if (commandLineArguments.isOptionSet(GO_NAMESPACE_LIMIT_OPTION)) {
            String string6;
            if (object14 == null || object14.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO namespace limit (-go_namespace=<namespace>) without Pfam to GO mapping file (p2g=<file>) and GO OBO file (-obo=<file>)");
            }
            if (!commandLineArguments.isOptionValueSet(GO_NAMESPACE_LIMIT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO namespace limit: \"-go_namespace=<molecular_function|biological_process|cellular_component>\"");
            }
            if ((string6 = commandLineArguments.getOptionValue(GO_NAMESPACE_LIMIT_OPTION).toLowerCase()).equals(GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION)) {
                object13 = GoNameSpace.createMolecularFunction();
            } else if (string6.equals(GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS)) {
                object13 = GoNameSpace.createBiologicalProcess();
            } else if (string6.equals(GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT)) {
                object13 = GoNameSpace.createCellularComponent();
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string6 + "\" for GO namespace limit: \"-" + GO_NAMESPACE_LIMIT_OPTION + "=<" + GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION + "|" + GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS + "|" + GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT + ">\"");
            }
        }
        if (domainSimilaritySortField == DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE && n4 > 2) {
            domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
        }
        boolean bl15 = false;
        int n6 = 100;
        double d2 = 0.5;
        long l2 = 19L;
        if (commandLineArguments.isOptionSet(JACKNIFE_OPTION)) {
            if (n4 < 3 || !bl13) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use jacknife resampling analysis (-jack[=<number of resamplings>]) without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            bl15 = true;
            if (commandLineArguments.isOptionHasAValue(JACKNIFE_OPTION)) {
                try {
                    n6 = commandLineArguments.getOptionValueAsInt(JACKNIFE_OPTION);
                }
                catch (IOException iOException6) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for number of resamplings");
                }
                if (n6 < 2) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use less than 2 resamplings");
                }
            }
            if (commandLineArguments.isOptionSet(JACKNIFE_RATIO_OPTION) && commandLineArguments.isOptionHasAValue(JACKNIFE_RATIO_OPTION)) {
                try {
                    d2 = commandLineArguments.getOptionValueAsDouble(JACKNIFE_RATIO_OPTION);
                }
                catch (IOException iOException7) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for jacknife ratio");
                }
                if (d2 <= 0.0 || d2 >= 1.0) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use illegal value for jacknife ratio: " + d2);
                }
            }
            if (commandLineArguments.isOptionSet(JACKNIFE_RANDOM_SEED_OPTION) && commandLineArguments.isOptionHasAValue(JACKNIFE_RANDOM_SEED_OPTION)) {
                try {
                    l2 = commandLineArguments.getOptionValueAsLong(JACKNIFE_RANDOM_SEED_OPTION);
                }
                catch (IOException iOException8) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for random generator seed");
                }
            }
        }
        File[] fileArray = null;
        Phylogeny[] phylogenyArray = null;
        if (commandLineArguments.isOptionSet(INPUT_SPECIES_TREE_OPTION)) {
            String string7;
            if (n4 < 3) {
                ForesterUtil.fatalError(PRG_NAME, "cannot infer gains and losses on input species trees (-species_tree without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            if (!commandLineArguments.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input tree: -species_tree=<tree file in phyloXML format>");
            }
            if ((string7 = commandLineArguments.getOptionValue(INPUT_SPECIES_TREE_OPTION)).indexOf("#") > 0) {
                String[] stringArray3 = string7.split("#");
                fileArray = new File[stringArray3.length];
                bl = false;
                for (String object122 : stringArray3) {
                    fileArray[bl++] = new File(object122.trim());
                }
            } else {
                fileArray = new File[]{new File(string7)};
            }
            phylogenyArray = surfacing.getIntrees(fileArray, n4, (String[][])object17);
        }
        long l3 = 0L;
        bl = false;
        if (commandLineArguments.isOptionSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for random number seed: -random_seed=<seed>");
            }
            try {
                l3 = commandLineArguments.getOptionValueAsLong(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
            }
            catch (IOException iOException9) {
                ForesterUtil.fatalError(PRG_NAME, iOException9.getMessage());
            }
            bl = true;
        }
        String[] stringArray4 = null;
        if (file3 != null || file4 != null || file5 != null) {
            stringArray4 = new TreeSet();
            if (file3 != null) {
                surfacing.processFilter(file3, stringArray4);
            } else if (file4 != null) {
                surfacing.processFilter(file4, stringArray4);
            } else if (file5 != null) {
                surfacing.processFilter(file5, stringArray4);
            }
        }
        Map[] mapArray = null;
        File[] fileArray2 = null;
        File file8 = new File(object22 + ForesterUtil.FILE_SEPARATOR + file + DOMAIN_LENGTHS_ANALYSIS_SUFFIX);
        SurfacingUtil.checkForOutputFileWriteability(file8);
        if (commandLineArguments.isOptionSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
            if (!commandLineArguments.isOptionValueSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for secondary features map file: -secondary=<file>");
            }
            n8 = commandLineArguments.getOptionValue(SECONDARY_FEATURES_PARSIMONY_MAP_FILE).split("#");
            fileArray2 = new File[((String[])n8).length];
            mapArray = new Map[((String[])n8).length];
            object24 = 0;
            object7 = n8;
            int string8 = ((String[])object7).length;
            for (string9 = 0; string9 < string8; ++string9) {
                object6 = object7[string9];
                fileArray2[object24] = new File((String)object6);
                object5 = ForesterUtil.isReadableFile(fileArray2[object24]);
                if (!ForesterUtil.isEmpty((String)object5)) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + (String)object5);
                }
                try {
                    mapArray[object24] = SurfacingUtil.createDomainIdToSecondaryFeaturesMap(fileArray2[object24]);
                }
                catch (IOException exception) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + exception.getMessage());
                }
                catch (Exception exception) {
                    ForesterUtil.fatalError(PRG_NAME, "problem with contents of features map file [" + fileArray2[object24] + "]: " + exception.getMessage());
                }
                ++object24;
            }
        }
        if (object22 == null) {
            ForesterUtil.fatalError(PRG_NAME, "no output directory indicated (-out_dir=<dir>)");
        }
        if (file == null) {
            ForesterUtil.fatalError(PRG_NAME, "no name for (main) output file indicated (-o=<file>)");
        }
        if (object16 == null || object16.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) Pfam to GO id mapping file provided ('pfam2go file') (-p2g=<file>)");
        }
        if (object14 == null || object14.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) go id to term mapping file provided ('GO OBO file') (-obo=<file>)");
        }
        System.out.println("Output directory            : " + object22);
        if (stringArray2 != null) {
            System.out.println("Input files names from      : " + file6 + " [" + stringArray2.length + " input files]");
            stringBuilder.append("<tr><td>Input files names from:</td><td>" + file6 + " [" + stringArray2.length + " input files]</td></tr>" + string2);
        }
        if (file3 != null) {
            int n9 = stringArray4.size();
            System.out.println("Positive protein filter     : " + file3 + " [" + n9 + " domain ids]");
            stringBuilder.append("<tr><td>Positive protein filter:</td><td>" + file3 + " [" + n9 + " domain ids]</td></tr>" + string2);
        }
        if (file4 != null) {
            int n10 = stringArray4.size();
            System.out.println("Negative protein filter     : " + file4 + " [" + n10 + " domain ids]");
            stringBuilder.append("<tr><td>Negative protein filter:</td><td>" + file4 + " [" + n10 + " domain ids]</td></tr>" + string2);
        }
        if (file5 != null) {
            int n = stringArray4.size();
            System.out.println("Negative domain filter      : " + file5 + " [" + n + " domain ids]");
            stringBuilder.append("<tr><td>Negative domain filter:</td><td>" + file5 + " [" + n + " domain ids]</td></tr>" + string2);
        }
        if (object21.size() > 0) {
            n8 = "";
            Object object8 = object21.iterator();
            while (object8.hasNext()) {
                object7 = (String)object8.next();
                n8 = (String)n8 + "+" + (String)object7 + " ";
            }
            object8 = "";
            for (String string4 : arrayList2) {
                object8 = (String)object8 + "*" + string4 + " ";
            }
            object7 = "";
            for (String file82 : arrayList3) {
                object7 = (String)object7 + "-" + file82 + " ";
            }
            System.out.println("Plus-minus analysis         : " + (String)object8 + "&& " + (String)n8 + "&& " + (String)object7);
            stringBuilder.append("<tr><td>Plus-minus analysis:</td><td>" + (String)object8 + "&& " + (String)n8 + "&& " + (String)object7 + "</td></tr>" + string2);
        }
        if (file2 != null) {
            System.out.println("Cutoff scores file          : " + file2);
            stringBuilder.append("<tr><td>Cutoff scores file:</td><td>" + file2 + "</td></tr>" + string2);
        }
        if (d >= 0.0) {
            System.out.println("E-value maximum (inclusive) : " + d);
            stringBuilder.append("<tr><td>E-value maximum (inclusive):</td><td>" + d + "</td></tr>" + string2);
        }
        System.out.println("Ignore DUFs                 : " + bl2);
        if (bl6) {
            System.out.println("Ignore virus like ids       : " + bl6);
            stringBuilder.append("<tr><td>Ignore virus, phage, transposition related ids:</td><td>" + bl6 + "</td></tr>" + string2);
        }
        stringBuilder.append("<tr><td>Ignore DUFs:</td><td>" + bl2 + "</td></tr>" + string2);
        if (n3 != -1) {
            System.out.println("Max allowed domain overlap  : " + n3);
            stringBuilder.append("<tr><td>Max allowed domain overlap:</td><td>" + n3 + "</td></tr>" + string2);
        }
        if (bl5) {
            System.out.println("Ignore engulfed domains     : " + bl5);
            stringBuilder.append("<tr><td>Ignore (lower confidence) engulfed domains:</td><td>" + bl5 + "</td></tr>" + string2);
        }
        System.out.println("Ignore singlet domains      : " + bl7);
        stringBuilder.append("<tr><td>Ignore singlet domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl7 + "</td></tr>" + string2);
        System.out.println("Ignore species specific doms: " + bl8);
        stringBuilder.append("<tr><td>Ignore species specific domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl8 + "</td></tr>" + string2);
        System.out.println("Ignore combination with self: " + bl3);
        stringBuilder.append("<tr><td>Ignore combination with self for domain combination similarity analyses:</td><td>" + bl3 + "</td></tr>" + string2);
        System.out.println("Consider directedness       : " + (object23 != BinaryDomainCombination.DomainCombinationType.BASIC));
        stringBuilder.append("<tr><td>Consider directedness of binary domain combinations:</td><td>" + (object23 != BinaryDomainCombination.DomainCombinationType.BASIC) + "</td></tr>" + string2);
        if (object23 != BinaryDomainCombination.DomainCombinationType.BASIC) {
            System.out.println("Consider adjacency          : " + (object23 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT));
            stringBuilder.append("<tr><td>Consider djacency of binary domain combinations:</td><td>" + (object23 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) + "</td></tr>" + string2);
        }
        System.out.print("Domain counts sort order    : ");
        switch (1.$SwitchMap$org$forester$surfacing$GenomeWideCombinableDomains$GenomeWideCombinableDomainsSortOrder[((Enum)object18).ordinal()]) {
            case 1: {
                System.out.println("alphabetical");
                break;
            }
            case 2: {
                System.out.println("domain count");
                break;
            }
            case 3: {
                System.out.println("domain proteins count");
                break;
            }
            case 4: {
                System.out.println("domain combinations count");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for dc sort order");
            }
        }
        if (object16 != null) {
            System.out.println("Pfam to GO mappings from    : " + file7 + " [" + n5 + " mappings]");
            stringBuilder.append("<tr><td>Pfam to GO mappings from:</td><td>" + file7 + " [" + n5 + " mappings]" + "</td></tr>" + string2);
        }
        if (list != null) {
            System.out.println("GO terms from               : " + object15 + " [" + list.size() + " terms]");
            stringBuilder.append("<tr><td>GO terms from:</td><td>" + object15 + " [" + list.size() + " terms]" + "</td></tr>" + string2);
        }
        if (object13 != null) {
            System.out.println("Limit GO terms to           : " + ((GoNameSpace)object13).toString());
            stringBuilder.append("<tr><td>Limit GO terms to</td><td>" + object13 + "</td></tr>" + string2);
        }
        if (bl13) {
            System.out.println("Suffix for PWC files        : " + string);
            stringBuilder.append("<tr><td>Suffix for PWC files</td><td>" + string + "</td></tr>" + string2);
        }
        if (object22 != null) {
            System.out.println("Output directory            : " + object22);
        }
        if (string5 != null) {
            System.out.println("Query domains (ordered)     : " + string5);
            stringBuilder.append("<tr><td></td><td>" + string5 + "</td></tr>" + string2);
        }
        System.out.println("Write similarities to       : " + file);
        System.out.print("  Scoring method            : ");
        stringBuilder.append("<tr><td>Scoring method:</td><td>");
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object20).ordinal()]) {
            case 1: {
                System.out.println("domain combinations based");
                stringBuilder.append("domain combinations based</td></tr>" + string2);
                break;
            }
            case 2: {
                System.out.println("domain counts based");
                stringBuilder.append("domain counts based</td></tr>" + string2);
                break;
            }
            case 3: {
                System.out.println("domain proteins counts based");
                stringBuilder.append("domain proteins counts based</td></tr>" + string2);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        System.out.print("  Sort by                   : ");
        stringBuilder.append("<tr><td>Sort by:</td><td>");
        switch (domainSimilaritySortField) {
            case MIN: {
                System.out.print("score minimum");
                stringBuilder.append("score minimum");
                break;
            }
            case MAX: {
                System.out.print("score maximum");
                stringBuilder.append("score maximum");
                break;
            }
            case MEAN: {
                System.out.print("score mean");
                stringBuilder.append("score mean");
                break;
            }
            case SD: {
                System.out.print("score standard deviation");
                stringBuilder.append("score standard deviation");
                break;
            }
            case SPECIES_COUNT: {
                System.out.print("species number");
                stringBuilder.append("species number");
                break;
            }
            case DOMAIN_ID: {
                System.out.print("alphabetical domain identifier");
                stringBuilder.append("alphabetical domain identifier");
                break;
            }
            case MAX_DIFFERENCE: {
                System.out.print("(maximal) difference");
                stringBuilder.append("(maximal) difference");
                break;
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                System.out.print("absolute (maximal) counts difference");
                stringBuilder.append("absolute (maximal) counts difference");
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                System.out.print("(maximal) counts difference");
                stringBuilder.append("(maximal) counts  difference");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
            }
        }
        if (bl10) {
            System.out.println(" (sort by species count first)");
            stringBuilder.append(" (sort by species count first)");
        } else {
            System.out.println();
        }
        stringBuilder.append("</td></tr>" + string2);
        System.out.print("  Detailedness              : ");
        switch (detailedness) {
            case BASIC: {
                System.out.println(DETAILEDNESS_BASIC);
                break;
            }
            case LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES: {
                System.out.println("list combining domains for each species");
                break;
            }
            case PUNCTILIOUS: {
                System.out.println(DETAILEDNESS_PUNCTILIOUS);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for detailedness");
            }
        }
        System.out.print("  Print option              : ");
        switch (1.$SwitchMap$org$forester$surfacing$PrintableDomainSimilarity$PRINT_OPTION[((Enum)object19).ordinal()]) {
            case 1: {
                System.out.println("HTML");
                break;
            }
            case 2: {
                System.out.println("simple tab delimited");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for print option");
            }
        }
        System.out.print("  Species matrix            : " + bl11);
        System.out.println();
        n8 = new File(object22 + ForesterUtil.FILE_SEPARATOR + file + DATA_FILE_SUFFIX);
        System.out.println("Domain comb data output     : " + n8);
        stringBuilder.append("<tr><td>Domain combination data output:</td><td> " + n8 + " </td></tr>");
        System.out.println();
        if (bl13) {
            System.out.println("Pairwise comparisons: ");
            stringBuilder.append("<tr><td>Pairwise comparisons:</td><td></td></tr>");
            System.out.print("  Sort by                   : ");
            stringBuilder.append("<tr><td>Sort by:</td><td>");
            switch (domainSimilaritySortField2) {
                case MEAN: {
                    System.out.print("score mean");
                    stringBuilder.append("score mean");
                    break;
                }
                case DOMAIN_ID: {
                    System.out.print("alphabetical domain identifier");
                    stringBuilder.append("alphabetical domain identifier");
                    break;
                }
                case MAX_DIFFERENCE: {
                    System.out.print("difference");
                    stringBuilder.append("difference");
                    break;
                }
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    System.out.print("absolute counts difference");
                    stringBuilder.append("absolute counts difference");
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    System.out.print("counts difference");
                    stringBuilder.append("counts difference");
                    break;
                }
                default: {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
                }
            }
            System.out.println();
            stringBuilder.append("</td></tr>" + string2);
            if (bl15) {
                stringBuilder.append("<tr><td>Jacknife:</td><td>" + n6 + " resamplings</td></tr>" + string2);
                stringBuilder.append("<tr><td>Jacknife ratio:</td><td>" + ForesterUtil.round(d2, 2) + "</td></tr>" + string2);
                stringBuilder.append("<tr><td>Jacknife random number seed:</td><td>" + l2 + "</td></tr>" + string2);
                System.out.println("  Jacknife                  : " + n6 + " resamplings");
                System.out.println("    Ratio                   : " + ForesterUtil.round(d2, 2));
                System.out.println("    Random number seed      : " + l2);
            }
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                for (File file9 : fileArray) {
                    stringBuilder.append("<tr><td>Intree for gain/loss parsimony analysis:</td><td>" + file9 + "</td></tr>" + string2);
                    System.out.println("  Intree for gain/loss pars.: " + file9);
                }
            }
            if (bl) {
                stringBuilder.append("<tr><td>    Random number seed for Fitch parsimony analysis:</td><td>" + l3 + "</td></tr>" + string2);
                System.out.println("    Random number seed      : " + l3);
            }
            if (mapArray != null && mapArray.length > 0) {
                for (object24 = 0; object24 < fileArray2.length; ++object24) {
                    stringBuilder.append("<tr><td>Secondary features map file:</td><td>" + fileArray2[object24] + "</td></tr>" + string2);
                    System.out.println("Secondary features map file : " + fileArray2[object24] + " [mappings for " + mapArray[object24].size() + " domain ids]");
                }
            }
        }
        System.out.println();
        stringBuilder.append("<tr><td>Command line:</td><td>\n" + commandLineArguments.getCommandLineArgsAsString() + "\n</td></tr>" + string2);
        System.out.println("Command line                : " + commandLineArguments.getCommandLineArgsAsString());
        BufferedWriter[] bufferedWriterArray = null;
        ArrayList[] arrayListArray = null;
        if (string5 != null) {
            String[] treeMap = string5.split("#");
            arrayListArray = new ArrayList[treeMap.length];
            bufferedWriterArray = new BufferedWriter[treeMap.length];
            for (string9 = 0; string9 < treeMap.length; ++string9) {
                void var77_109;
                object6 = treeMap[string9];
                object5 = ((String)object6).split("~");
                iOException = new ArrayList();
                for (String string6 : object5) {
                    iOException.add((DomainId)new DomainId(string6));
                }
                arrayListArray[string9] = iOException;
                object6 = ((String)object6).replace('~', '_');
                String string7 = (String)object6 + SEQ_EXTRACT_SUFFIX;
                if (object22 != null) {
                    String string8 = object22 + ForesterUtil.FILE_SEPARATOR + string7;
                }
                try {
                    bufferedWriterArray[string9] = new BufferedWriter(new FileWriter((String)var77_109));
                    continue;
                }
                catch (IOException iOException10) {
                    ForesterUtil.fatalError(PRG_NAME, "Could not open [" + (String)var77_109 + "]: " + iOException10.getLocalizedMessage());
                }
            }
        }
        TreeMap<Species, List<Protein>> treeMap = null;
        string9 = 0;
        if (object21.size() > 0 || bl12) {
            string9 = 1;
        }
        if (string9 != 0) {
            treeMap = new TreeMap<Species, List<Protein>>();
        }
        object6 = new ArrayList(n4);
        object5 = new TreeSet();
        iOException = new TreeSet();
        Object var77_113 = null;
        ArrayList<BinaryDomainCombination> arrayList5 = null;
        if (phylogenyArray != null && phylogenyArray.length == 1) {
            ArrayList arrayList6 = new ArrayList();
            arrayList5 = new ArrayList<BinaryDomainCombination>();
        }
        DomainLengthsTable domainLengthsTable = new DomainLengthsTable();
        File file10 = new File(object22 + ForesterUtil.FILE_SEPARATOR + file + D_PROMISCUITY_FILE_SUFFIX);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file10));
            bufferedWriter.write("Species:\t");
            bufferedWriter.write("Mean:\t");
            bufferedWriter.write("SD:\t");
            bufferedWriter.write("Median:\t");
            bufferedWriter.write("Min:\t");
            bufferedWriter.write("Max:\t");
            bufferedWriter.write("N:\t");
            bufferedWriter.write("Max Promiscuous Domains:" + ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException11) {
            ForesterUtil.fatalError(PRG_NAME, iOException11.getMessage());
        }
        File file11 = new File(object22 + ForesterUtil.FILE_SEPARATOR + file + LOG_FILE_SUFFIX);
        BufferedWriter bufferedWriter2 = null;
        try {
            bufferedWriter2 = new BufferedWriter(new FileWriter(file11));
        }
        catch (IOException iOException12) {
            ForesterUtil.fatalError(PRG_NAME, iOException12.getMessage());
        }
        BufferedWriter bufferedWriter3 = null;
        try {
            bufferedWriter3 = new BufferedWriter(new FileWriter((File)n8));
            bufferedWriter3.write(DATA_FILE_DESC);
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException13) {
            ForesterUtil.fatalError(PRG_NAME, iOException13.getMessage());
        }
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        BasicDescriptiveStatistics basicDescriptiveStatistics2 = new BasicDescriptiveStatistics();
        TreeMap<Integer, Integer> treeMap2 = new TreeMap<Integer, Integer>();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        BufferedWriter bufferedWriter4 = null;
        try {
            bufferedWriter4 = new BufferedWriter(new FileWriter(object22 + ForesterUtil.FILE_SEPARATOR + file + "__domains_per_potein_stats.txt"));
            bufferedWriter4.write("Genome");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("Mean");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("SD");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("Median");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("N");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("Min");
            bufferedWriter4.write("\t");
            bufferedWriter4.write("Max");
            bufferedWriter4.write("\n");
        }
        catch (IOException iOException14) {
            iOException14.printStackTrace();
        }
        HashMap<String, DescriptiveStatistics> hashMap = null;
        HashMap<String, DescriptiveStatistics> hashMap2 = null;
        HashMap<String, DescriptiveStatistics> hashMap3 = new HashMap<String, DescriptiveStatistics>();
        hashMap = new HashMap<String, DescriptiveStatistics>();
        hashMap2 = new HashMap<String, DescriptiveStatistics>();
        for (int i = 0; i < n4; ++i) {
            int n;
            System.out.println();
            System.out.println(i + 1 + "/" + n4);
            surfacing.log(i + 1 + "/" + n4, bufferedWriter2);
            System.out.println("Processing                                     : " + (String)object17[i][0]);
            surfacing.log("Genome                                         : " + (String)object17[i][0], bufferedWriter2);
            HmmscanPerDomainTableParser hmmscanPerDomainTableParser = null;
            object4 = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE;
            if (map != null) {
                object4 = INDIVIDUAL_SCORE_CUTOFF_DEFAULT;
            }
            if (file3 != null || file4 != null || file5 != null) {
                object3 = HmmscanPerDomainTableParser.FilterType.NONE;
                if (file3 != null) {
                    object3 = HmmscanPerDomainTableParser.FilterType.POSITIVE_PROTEIN;
                } else if (file4 != null) {
                    object3 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_PROTEIN;
                } else if (file5 != null) {
                    object3 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_DOMAIN;
                }
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object17[i][0]), (String)object17[i][1], (Set<DomainId>)stringArray4, (HmmscanPerDomainTableParser.FilterType)((Object)object3), (HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF)((Object)object4), true);
            } else {
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object17[i][0]), (String)object17[i][1], (HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF)((Object)object4), true);
            }
            if (d >= 0.0) {
                hmmscanPerDomainTableParser.setEValueMaximum(d);
            }
            hmmscanPerDomainTableParser.setIgnoreDufs(bl2);
            hmmscanPerDomainTableParser.setIgnoreVirusLikeIds(bl6);
            hmmscanPerDomainTableParser.setIgnoreEngulfedDomains(bl5);
            if (n3 != -1) {
                hmmscanPerDomainTableParser.setMaxAllowedOverlap(n3);
            }
            hmmscanPerDomainTableParser.setReturnType(HmmscanPerDomainTableParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            if (map != null) {
                hmmscanPerDomainTableParser.setIndividualScoreCutoffs(map);
            }
            object3 = null;
            try {
                object3 = hmmscanPerDomainTableParser.parse();
            }
            catch (IOException iOException15) {
                ForesterUtil.fatalError(PRG_NAME, iOException15.getMessage());
            }
            catch (Exception exception) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, exception.getMessage(), exception);
            }
            double d3 = (double)object3.size() / (double)hmmscanPerDomainTableParser.getProteinsEncountered();
            basicDescriptiveStatistics.addValue(d3);
            System.out.println("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered());
            surfacing.log("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered(), bufferedWriter2);
            System.out.println("Number of proteins stored                      : " + object3.size());
            surfacing.log("Number of proteins stored                      : " + object3.size(), bufferedWriter2);
            System.out.println("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * d3) + "%");
            surfacing.log("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * d3) + "%", bufferedWriter2);
            System.out.println("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered());
            surfacing.log("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered(), bufferedWriter2);
            System.out.println("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored());
            surfacing.log("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored(), bufferedWriter2);
            System.out.println("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size());
            surfacing.log("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size(), bufferedWriter2);
            System.out.println("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff());
            surfacing.log("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff(), bufferedWriter2);
            System.out.println("Domains ignored due to E-value                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval());
            surfacing.log("Domains ignored due to E-value                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval(), bufferedWriter2);
            System.out.println("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf());
            surfacing.log("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf(), bufferedWriter2);
            if (bl6) {
                System.out.println("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds());
                surfacing.log("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds(), bufferedWriter2);
            }
            System.out.println("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter());
            surfacing.log("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter(), bufferedWriter2);
            System.out.println("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap());
            surfacing.log("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap(), bufferedWriter2);
            if (file4 != null) {
                System.out.println("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                surfacing.log("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter2);
            }
            if (file3 != null) {
                System.out.println("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                surfacing.log("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter2);
            }
            System.out.println("Time for processing                            : " + hmmscanPerDomainTableParser.getTime() + "ms");
            surfacing.log("", bufferedWriter2);
            stringBuilder.append("<tr><td>" + (String)object17[i][0] + " [species: " + (String)object17[i][1] + "]" + ":</td><td>domains analyzed: " + hmmscanPerDomainTableParser.getDomainsStored() + "; domains ignored: [ind score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff() + "] [E-value cutoff: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval() + "] [DUF: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf() + "] [virus like ids: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds() + "] [negative domain filter: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter() + "] [overlap: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap() + "]");
            if (file4 != null) {
                stringBuilder.append("; proteins ignored due to negative filter: " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
            }
            if (file3 != null) {
                stringBuilder.append("; proteins ignored due to positive filter: " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
            }
            stringBuilder.append("</td></tr>" + string2);
            try {
                n = 0;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Protein)object2.next();
                    bufferedWriter3.write(SurfacingUtil.proteinToDomainCombinations((Protein)object, n + "", "\t").toString());
                    ++n;
                    for (Domain domain : object.getProteinDomains()) {
                        String string10 = domain.getDomainId().toString();
                        if (!hashMap3.containsKey(string10)) {
                            hashMap3.put(string10, new BasicDescriptiveStatistics());
                        }
                        ((DescriptiveStatistics)hashMap3.get(string10)).addValue(domain.getLength());
                    }
                }
            }
            catch (IOException iOException16) {
                ForesterUtil.fatalError(PRG_NAME, iOException16.toString());
            }
            SurfacingUtil.domainsPerProteinsStatistics((String)object17[i][1], (List<Protein>)object3, basicDescriptiveStatistics2, treeMap2, treeSet, treeSet2, treeSet3, bufferedWriter4);
            object6.add(BasicGenomeWideCombinableDomains.createInstance((List<Protein>)object3, bl3, new BasicSpecies((String)object17[i][1]), (Map<DomainId, List<GoId>>)object16, object23, hashMap, hashMap2));
            domainLengthsTable.addLengths((List<Protein>)object3);
            if (((GenomeWideCombinableDomains)object6.get(i)).getSize() > 0) {
                SurfacingUtil.writeDomainCombinationsCountsFile((String[][])object17, (File)object22, bufferedWriter, (GenomeWideCombinableDomains)object6.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object18));
                if (bl4) {
                    SurfacingUtil.writeBinaryDomainCombinationsFileForGraphAnalysis((String[][])object17, (File)object22, (GenomeWideCombinableDomains)object6.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object18));
                }
                SurfacingUtil.addAllDomainIdsToSet((GenomeWideCombinableDomains)object6.get(i), (SortedSet<DomainId>)object5);
                SurfacingUtil.addAllBinaryDomainCombinationToSet((GenomeWideCombinableDomains)object6.get(i), (SortedSet<BinaryDomainCombination>)((Object)iOException));
            }
            if (bufferedWriterArray != null) {
                for (n = 0; n < arrayListArray.length; ++n) {
                    try {
                        SurfacingUtil.extractProteinNames((List<Protein>)object3, arrayListArray[n], (Writer)bufferedWriterArray[n], "\t", LIMIT_SPEC_FOR_PROT_EX);
                        bufferedWriterArray[n].flush();
                        continue;
                    }
                    catch (IOException iOException17) {
                        iOException17.printStackTrace();
                    }
                }
            }
            if (string9 != 0) {
                treeMap.put(new BasicSpecies((String)object17[i][1]), (List<Protein>)object3);
            }
            try {
                bufferedWriter2.flush();
            }
            catch (IOException iOException18) {
                ForesterUtil.fatalError(PRG_NAME, iOException18.getLocalizedMessage());
            }
            System.gc();
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain promiscuities to: " + file10);
        try {
            bufferedWriter4.write("ALL");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.arithmeticMean() + "");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.sampleStandardDeviation() + "");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.median() + "");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.getN() + "");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.getMin() + "");
            bufferedWriter4.write("\t");
            bufferedWriter4.write(basicDescriptiveStatistics2.getMax() + "");
            bufferedWriter4.write("\n");
            bufferedWriter4.close();
            surfacing.printOutPercentageOfMultidomainProteins(treeMap2, bufferedWriter2);
            ForesterUtil.map2file(new File(object22 + ForesterUtil.FILE_SEPARATOR + file + "__all_genomes_domains_per_potein_histo.txt"), treeMap2, "\t", "\n");
            ForesterUtil.collection2file(new File(object22 + ForesterUtil.FILE_SEPARATOR + file + "__domains_always_single_.txt"), treeSet, "\n");
            ForesterUtil.collection2file(new File(object22 + ForesterUtil.FILE_SEPARATOR + file + "__domains_single_or_combined.txt"), treeSet2, "\n");
            ForesterUtil.collection2file(new File(object22 + ForesterUtil.FILE_SEPARATOR + file + "__domains_always_combined.txt"), treeSet3, "\n");
            ForesterUtil.programMessage(PRG_NAME, "Average of proteins with a least one domain assigned: " + 100.0 * basicDescriptiveStatistics.arithmeticMean() + "% (+/-" + 100.0 * basicDescriptiveStatistics.sampleStandardDeviation() + "%)");
            ForesterUtil.programMessage(PRG_NAME, "Range of proteins with a least one domain assigned: " + 100.0 * basicDescriptiveStatistics.getMin() + "%-" + 100.0 * basicDescriptiveStatistics.getMax() + "%");
            surfacing.log("Average of prot with a least one dom assigned  : " + 100.0 * basicDescriptiveStatistics.arithmeticMean() + "% (+/-" + 100.0 * basicDescriptiveStatistics.sampleStandardDeviation() + "%)", bufferedWriter2);
            surfacing.log("Range of prot with a least one dom assigned    : " + 100.0 * basicDescriptiveStatistics.getMin() + "%-" + 100.0 * basicDescriptiveStatistics.getMax() + "%", bufferedWriter2);
        }
        catch (IOException iOException19) {
            ForesterUtil.fatalError(PRG_NAME, iOException19.getLocalizedMessage());
        }
        if (bufferedWriterArray != null) {
            for (int i = 0; i < arrayListArray.length; ++i) {
                try {
                    bufferedWriterArray[i].close();
                    continue;
                }
                catch (IOException iOException20) {
                    ForesterUtil.fatalError(PRG_NAME, iOException20.toString());
                }
            }
        }
        try {
            bufferedWriter.close();
            bufferedWriter3.close();
            bufferedWriter2.close();
        }
        catch (IOException iOException21) {
            ForesterUtil.fatalError(PRG_NAME, iOException21.getLocalizedMessage());
        }
        try {
            SurfacingUtil.executeDomainLengthAnalysis((String[][])object17, n4, domainLengthsTable, file8);
        }
        catch (IOException iOException22) {
            ForesterUtil.fatalError(PRG_NAME, iOException22.toString());
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain length data to: " + file8);
        System.out.println();
        long l4 = new Date().getTime();
        object4 = null;
        object3 = new BasicDomainSimilarityCalculator(domainSimilaritySortField, bl10, n4 == 2);
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object20).ordinal()]) {
            case 1: {
                object4 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            case 2: {
                object4 = new DomainCountsBasedPairwiseSimilarityCalculator();
                break;
            }
            case 3: {
                object4 = new ProteinCountsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
        if (object16 != null) {
            goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
        }
        SortedSet<DomainSimilarity> sortedSet = object3.calculateSimilarities((PairwiseDomainSimilarityCalculator)object4, (List<GenomeWideCombinableDomains>)object6, bl7, bl8);
        SurfacingUtil.decoratePrintableDomainSimilarities(sortedSet, detailedness, goAnnotationOutput, (Map<GoId, GoTerm>)object14, (GoNameSpace)object13);
        DescriptiveStatistics descriptiveStatistics = null;
        try {
            void var105_171;
            object2 = file.toString();
            object = null;
            iterator = null;
            if (sortedSet.size() > 1000) {
                if (((String)object2).endsWith(".html")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 5);
                }
                object = new HashMap<Character, Writer>();
                surfacing.createSplitWriters((File)object22, (String)object2, object);
            } else if (!((String)object2).endsWith(".html")) {
                object2 = (String)object2 + ".html";
                iterator = new BufferedWriter(new FileWriter(object22 + ForesterUtil.FILE_SEPARATOR + (String)object2));
            }
            Object var105_169 = null;
            if (bl11) {
                ArrayList<BasicSpecies> arrayList7 = new ArrayList<BasicSpecies>();
                for (int i = 0; i < n4; ++i) {
                    arrayList7.add(new BasicSpecies((String)object17[i][1]));
                }
            }
            stringBuilder.append("<tr><td>Sum of all distinct binary combinations:</td><td>" + iOException.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Sum of all distinct domains:</td><td>" + object5.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Analysis date/time:</td><td>" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()) + "</td></tr>" + string2);
            stringBuilder.append("</table>" + string2);
            descriptiveStatistics = SurfacingUtil.writeDomainSimilaritiesToFile(stringBuilder, new StringBuilder(n4 + " genomes"), (Writer)((Object)iterator), object, sortedSet, n4 == 2, (List<Species>)var105_171, (PrintableDomainSimilarity.PRINT_OPTION)((Object)object19), domainSimilaritySortField, (DomainSimilarity.DomainSimilarityScoring)((Object)object20), true);
            ForesterUtil.programMessage(PRG_NAME, "Wrote main output (includes domain similarities) to: \"" + (String)(object22 == null ? object2 : object22 + ForesterUtil.FILE_SEPARATOR + (String)object2) + "\"");
        }
        catch (IOException iOException23) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write similarites to: \"" + file + "\" [" + iOException23.getMessage() + "]");
        }
        System.out.println();
        object2 = new Species[n4];
        for (int i = 0; i < n4; ++i) {
            object2[i] = new BasicSpecies((String)object17[i][1]);
        }
        ArrayList<Phylogeny> arrayList8 = null;
        if (n4 > 2 && bl13) {
            void var105_177;
            iterator = new PairwiseGenomeComparator();
            ((PairwiseGenomeComparator)((Object)iterator)).performPairwiseComparisons(stringBuilder, bl10, detailedness, bl7, bl8, domainSimilaritySortField2, (PrintableDomainSimilarity.PRINT_OPTION)((Object)object19), (DomainSimilarity.DomainSimilarityScoring)((Object)object20), (Map<DomainId, List<GoId>>)object16, (Map<GoId, GoTerm>)object14, (GoNameSpace)object13, (Species[])object2, n4, (List<GenomeWideCombinableDomains>)object6, (PairwiseDomainSimilarityCalculator)object4, string, true, PAIRWISE_DOMAIN_COMPARISONS_PREFIX, PRG_NAME, (File)object22, bl14);
            String string11 = new String(file.toString());
            if (string11.indexOf(46) > 1) {
                String string12 = string11.substring(0, string11.indexOf(46));
            }
            if (object22 != null) {
                void var105_175;
                String string13 = object22 + ForesterUtil.FILE_SEPARATOR + (String)var105_175;
                file = new File(object22 + ForesterUtil.FILE_SEPARATOR + file);
            }
            SurfacingUtil.writeMatrixToFile(new File((String)var105_177 + MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getDomainDistanceScoresMeans());
            SurfacingUtil.writeMatrixToFile(new File((String)var105_177 + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedBinaryCombinationsBasedDistances());
            SurfacingUtil.writeMatrixToFile(new File((String)var105_177 + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedDomainsBasedDistances());
            Phylogeny phylogeny = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var105_177 + NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getDomainDistanceScoresMeans().get(0));
            Phylogeny phylogeny2 = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var105_177 + NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedBinaryCombinationsBasedDistances().get(0));
            Phylogeny phylogeny3 = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var105_177 + NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedDomainsBasedDistances().get(0));
            arrayList8 = new ArrayList<Phylogeny>();
            arrayList8.add(phylogeny);
            arrayList8.add(phylogeny2);
            arrayList8.add(phylogeny3);
            if (bl15) {
                ((PairwiseGenomeComparator)((Object)iterator)).performPairwiseComparisonsJacknifed((Species[])object2, n4, (List<GenomeWideCombinableDomains>)object6, true, n6, d2, l2);
                SurfacingUtil.writeMatrixToFile(new File((String)var105_177 + "_" + ForesterUtil.round(d2, 2) + "_" + n6 + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedBinaryCombinationsBasedDistances());
                SurfacingUtil.writeMatrixToFile(new File((String)var105_177 + "_" + ForesterUtil.round(d2, 2) + "_" + n6 + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedDomainsBasedDistances());
            }
        }
        if (object22 != null && !bl13) {
            file = new File(object22 + ForesterUtil.FILE_SEPARATOR + file);
        }
        surfacing.writePresentToNexus(file, file3, (SortedSet<DomainId>)stringArray4, (List<GenomeWideCombinableDomains>)object6);
        if (phylogenyArray != null && phylogenyArray.length > 0 && n4 > 2) {
            iterator = surfacing.createParametersAsString(bl2, d, n3, bl5, file2, object23);
            String string14 = "_";
            if (bl) {
                String string15 = string14 + l3 + "_";
            }
            int n = 0;
            for (Phylogeny phylogeny : phylogenyArray) {
                void var105_181;
                String string16 = ForesterUtil.removeSuffix(file.toString()) + (String)var105_181 + ForesterUtil.removeSuffix(fileArray[n].toString());
                DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object6);
                SurfacingUtil.executeParsimonyAnalysis(l3, bl, string16, domainParsimonyCalculator, phylogeny, (Map<DomainId, List<GoId>>)object16, (Map<GoId, GoTerm>)object14, (GoNameSpace)object13, ((StringBuilder)((Object)iterator)).toString(), mapArray, (SortedSet<DomainId>)(file3 == null ? null : stringArray4), bl4, (List<BinaryDomainCombination>)var77_115, arrayList5, object23, hashMap, hashMap2, hashMap3);
                if (mapArray != null && mapArray.length > 0) {
                    int n2 = 0;
                    for (Map map2 : mapArray) {
                        TreeMap<Species, MappingResults> treeMap3 = new TreeMap<Species, MappingResults>();
                        DomainParsimonyCalculator domainParsimonyCalculator2 = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object6, map2);
                        SurfacingUtil.executeParsimonyAnalysisForSecondaryFeatures(string16 + "_" + fileArray2[n2++], domainParsimonyCalculator2, phylogeny, ((StringBuilder)((Object)iterator)).toString(), treeMap3);
                        if (n != 0) continue;
                        System.out.println();
                        System.out.println("Mapping to secondary features:");
                        for (Species species : treeMap3.keySet()) {
                            MappingResults mappingResults = (MappingResults)treeMap3.get(species);
                            int n7 = mappingResults.getSumOfFailures() + mappingResults.getSumOfSuccesses();
                            System.out.print(species + ":");
                            System.out.print(" mapped domains = " + mappingResults.getSumOfSuccesses());
                            System.out.print(", not mapped domains = " + mappingResults.getSumOfFailures());
                            if (n7 > 0) {
                                System.out.println(", mapped ratio = " + 100 * mappingResults.getSumOfSuccesses() / n7 + "%");
                                continue;
                            }
                            System.out.println(", mapped ratio = n/a (total domains = 0 )");
                        }
                    }
                }
                ++n;
            }
        }
        if (object21.size() > 0) {
            surfacing.executePlusMinusAnalysis(file, (List<String>)object21, arrayList2, arrayList3, (List<GenomeWideCombinableDomains>)object6, treeMap, (Map<DomainId, List<GoId>>)object16, (Map<GoId, GoTerm>)object14, arrayList4);
        }
        if (bl12) {
            surfacing.writeProteinListsForAllSpecies((File)object22, treeMap, (List<GenomeWideCombinableDomains>)object6);
        }
        if (var77_115 != null) {
            try {
                surfacing.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX), (List<BinaryDomainCombination>)var77_115, object5.size(), (SortedSet<BinaryDomainCombination>)((Object)iOException), true);
            }
            catch (IOException iOException24) {
                ForesterUtil.fatalError(PRG_NAME, iOException24.getLocalizedMessage());
            }
        }
        if (arrayList5 != null) {
            try {
                surfacing.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX), arrayList5, object5.size(), (SortedSet<BinaryDomainCombination>)((Object)iOException), false);
            }
            catch (IOException iOException25) {
                ForesterUtil.fatalError(PRG_NAME, iOException25.getLocalizedMessage());
            }
        }
        iterator = Runtime.getRuntime();
        long l5 = ((Runtime)((Object)iterator)).freeMemory() / 1000000L;
        long l6 = ((Runtime)((Object)iterator)).totalMemory() / 1000000L;
        ForesterUtil.programMessage(PRG_NAME, "Time for analysis : " + (new Date().getTime() - l4) + "ms");
        ForesterUtil.programMessage(PRG_NAME, "Total running time: " + (new Date().getTime() - l) + "ms ");
        ForesterUtil.programMessage(PRG_NAME, "Free memory       : " + l5 + "MB, total memory: " + l6 + "MB");
        ForesterUtil.programMessage(PRG_NAME, "If this application is useful to you, please cite:");
        ForesterUtil.programMessage(PRG_NAME, WWW);
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void createSplitWriters(File file, String string, Map<Character, Writer> map) throws IOException {
        map.put(Character.valueOf('a'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_A.html")));
        map.put(Character.valueOf('b'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_B.html")));
        map.put(Character.valueOf('c'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_C.html")));
        map.put(Character.valueOf('d'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_D.html")));
        map.put(Character.valueOf('e'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_E.html")));
        map.put(Character.valueOf('f'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_F.html")));
        map.put(Character.valueOf('g'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_G.html")));
        map.put(Character.valueOf('h'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_H.html")));
        map.put(Character.valueOf('i'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_I.html")));
        map.put(Character.valueOf('j'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_J.html")));
        map.put(Character.valueOf('k'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_K.html")));
        map.put(Character.valueOf('l'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_L.html")));
        map.put(Character.valueOf('m'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_M.html")));
        map.put(Character.valueOf('n'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_N.html")));
        map.put(Character.valueOf('o'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_O.html")));
        map.put(Character.valueOf('p'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_P.html")));
        map.put(Character.valueOf('q'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Q.html")));
        map.put(Character.valueOf('r'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_R.html")));
        map.put(Character.valueOf('s'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_S.html")));
        map.put(Character.valueOf('t'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_T.html")));
        map.put(Character.valueOf('u'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_U.html")));
        map.put(Character.valueOf('v'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_V.html")));
        map.put(Character.valueOf('w'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_W.html")));
        map.put(Character.valueOf('x'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_X.html")));
        map.put(Character.valueOf('y'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Y.html")));
        map.put(Character.valueOf('z'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Z.html")));
        map.put(Character.valueOf('0'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_0.html")));
    }

    private static void printOutPercentageOfMultidomainProteins(SortedMap<Integer, Integer> sortedMap, Writer writer) {
        int n = 0;
        for (Map.Entry<Integer, Integer> entry : sortedMap.entrySet()) {
            n += entry.getValue().intValue();
        }
        double d = 100.0 * (double)(n - (Integer)sortedMap.get(1)) / (double)n;
        ForesterUtil.programMessage(PRG_NAME, "Percentage of multidomain proteins: " + d + "%");
        surfacing.log("Percentage of multidomain proteins:            : " + d + "%", writer);
    }

    private static void preparePhylogenyForParsimonyAnalyses(Phylogeny phylogeny, String[][] stringArray) {
        int n;
        List<String> list;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (phylogeny.getNodes(stringArray[i][1]).size() > 1) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + stringArray[i][1] + "] is not unique in input tree " + phylogeny.getName());
            }
            stringArray2[i] = stringArray[i][1];
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            list = phylogenyNodeIterator.next();
            if (!ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getName())) continue;
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getTaxonomyCode())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getTaxonomyCode());
                continue;
            }
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getScientificName())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getScientificName());
                continue;
            }
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getCommonName())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getCommonName());
                continue;
            }
            ForesterUtil.fatalError(PRG_NAME, "node with no name, scientific name, common name, or taxonomy code present");
        }
        list = PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray2, phylogeny);
        if (list.size() > 0) {
            System.out.println("Not using the following " + list.size() + " nodes:");
            for (n = 0; n < list.size(); ++n) {
                System.out.println(" " + n + ": " + (String)list.get(n));
            }
            System.out.println("--");
        }
        for (n = 0; n < stringArray.length; ++n) {
            try {
                phylogeny.getNode(stringArray[n][1]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + stringArray[n][1] + "] not present/not unique in input tree");
            }
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -Xms256m -Xmx512m -cp forester.jar org.forester.applications.surfacing [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Note: This software might need a significant amount of memory (heap space);");
        System.out.println("       hence use \"-Xms128m -Xmx512m\" (or more) to prevent a \"java.lang.OutOfMemoryError\".");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("detail: level of detail for similarities output file (default:" + (Object)((Object)DETAILEDNESS_DEFAULT) + ")");
        System.out.println("ignore_self_comb: to ignore combinations with self (default: not to ignore)");
        System.out.println("ignore_singlet_domains: to ignore domains without combinations in any species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("ignore_species_specific_domains: to ignore domains specific to one species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("dufs: to _not_ ignore DUFs (domains with unknown function) (default: ignore DUFs)");
        System.out.println("ignore_viral_ids: to ignore domains with ids containing 'vir', 'retro', 'transpos', 'phage', or starting with 'rv' or 'gag_'");
        System.out.println("sort: sorting for similarities (default: " + (Object)((Object)DOMAIN_SORT_FILD_DEFAULT) + ")");
        System.out.println("o: name for (main) output file (mandatory)");
        System.out.println("e: max (inclusive) E-value");
        System.out.println("mo: maximal allowed domain overlap");
        System.out.println("no_eo: to ignore engulfed lower confidence domains");
        System.out.println("smatrix: species matrix");
        System.out.println("scoring: scoring (default:" + (Object)((Object)SCORING_DEFAULT) + ")");
        System.out.println("dc_sort: sorting for domain counts (default:" + (Object)((Object)DOMAINS_SORT_ORDER_DEFAULT) + ")");
        System.out.println("ds_output: domain similarity print option (default:" + (Object)((Object)DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT) + ")");
        System.out.println("cos: cutoff score file");
        System.out.println("species_first: sort by species count first");
        System.out.println("out_dir: output directory");
        System.out.println("p2g: Pfam to GO mapping file");
        System.out.println("obo: GO terms file (OBO format)");
        System.out.println("go_namespace: limit GO term to one GO namespace");
        System.out.println("pwc[=<suffix for pairwise comparison output files>]: to perform pairwise comparison based analyses");
        System.out.println("species_tree: species tree, to perform (Dollo, Fitch) parismony analyses");
        System.out.println("jack: perform jacknife resampling for domain and binary domain combination based distance matrices [default resamplings: 100]");
        System.out.println("jack_ratio: ratio for jacknife resampling [default: 0.5]");
        System.out.println("seed: seed for random number generator for jacknife resampling [default: 19]");
        System.out.println("species_tree=<treefiles in phyloXML format, separated by #>: to infer domain/binary domain combination gains/losses on given species trees");
        System.out.println("pos_filter=<file>: to filter out proteins not containing at least one domain listed in <file>");
        System.out.println("neg_filter=<file>: to filter out proteins containing at least one domain listed in <file>");
        System.out.println("neg_dom_filter=<file>: to filter out (ignore) domains listed in <file>");
        System.out.println("input=<file>: to read input files from <file>");
        System.out.println("random_seed=<seed>: seed for random number generator for Fitch Parsimony analysis (type: long, default: no randomization - given a choice, prefer absence");
        System.out.println("consider_bdc_direction: to consider directedness in binary combinations: e.g. A-B != B-A");
        System.out.println("consider_bdc_adj: to consider directedness and adjacency in binary combinations");
        System.out.println("prot_extract=<domain ids (Pfam names)>: to extract sequence names of sequences containing matching domains and/or domain-sequences (order N to C) (domain separator: '~', domain sequences speparator: '#', e.g. 'NACHT#BIR~CARD')");
        System.out.println("secondary=<file>: to perfom parsimony analysis on secondary features");
        System.out.println("plus_minus=<file>: to presence/absence genome analysis");
        System.out.println("graph_analysis_out: to output binary domain combinations for (downstream) graph analysis");
        System.out.println("all_prot: to output all proteins per domain");
        System.out.println();
        System.out.println("Example 1: java -Xms128m -Xmx512m -cp path/to/forester.jar org.forester.application.surfacing p2g=pfam2go_2012_02_07.txt -dufs -cos=Pfam_260_NC1 -no_eo -mo=0 -input=genomes_limited.txt -out_dir=out -o=o  -species_tree=tol.xml -obo=gene_ontology_2012_02_07.obo -pos_filter=f.txt -all_prot");
        System.out.println();
        System.out.println("Example 2: java -Xms128m -Xmx512m -cp path/to/forester.jar org.forester.application.surfacing -detail=punctilious -o=TEST.html -pwc=TEST -cos=Pfam_ls_22_TC2 -p2g=pfam2go -obo=gene_ontology_edit.obo -dc_sort=dom -ignore_with_self -no_singles -e=0.001 -mo=1 -no_eo -ds_output=detailed_html -scoring=domains -sort=alpha human mouse brafl strpu");
        System.out.println();
    }

    private static void processFilter(File file, SortedSet<DomainId> sortedSet) {
        SortedSet<String> sortedSet2 = null;
        try {
            sortedSet2 = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        if (sortedSet2 != null) {
            for (String string : sortedSet2) {
                sortedSet.add(new DomainId(string));
            }
        }
    }

    private static String[][] processInputFileNames(String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(35) < 0) {
                stringArray2[i] = new String[2];
                stringArray2[i][0] = stringArray[i];
                stringArray2[i][1] = stringArray[i];
            } else {
                stringArray2[i] = stringArray[i].split("#");
                if (stringArray2[i].length != 3) {
                    ForesterUtil.fatalError(PRG_NAME, "properties for the input files (hmmpfam output) are expected to be in the following format \"<hmmpfam output file>#<species>\" (or just one word, which is both the filename and the species id), instead received \"" + stringArray[i] + "\"");
                }
            }
            String string = ForesterUtil.isReadableFile(new File(stringArray2[i][0]));
            if (ForesterUtil.isEmpty(string)) continue;
            ForesterUtil.fatalError(PRG_NAME, string);
        }
        return stringArray2;
    }

    private static void processPlusMinusAnalysisOption(CommandLineArguments commandLineArguments, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        if (commandLineArguments.isOptionSet(PLUS_MINUS_ANALYSIS_OPTION)) {
            File file;
            String string;
            if (!commandLineArguments.isOptionValueSet(PLUS_MINUS_ANALYSIS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for 'plus-minus' file: -plus_minus=<file>");
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file = new File(commandLineArguments.getOptionValue(PLUS_MINUS_ANALYSIS_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file + "\": " + string);
            }
            surfacing.processPlusMinusFile(file, list, list2, list3, list4);
        }
    }

    private static void processPlusMinusFile(File file, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        SortedSet<String> sortedSet = null;
        int n = 0;
        double d = 1.0;
        try {
            sortedSet = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        if (sortedSet != null) {
            for (String string : sortedSet) {
                String string2 = string.substring(1);
                if (string.startsWith("+")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list.add(string2);
                } else if (string.startsWith("*")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list2.add(string2);
                } else if (string.startsWith("-")) {
                    if (list.contains(string2) || list2.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' or '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list3.add(string2);
                } else if (string.startsWith("$D")) {
                    try {
                        n = Integer.parseInt(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse integer value for minimal difference from: \"" + string.substring(3) + "\"");
                    }
                } else if (string.startsWith("$F")) {
                    try {
                        d = Double.parseDouble(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse double value for factor from: \"" + string.substring(3) + "\"");
                    }
                } else if (!string.startsWith("#")) {
                    ForesterUtil.fatalError(PRG_NAME, "species/genome names in 'plus minus' file must begin with '*' (high copy target genome), '+' (high copy base genomes), '-' (low copy genomes), '$D=<integer>' minimal Difference (default is 1), '$F=<double>' factor (default is 1.0), double), or '#' (ignore) suffix, encountered: \"" + string + "\"");
                }
                list4.add(new Integer(n + ""));
                list4.add(new Double(d + ""));
            }
        } else {
            ForesterUtil.fatalError(PRG_NAME, "'plus minus' file [" + file + "] appears empty");
        }
    }

    private static void writePresentToNexus(File file, File file2, SortedSet<DomainId> sortedSet, List<GenomeWideCombinableDomains> list) {
        try {
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(list, file2 == null ? null : sortedSet), file + "_dom.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(list), file + "_dc.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
        }
    }

    private static void writeProteinListsForAllSpecies(File file, SortedMap<Species, List<Protein>> sortedMap, List<GenomeWideCombinableDomains> list) {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains object : list) {
            treeSet.addAll(object.getAllDomainIds());
        }
        for (DomainId domainId : treeSet) {
            File file2 = new File(file + ForesterUtil.FILE_SEPARATOR + domainId + SEQ_EXTRACT_SUFFIX);
            SurfacingUtil.checkForOutputFileWriteability(file2);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                SurfacingUtil.extractProteinNames(sortedMap, domainId, (Writer)bufferedWriter, "\t", LIMIT_SPEC_FOR_PROT_EX);
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "Wrote proteins list to \"" + file2 + "\"");
        }
    }
}

