/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import briefj.BriefLists;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class BriefParallel {
    public static void process(int numberOfTasks, int numberOfThreads, Consumer<Integer> operation) {
        if (numberOfThreads < 1) {
            throw new RuntimeException("Number of threads cannot be negative");
        }
        ContiguousSet<Integer> taskIndices = BriefLists.integers(numberOfTasks);
        if (numberOfThreads == 1) {
            UnmodifiableIterator unmodifiableIterator = taskIndices.iterator();
            while (unmodifiableIterator.hasNext()) {
                int taskIndex = (Integer)unmodifiableIterator.next();
                operation.accept(taskIndex);
            }
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        Throwable[] exception = new Throwable[1];
        UnmodifiableIterator unmodifiableIterator = taskIndices.iterator();
        while (unmodifiableIterator.hasNext()) {
            int taskIndex = (Integer)unmodifiableIterator.next();
            executor.execute(() -> {
                if (exception[0] != null) return;
                try {
                    operation.accept(taskIndex);
                    return;
                }
                catch (Throwable t) {
                    Throwable[] throwableArray2 = exception;
                    synchronized (exception) {
                        if (exception[0] == null) return;
                        throwableArray[0] = t;
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (exception[0] != null) {
            throw new RuntimeException(exception[0]);
        }
    }

    private BriefParallel() {
    }
}

