/*
 * Decompiled with CFR 0.152.
 */
package briefj.run;

import binc.Command;
import briefj.BriefFiles;
import briefj.BriefStrings;
import briefj.OutputManager;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class Results {
    private static final String SPECIFIED_RESULT_FOLDER = "SPECIFIED_RESULT_FOLDER";
    private static OutputManager globalOutputManager = null;
    private static File resultFolder = null;
    public static String DEFAULT_ALL_NAME = "all";
    public static String DEFAULT_POOL_NAME = "results";
    private static File poolFolder = new File(DEFAULT_POOL_NAME);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getResultFolder() {
        if (resultFolder != null) {
            return resultFolder;
        }
        String string = SPECIFIED_RESULT_FOLDER;
        synchronized (SPECIFIED_RESULT_FOLDER) {
            if (resultFolder != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return resultFolder;
            }
            resultFolder = Results.initResultFolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resultFolder;
        }
    }

    public static File getFileInResultFolder(String fileName) {
        return new File(Results.getResultFolder(), fileName);
    }

    public static OutputManager getGlobalOutputManager() {
        if (globalOutputManager == null) {
            globalOutputManager = new OutputManager();
            globalOutputManager.setOutputFolder(Results.getResultFolder());
        }
        return globalOutputManager;
    }

    private static void refreshSoftlinks(File result) {
        File poolFolder = result.getParentFile().getParentFile();
        String latestString = "latest";
        File latestFolderSoftLink = new File(poolFolder, "latest");
        if (latestFolderSoftLink.exists()) {
            latestFolderSoftLink.delete();
        }
        try {
            Command.call((Command)Command.cmd((String)"ln").withArgs("-s").appendArg(result.getAbsolutePath()).appendArg(latestFolderSoftLink.toString()));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String nextRandomResultFolderName() {
        return BriefStrings.currentDataString() + "-" + BriefStrings.generateUniqueId() + ".exec";
    }

    private static File initResultFolder() {
        String fromEnvironment = System.getenv().get(SPECIFIED_RESULT_FOLDER);
        if (!StringUtils.isEmpty((CharSequence)fromEnvironment)) {
            File result = new File(fromEnvironment);
            BriefFiles.createParentDirs(result);
            result.mkdir();
            return result;
        }
        String name = Results.nextRandomResultFolderName();
        if (!poolFolder.exists()) {
            poolFolder.mkdir();
        }
        if (!poolFolder.isDirectory()) {
            throw new RuntimeException();
        }
        File allResults = new File(poolFolder, "all");
        allResults.mkdir();
        File result = new File(allResults, name);
        result.mkdir();
        Results.refreshSoftlinks(result);
        return result;
    }

    public static File getFolderInResultFolder(String string) {
        File result = Results.getFileInResultFolder(string);
        result.mkdirs();
        return result;
    }

    public static void setResultsFolder(File poolFolder) {
        if (resultFolder != null) {
            throw new RuntimeException("Cannot set the pool after the result folder created (it is too late)");
        }
        Results.poolFolder = poolFolder;
    }
}

