/*
 * Decompiled with CFR 0.152.
 */
package briefj.run;

import briefj.opt.IOUtils;
import briefj.opt.StrUtils;
import briefj.opt.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class SysInfoUtils {
    private static int numCPUs = -1;
    private static int cpuSpeed = -1;

    public static String getCurrentDateStr() {
        return new Date().toString();
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "(unknown)";
        }
    }

    public static String getShortHostName() {
        String name = SysInfoUtils.getHostName();
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getcwd() {
        return System.getProperty("user.dir");
    }

    public static int getNumCPUs() {
        if (numCPUs != -1) {
            return numCPUs;
        }
        try {
            int n = 0;
            for (String line : IOUtils.readLines("/proc/cpuinfo")) {
                if (!line.startsWith("processor")) continue;
                ++n;
            }
            numCPUs = n;
            return numCPUs;
        }
        catch (IOException e) {
            try {
                numCPUs = Integer.parseInt(StrUtils.split(Utils.systemGetStringOutput("sysctl hw.ncpu").trim(), " ")[1]);
                return numCPUs;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    public static int getNumUsedCPUs() {
        try {
            int n = 0;
            for (String line : StrUtils.split(Utils.systemGetStringOutput("ps ax -o pcpu"), "\n")) {
                double percentCPU = Utils.parseDoubleEasy(line);
                if (percentCPU > 50.0) {
                    ++n;
                }
                if (percentCPU > 150.0) {
                    ++n;
                }
                if (percentCPU > 250.0) {
                    ++n;
                }
                if (!(percentCPU > 350.0)) continue;
                ++n;
            }
            return n;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getNumFreeCPUs() {
        return SysInfoUtils.getNumCPUs() - SysInfoUtils.getNumUsedCPUs();
    }

    public static int getCPUSpeed() {
        if (cpuSpeed != -1) {
            return cpuSpeed;
        }
        try {
            double sum = 0.0;
            int n = 0;
            for (String line : IOUtils.readLines("/proc/cpuinfo")) {
                if (!line.startsWith("cpu MHz")) continue;
                String[] split = StrUtils.split(line);
                sum += Double.parseDouble(split[split.length - 1]);
                ++n;
            }
            cpuSpeed = (int)(sum / (double)n + 0.5);
            return cpuSpeed;
        }
        catch (IOException e) {
            try {
                cpuSpeed = Integer.parseInt(StrUtils.split(Utils.systemGetStringOutput("sysctl hw.cpufrequency").trim(), " ")[1]) / 1000000;
                return cpuSpeed;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    public static String getCPUSpeedStr() {
        return SysInfoUtils.getCPUSpeed() + " MHz";
    }

    public static String getMaxMemoryStr() {
        long mem = Runtime.getRuntime().maxMemory();
        return SysInfoUtils.bytesToString(mem);
    }

    public static String getUsedMemoryStr() {
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        return SysInfoUtils.bytesToString(totalMem - freeMem);
    }

    public static String bytesToString(long b) {
        double gb = (double)b / 1.073741824E9;
        if (gb >= 1.0) {
            return gb >= 10.0 ? (int)gb + "G" : SysInfoUtils.round(gb, 1) + "G";
        }
        double mb = (double)b / 1048576.0;
        if (mb >= 1.0) {
            return mb >= 10.0 ? (int)mb + "M" : SysInfoUtils.round(mb, 1) + "M";
        }
        double kb = (double)b / 1024.0;
        if (kb >= 1.0) {
            return kb >= 10.0 ? (int)kb + "K" : SysInfoUtils.round(kb, 1) + "K";
        }
        return b + "";
    }

    public static double round(double x, int numPlaces) {
        double scale = Math.pow(10.0, numPlaces);
        return (double)Math.round(x * scale) / scale;
    }

    public static long getFreeMemory() {
        try {
            long memfree = 0L;
            long buffers = 0L;
            long cached = 0L;
            for (String line : IOUtils.readLines("/proc/meminfo")) {
                if (line.startsWith("MemFree:")) {
                    memfree = Long.parseLong(line.split("\\s+")[1]);
                }
                if (line.startsWith("Buffers:")) {
                    buffers = Long.parseLong(line.split("\\s+")[1]);
                }
                if (!line.startsWith("Cached:")) continue;
                cached = Long.parseLong(line.split("\\s+")[1]);
            }
            return (memfree + buffers + cached) * 1024L;
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

