/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import spoon.processing.FactoryAccessor;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.support.compiler.jdt.JDTTreeBuilder;

public class ParentExiter
extends CtInheritanceScanner {
    private final JDTTreeBuilder jdtTreeBuilder;
    CtElement child;

    ParentExiter(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    @Override
    public void scanCtElement(CtElement e) {
        if (this.child instanceof CtAnnotation && this.jdtTreeBuilder.context.annotationValueName.isEmpty()) {
            e.addAnnotation((CtAnnotation)this.child);
            return;
        }
    }

    @Override
    public <R> void scanCtExecutable(CtExecutable<R> e) {
        if (this.child instanceof CtParameter) {
            e.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        super.scanCtExecutable(e);
    }

    @Override
    public void scanCtGenericElement(CtGenericElement e) {
    }

    @Override
    public void scanCtLoop(CtLoop loop) {
        if (loop.getBody() == null && this.child instanceof CtStatement) {
            loop.setBody((CtStatement)this.child);
        }
        super.scanCtLoop(loop);
    }

    @Override
    public <T, E extends CtExpression<?>> void scanCtTargetedExpression(CtTargetedExpression<T, E> targetedExpression) {
        if (!this.jdtTreeBuilder.context.target.isEmpty() && this.jdtTreeBuilder.context.target.peek() == targetedExpression) {
            targetedExpression.setTarget((CtExpression)this.child);
            return;
        }
        super.scanCtTargetedExpression(targetedExpression);
    }

    @Override
    public <T> void scanCtType(CtType<T> type) {
        if (this.child instanceof CtType) {
            if (type.getNestedTypes().contains(this.child)) {
                type.getNestedTypes().remove(this.child);
            }
            type.addNestedType((CtType)this.child);
            return;
        }
        if (this.child instanceof CtField) {
            type.addField((CtField)this.child);
            return;
        }
        if (this.child instanceof CtConstructor) {
            return;
        }
        if (this.child instanceof CtMethod) {
            type.addMethod((CtMethod)this.child);
            return;
        }
        super.scanCtType(type);
    }

    @Override
    public <T> void scanCtVariable(CtVariable<T> v) {
        if (this.child instanceof CtExpression && !this.jdtTreeBuilder.context.arguments.isEmpty() && this.jdtTreeBuilder.context.arguments.peek() == v) {
            v.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.scanCtVariable(v);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        String name = this.jdtTreeBuilder.context.annotationValueName.peek();
        FactoryAccessor value = this.child;
        if (value instanceof CtVariableAccess) {
            value = ((CtVariableAccess)value).getVariable();
        }
        if (value instanceof CtFieldReference && ((CtFieldReference)value).getSimpleName().equals("class")) {
            value = ((CtFieldReference)value).getType();
        }
        annotation.getElementValues().put(name, value);
        super.visitCtAnnotation(annotation);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        super.visitCtAnonymousExecutable(e);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        if (this.jdtTreeBuilder.context.arguments.size() > 0 && this.jdtTreeBuilder.context.arguments.peek() == arrayAccess) {
            arrayAccess.setIndexExpression((CtExpression)this.child);
            return;
        }
        if (arrayAccess.getTarget() == null) {
            arrayAccess.setTarget((CtExpression)this.child);
            return;
        }
        super.visitCtArrayAccess(arrayAccess);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        if (this.child instanceof CtExpression) {
            if (!this.jdtTreeBuilder.context.arguments.isEmpty() && this.jdtTreeBuilder.context.arguments.peek() == asserted) {
                asserted.setExpression((CtExpression)this.child);
                return;
            }
            asserted.setAssertExpression((CtExpression)this.child);
            return;
        }
        super.visitCtAssert(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        if (assignement.getAssigned() == null) {
            assignement.setAssigned((CtExpression)this.child);
            return;
        }
        if (assignement.getAssignment() == null) {
            assignement.setAssignment((CtExpression)this.child);
            return;
        }
        super.visitCtAssignment(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (this.child instanceof CtExpression) {
            if (operator.getLeftHandOperand() == null) {
                operator.setLeftHandOperand((CtExpression)this.child);
                return;
            }
            if (operator.getRightHandOperand() == null) {
                operator.setRightHandOperand((CtExpression)this.child);
                return;
            }
        }
        super.visitCtBinaryOperator(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        if (this.child instanceof CtStatement) {
            block.addStatement((CtStatement)this.child);
            return;
        }
        super.visitCtBlock(block);
    }

    @Override
    public <E> void visitCtCase(CtCase<E> caseStatement) {
        if (this.jdtTreeBuilder.context.selector && caseStatement.getCaseExpression() == null && this.child instanceof CtExpression) {
            caseStatement.setCaseExpression((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            caseStatement.addStatement((CtStatement)this.child);
            return;
        }
        super.visitCtCase(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        if (this.child instanceof CtBlock) {
            catchBlock.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtCatchVariable) {
            catchBlock.setParameter((CtCatchVariable)this.child);
            return;
        }
        super.visitCtCatch(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (this.child instanceof CtConstructor) {
            CtConstructor c = (CtConstructor)this.child;
            ctClass.addConstructor(c);
            if (c.getPosition() != null && c.getPosition().equals(ctClass.getPosition())) {
                c.setImplicit(true);
            }
        }
        if (this.child instanceof CtAnonymousExecutable) {
            ctClass.addAnonymousExecutable((CtAnonymousExecutable)this.child);
        }
        super.visitCtClass(ctClass);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        if (this.child instanceof CtExpression) {
            if (conditional.getCondition() == null) {
                conditional.setCondition((CtExpression)this.child);
            } else if (conditional.getThenExpression() == null) {
                conditional.setThenExpression((CtExpression)this.child);
            } else if (conditional.getElseExpression() == null) {
                conditional.setElseExpression((CtExpression)this.child);
            }
        }
        super.visitCtConditional(conditional);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        if (doLoop.getBody() != null && this.child instanceof CtExpression && doLoop.getLoopingExpression() == null) {
            doLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtDo(doLoop);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        if (f.getDefaultExpression() == null && this.child instanceof CtExpression && !(this.child instanceof CtAnnotation)) {
            f.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.visitCtField(f);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (this.jdtTreeBuilder.context.forinit && this.child instanceof CtStatement) {
            forLoop.addForInit((CtStatement)this.child);
            return;
        }
        if (!this.jdtTreeBuilder.context.forupdate && forLoop.getExpression() == null && this.child instanceof CtExpression) {
            forLoop.setExpression((CtExpression)this.child);
            return;
        }
        if (this.jdtTreeBuilder.context.forupdate && this.child instanceof CtStatement) {
            forLoop.addForUpdate((CtStatement)this.child);
            return;
        }
        super.visitCtFor(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        if (foreach.getVariable() == null && this.child instanceof CtVariable) {
            foreach.setVariable((CtLocalVariable)this.child);
            return;
        }
        if (foreach.getExpression() == null && this.child instanceof CtExpression) {
            foreach.setExpression((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            foreach.setBody((CtStatement)this.child);
            return;
        }
        super.visitCtForEach(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        if (ifElement.getCondition() == null && this.child instanceof CtExpression) {
            ifElement.setCondition((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            if (ifElement.getThenStatement() == null) {
                ifElement.setThenStatement((CtStatement)this.child);
                return;
            }
            if (ifElement.getElseStatement() == null) {
                ifElement.setElseStatement((CtStatement)this.child);
                return;
            }
        }
        super.visitCtIf(ifElement);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.jdtTreeBuilder.context.isArgument(invocation) && this.child instanceof CtExpression) {
            invocation.addArgument((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            invocation.setTarget((CtExpression)this.child);
            return;
        }
        super.visitCtInvocation(invocation);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        if (this.jdtTreeBuilder.context.isArgument(newArray)) {
            newArray.addDimensionExpression((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            newArray.addElement((CtExpression)this.child);
            return;
        }
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        if (this.jdtTreeBuilder.context.isArgument(ctConstructorCall) && this.child instanceof CtExpression) {
            ctConstructorCall.addArgument((CtExpression)this.child);
            return;
        }
        super.visitCtConstructorCall(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        if (this.jdtTreeBuilder.context.isArgument(newClass) && this.child instanceof CtExpression) {
            newClass.addArgument((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtClass) {
            newClass.setAnonymousClass((CtClass)this.child);
            QualifiedAllocationExpression node = (QualifiedAllocationExpression)this.jdtTreeBuilder.context.stack.peek().node;
            ReferenceBinding[] referenceBindings = ((LocalTypeBinding)node.resolvedType).superInterfaces();
            if (referenceBindings != null && referenceBindings.length > 0) {
                ((CtClass)this.child).addSuperInterface(newClass.getType());
            } else {
                ((CtClass)this.child).setSuperclass(newClass.getType());
            }
            return;
        }
        super.visitCtNewClass(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        if (this.child instanceof CtParameter) {
            lambda.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock) {
            lambda.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            lambda.setExpression((CtExpression)this.child);
        }
        super.visitCtLambda(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        if (this.child instanceof CtExpression) {
            expression.setTarget((CtExpression)this.child);
        }
        super.visitCtExecutableReferenceExpression(expression);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (this.child instanceof CtType) {
            if (ctPackage.getTypes().contains(this.child)) {
                ctPackage.getTypes().remove(this.child);
            }
            ctPackage.getTypes().add((CtType)this.child);
            this.jdtTreeBuilder.context.addCreatedType((CtType)this.child);
            if (this.child.getPosition() != null && this.child.getPosition().getCompilationUnit() != null) {
                this.child.getPosition().getCompilationUnit().getDeclaredTypes().add((CtType)this.child);
            }
            return;
        }
        super.visitCtPackage(ctPackage);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        if (this.child instanceof CtExpression) {
            returnStatement.setReturnedExpression((CtExpression)this.child);
            return;
        }
        super.visitCtReturn(returnStatement);
    }

    @Override
    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        if (switchStatement.getSelector() == null && this.child instanceof CtExpression) {
            switchStatement.setSelector((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtCase) {
            switchStatement.addCase((CtCase)this.child);
            return;
        }
        super.visitCtSwitch(switchStatement);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        if (synchro.getExpression() == null && this.child instanceof CtExpression) {
            synchro.setExpression((CtExpression)this.child);
            return;
        }
        if (synchro.getBlock() == null && this.child instanceof CtBlock) {
            synchro.setBlock((CtBlock)this.child);
            return;
        }
        super.visitCtSynchronized(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        if (throwStatement.getThrownExpression() == null) {
            throwStatement.setThrownExpression((CtExpression)this.child);
            return;
        }
        super.visitCtThrow(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        if (this.child instanceof CtBlock) {
            if (!this.jdtTreeBuilder.context.finallyzer.isEmpty() && this.jdtTreeBuilder.context.finallyzer.peek() == tryBlock) {
                tryBlock.setFinalizer((CtBlock)this.child);
            } else {
                tryBlock.setBody((CtBlock)this.child);
            }
            return;
        }
        if (this.child instanceof CtCatch) {
            tryBlock.addCatcher((CtCatch)this.child);
            return;
        }
        super.visitCtTry(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        if (this.child instanceof CtBlock) {
            if (!this.jdtTreeBuilder.context.finallyzer.isEmpty() && this.jdtTreeBuilder.context.finallyzer.peek() == tryWithResource) {
                tryWithResource.setFinalizer((CtBlock)this.child);
            } else {
                tryWithResource.setBody((CtBlock)this.child);
            }
            return;
        }
        if (this.child instanceof CtLocalVariable) {
            if (tryWithResource.getResources() == null) {
                tryWithResource.setResources(new ArrayList());
            }
            tryWithResource.addResource((CtLocalVariable)this.child);
        } else if (this.child instanceof CtCatch) {
            tryWithResource.addCatcher((CtCatch)this.child);
            return;
        }
        super.visitCtTry(tryWithResource);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        if (operator.getOperand() == null && this.child instanceof CtExpression) {
            operator.setOperand((CtExpression)this.child);
            return;
        }
        super.visitCtUnaryOperator(operator);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        if (whileLoop.getLoopingExpression() == null && this.child instanceof CtExpression) {
            whileLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtWhile(whileLoop);
    }
}

