/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import spoon.Launcher;

public class SpoonObjectFieldsTable
extends JFrame {
    public static final String[] columnsName = new String[]{"Name", "FieldType", "currentType", "Value"};
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private Object o;

    public SpoonObjectFieldsTable(Object o) {
        this.o = o;
        this.initialize();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(new SpoonObjectTableModel(this.o));
        }
        return this.jTable;
    }

    private void initialize() {
        this.setSize(320, 240);
        this.setLocation((this.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth() - this.getWidth()) / 2, (this.getGraphicsConfiguration().getDevice().getDisplayMode().getHeight() - this.getHeight()) / 2);
        this.setContentPane(this.getJContentPane());
        this.setTitle(this.o.getClass().getSimpleName());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public class SpoonObjectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Field> field;
        Object o;

        public SpoonObjectTableModel(Object o) {
            this.o = o;
            this.field = new ArrayList<Field>();
            this.scanFields(o.getClass());
        }

        @Override
        public int getColumnCount() {
            return columnsName.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnsName[column];
        }

        @Override
        public int getRowCount() {
            return this.field.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Field m = this.field.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return m.getName();
                }
                case 1: {
                    return m.getType().getCanonicalName();
                }
                case 2: {
                    try {
                        Object val = m.get(this.o);
                        if (val != null) {
                            return val.getClass().getCanonicalName();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Launcher.logger.error(e.getMessage(), e);
                    }
                    catch (IllegalAccessException e) {
                        Launcher.logger.error(e.getMessage(), e);
                    }
                    break;
                }
                case 3: {
                    try {
                        return m.get(this.o);
                    }
                    catch (IllegalArgumentException e) {
                        Launcher.logger.error(e.getMessage(), e);
                        break;
                    }
                    catch (IllegalAccessException e) {
                        Launcher.logger.error(e.getMessage(), e);
                    }
                }
            }
            return null;
        }

        public void scanFields(Class<?> c) {
            for (Field f : c.getDeclaredFields()) {
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers())) continue;
                this.field.add(f);
            }
            if (c.getSuperclass() != null) {
                this.scanFields(c.getSuperclass());
            }
        }
    }
}

