/*
 * Decompiled with CFR 0.152.
 */
package phyloPMCMC;

import ev.poi.processors.TreeDistancesProcessor;
import ev.poi.processors.TreeTopologyProcessor;
import fig.basic.Pair;
import fig.exec.Execution;
import gep.util.OutputManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.io.TreeEvaluator;
import pty.mcmc.UnrootedTreeState;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.models.CTMC;
import smc.BackForwardKernel;
import smc.PartialCoalescentState4BackForwardKernel;

public class PGS4K2PBF {
    private final Dataset dataset;
    LazyParticleFilter.ParticleFilterOptions options = null;
    private final TreeDistancesProcessor tdp;
    private boolean useTopologyProcessor = false;
    private final TreeTopologyProcessor trTopo;
    private double previousLogLLEstimate = Double.NEGATIVE_INFINITY;
    private RootedTree currentSample = null;
    public static OutputManager outMan = new OutputManager();
    private int iter = 0;
    private int treeCount = 0;
    File output = new File(Execution.getFile((String)"results"));
    private String nameOfAllTrees = "allTrees-PGS4K2PBF.trees";
    private boolean saveTreesFromPMCMC = false;
    private int sampleTreeEveryNIter = 1;
    private boolean processTree = false;
    private boolean isGS4Clock = true;
    private double trans2tranv = 2.0;
    public double a = 1.25;
    private PartialCoalescentState4BackForwardKernel sampled = null;
    private boolean sampleTrans2tranv = true;
    private PartialCoalescentState4BackForwardKernel init = null;
    private CTMC ctmc = null;

    public boolean isSampleTrans2tranv() {
        return this.sampleTrans2tranv;
    }

    public void setSampleTrans2tranv(boolean sampleTrans2tranv) {
        this.sampleTrans2tranv = sampleTrans2tranv;
    }

    public PGS4K2PBF(Dataset dataset0, LazyParticleFilter.ParticleFilterOptions options, TreeDistancesProcessor tdp, boolean useTopologyProcessor, TreeTopologyProcessor trTopo, RootedTree initrt, boolean processTree, boolean isGS4Clock, int sampleTreeEveryNIter, PartialCoalescentState4BackForwardKernel init, CTMC ctmc) {
        this.dataset = dataset0;
        this.options = options;
        this.tdp = tdp;
        this.useTopologyProcessor = useTopologyProcessor;
        this.trTopo = useTopologyProcessor ? trTopo : null;
        this.currentSample = initrt;
        this.processTree = processTree;
        this.isGS4Clock = isGS4Clock;
        this.sampleTreeEveryNIter = sampleTreeEveryNIter;
        this.init = init;
        this.ctmc = ctmc;
    }

    public PGS4K2PBF(Dataset dataset0, LazyParticleFilter.ParticleFilterOptions options, TreeDistancesProcessor tdp, RootedTree initrt, TreeTopologyProcessor trTopo) {
        this.dataset = dataset0;
        this.options = options;
        this.tdp = tdp;
        this.currentSample = initrt;
        this.trTopo = trTopo;
    }

    public void setSaveTreesFromPMCMC(boolean saveTreesFromPMCMC) {
        this.saveTreesFromPMCMC = saveTreesFromPMCMC;
    }

    public void setNameOfAllTrees(String nameOfAllTrees) {
        this.nameOfAllTrees = nameOfAllTrees;
    }

    public String getNameOfAllTrees() {
        return this.nameOfAllTrees;
    }

    public boolean getSaveTreesFromPMCMC() {
        return this.saveTreesFromPMCMC;
    }

    public void setProcessTree(boolean processTree) {
        this.processTree = processTree;
    }

    public RootedTree getRootedTree() {
        return this.currentSample;
    }

    private double MHTrans2tranv(double currentTrans2tranv, Random rand) {
        Trans2tranvProposal kappaProposal = new Trans2tranvProposal(this.a, rand);
        Pair<Double, Double> proposed = kappaProposal.propose(currentTrans2tranv);
        double proposedTrans2tranv = (Double)proposed.getFirst();
        CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)this.dataset.nSites(), (double)proposedTrans2tranv);
        UnrootedTreeState ncs = UnrootedTreeState.initFastState((UnrootedTree)this.currentSample.getUnrooted(), (Dataset)this.dataset, (CTMC)ctmc);
        double logratio = ncs.logLikelihood() - this.previousLogLLEstimate + (Double)proposed.getSecond();
        double acceptPr = Math.min(1.0, Math.exp(logratio));
        boolean accept = Sampling.sampleBern((double)acceptPr, (Random)rand);
        if (accept) {
            this.trans2tranv = proposedTrans2tranv;
        }
        return acceptPr;
    }

    public void next(Random rand) {
        ++this.iter;
        RootedTree previousSample = this.currentSample;
        if (this.sampleTrans2tranv) {
            this.MHTrans2tranv(this.trans2tranv, rand);
        }
        ParticleFilter.StoreProcessor pro = new ParticleFilter.StoreProcessor();
        if (this.iter % this.sampleTreeEveryNIter == 0) {
            if (this.sampleTrans2tranv) {
                this.ctmc = CTMC.SimpleCTMC.dnaCTMC((int)this.dataset.nSites(), (double)this.trans2tranv);
                PartialCoalescentState init0 = PartialCoalescentState.initFastState((Dataset)this.dataset, (CTMC)this.ctmc, (boolean)true);
                this.init = new PartialCoalescentState4BackForwardKernel(init0, null, null, null, 0.0, new int[]{-1, -1});
            }
            BackForwardKernel kernel = new BackForwardKernel(this.init);
            ParticleFilter pf = new ParticleFilter();
            pf.nThreads = this.options.nThreads;
            pf.resampleLastRound = false;
            pf.N = this.options.nParticles;
            pf.rand = rand;
            if (this.sampled != null) {
                List<Pair<PartialCoalescentState4BackForwardKernel, Double>> restorePCS = PartialCoalescentState4BackForwardKernel.restoreSequence(this.sampled);
                ArrayList path = CollUtils.list();
                double[] weights = new double[restorePCS.size()];
                for (int i = 0; i < restorePCS.size(); ++i) {
                    path.add(restorePCS.get(i).getFirst());
                    weights[i] = (Double)restorePCS.get(i).getSecond();
                }
                pf.setConditional((List)path, weights);
            }
            pf.sample((ParticleKernel)kernel, (ParticleFilter.ParticleProcessor)pro);
            this.sampled = (PartialCoalescentState4BackForwardKernel)pro.sample(rand);
            this.currentSample = this.sampled.getCurrentState().getFullCoalescentState();
            UnrootedTreeState ncs = UnrootedTreeState.initFastState((UnrootedTree)this.currentSample.getUnrooted(), (Dataset)this.dataset, (CTMC)this.ctmc);
            this.previousLogLLEstimate = ncs.logLikelihood();
            if (this.processTree) {
                this.tdp.process(this.currentSample);
            }
            if (this.useTopologyProcessor) {
                this.trTopo.process(this.currentSample);
            }
            ++this.treeCount;
            if (this.saveTreesFromPMCMC) {
                String stringOfTree = RootedTree.Util.toNewick((RootedTree)this.currentSample);
                String cmdStr = "echo -n 'TREE gsTree_" + this.treeCount + "=' >>" + this.nameOfAllTrees;
                IO.call((String)"bash -s", (String)cmdStr, (File)this.output);
                cmdStr = "echo '" + stringOfTree + "' | sed 's/internal_[0-9]*_[0-9]*//g' | sed 's/leaf_//g' >> " + this.nameOfAllTrees;
                IO.call((String)"bash -s", (String)cmdStr, (File)this.output);
            }
        }
        int tSize = this.currentSample.topology().nLeaves();
        outMan.write("PGS4K2PBF", new Object[]{"Iter", this.iter, "treeSize", tSize, "trans2tranv", this.trans2tranv, "rfDist", previousSample == null ? 0.0 : new TreeEvaluator.RobinsonFouldsMetric().score(this.currentSample, previousSample), "LogLikelihood", this.previousLogLLEstimate});
    }

    public static class Trans2tranvProposal {
        private final double a;
        private Random rand;

        public Trans2tranvProposal(double a, Random rand) {
            if (a <= 1.0) {
                throw new RuntimeException();
            }
            this.a = a;
            this.rand = rand;
        }

        public Pair<Double, Double> propose(double currentTrans2tranv) {
            double lambda = 2.0 * Math.log(this.a);
            double rvUnif = Sampling.nextDouble((Random)this.rand, (double)0.0, (double)1.0);
            double m = Math.exp(lambda * (rvUnif - 0.5));
            double newTrans2tranv = m * currentTrans2tranv;
            return Pair.makePair((Object)newTrans2tranv, (Object)Math.log(m));
        }
    }
}

