/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class PreorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final Stack<PhylogenyNode> _stack;

    public PreorderTreeIterator(Phylogeny phylogeny) throws IllegalArgumentException {
        if (phylogeny.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PreorderTreeIterator on empty tree.");
        }
        this._stack = new Stack();
        this._tree = phylogeny;
        this.reset();
    }

    public PreorderTreeIterator(PhylogenyNode phylogenyNode) throws IllegalArgumentException {
        this._stack = new Stack();
        this._tree = null;
        this.reset(phylogenyNode);
    }

    private Stack<PhylogenyNode> getStack() {
        return this._stack;
    }

    private Phylogeny getTree() {
        return this._tree;
    }

    @Override
    public boolean hasNext() {
        return !this.getStack().isEmpty();
    }

    @Override
    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode phylogenyNode = this.getStack().pop();
        if (!phylogenyNode.isExternal()) {
            for (int i = phylogenyNode.getNumberOfDescendants() - 1; i >= 0; --i) {
                this.getStack().push(phylogenyNode.getChildNode(i));
            }
        }
        return phylogenyNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.getStack().clear();
        this.getStack().push(this.getTree().getRoot());
    }

    private void reset(PhylogenyNode phylogenyNode) {
        this.getStack().clear();
        this.getStack().push(phylogenyNode);
    }
}

