/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.protein.DomainId;
import org.forester.species.Species;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.ForesterUtil;

public class PrintableDomainSimilarity
implements DomainSimilarity {
    public static final String SPECIES_SEPARATOR = "  ";
    private static final char TAB = '\t';
    private static final int BEFORE = -1;
    private static final int EQUAL = 0;
    private static final int AFTER = 1;
    private static final String NO_SPECIES = "     ";
    private final double _min;
    private final double _max;
    private final double _mean;
    private final double _sd;
    private final int _n;
    private final int _max_difference_in_counts;
    private final int _max_difference;
    private DomainSimilarityCalculator.GoAnnotationOutput _go_annotation_output;
    private final CombinableDomains _combinable_domains;
    private final SortedMap<Species, SpeciesSpecificDomainSimilariyData> _species_data;
    private final DomainSimilarity.DomainSimilaritySortField _sort_field;
    private List<Species> _species_order;
    private final boolean _sort_by_species_count_first;
    private DomainSimilarityCalculator.Detailedness _detailedness;
    private Map<GoId, GoTerm> _go_id_to_term_map;
    private GoNameSpace _go_namespace_limit;
    private final boolean _treat_as_binary_comparison;

    public PrintableDomainSimilarity(CombinableDomains combinableDomains, double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, SortedMap<Species, SpeciesSpecificDomainSimilariyData> sortedMap, DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, boolean bl, boolean bl2) {
        if (combinableDomains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (domainSimilaritySortField == null) {
            throw new IllegalArgumentException("attempt to use null sorting");
        }
        if (sortedMap == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (sortedMap.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        if (n < 0) {
            throw new IllegalArgumentException("attempt to use N less than 0");
        }
        if (sortedMap.size() > 1 && n < 1) {
            throw new IllegalArgumentException("attempt to use N less than 1");
        }
        if (d5 < 0.0) {
            throw new IllegalArgumentException("attempt to use negative SD");
        }
        if (d2 < d) {
            throw new IllegalArgumentException("attempt to use max smaller than min");
        }
        this.init();
        this._combinable_domains = combinableDomains;
        this._min = d;
        this._max = d2;
        this._mean = d3;
        this._sd = d5;
        this._n = n;
        this._max_difference_in_counts = n2;
        this._max_difference = n3;
        this._species_data = sortedMap;
        this._sort_field = domainSimilaritySortField;
        this._sort_by_species_count_first = bl;
        this._treat_as_binary_comparison = bl2;
        int n4 = sortedMap.size();
        if (n4 * n4 - n4 != this.getN() * 2) {
            throw new IllegalArgumentException("illegal species count and n: species count:" + n4 + ", n:" + this._n + " for domain " + combinableDomains.getKeyDomain());
        }
        if (n4 > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    private void addGoInformation(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (!bl) {
            stringBuffer.append("<");
        }
        switch (this.getGoAnnotationOutput()) {
            case ALL: {
                int n = this.getCombinableDomains().getKeyDomain().getNumberOfGoIds();
                boolean bl3 = true;
                for (int i = 0; i < n; ++i) {
                    GoId goId = this.getCombinableDomains().getKeyDomain().getGoId(i);
                    if (this.getGoIdToTermMap() != null) {
                        if (this.getGoIdToTermMap().containsKey(goId)) {
                            bl3 = this.appendGoTerm(stringBuffer, this.getGoIdToTermMap().get(goId), bl3, bl2);
                            continue;
                        }
                        stringBuffer.append("go id \"" + goId + "\" not found [" + this.getCombinableDomains().getKeyDomain().getId() + "]");
                        continue;
                    }
                    if (!bl3) {
                        stringBuffer.append(", ");
                    }
                    if (bl2) {
                        stringBuffer.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + goId + "\" target=\"amigo_window\">" + goId + "</a>");
                    } else {
                        stringBuffer.append(goId);
                    }
                    bl3 = false;
                }
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("unknown " + (Object)((Object)this.getGoAnnotationOutput()));
            }
        }
        if (!bl) {
            stringBuffer.append(">: ");
        }
    }

    private void addSpeciesSpecificDomainData(StringBuffer stringBuffer, Species species, boolean bl) {
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            stringBuffer.append("[");
        }
        if (bl) {
            stringBuffer.append("<b>");
            if ("http://beta.uniprot.org/taxonomy/?query=" != null && species.getSpeciesId().length() > 2 && species.getSpeciesId().length() < 6) {
                stringBuffer.append("<a href=\"http://beta.uniprot.org/taxonomy/?query=" + species.getSpeciesId() + "\" target=\"taxonomy_window\">" + species.getSpeciesId() + "</a>");
            } else {
                stringBuffer.append(species.getSpeciesId());
            }
            stringBuffer.append("</b>");
        } else {
            stringBuffer.append(species.getSpeciesId());
        }
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            stringBuffer.append(":");
            stringBuffer.append(((SpeciesSpecificDomainSimilariyData)this.getSpeciesData().get(species)).toStringBuffer(this.getDetaildness(), bl));
            stringBuffer.append("]");
        }
        if (bl) {
            stringBuffer.append("<br>");
        }
        stringBuffer.append(SPECIES_SEPARATOR);
    }

    private boolean appendGoTerm(StringBuffer stringBuffer, GoTerm goTerm, boolean bl, boolean bl2) {
        if (this.getGoNamespaceLimit() == null || this.getGoNamespaceLimit().equals(goTerm.getGoNameSpace())) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            GoId goId = goTerm.getGoId();
            if (bl2) {
                stringBuffer.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + goId + "\" target=\"amigo_window\">" + goId + "</a>");
            } else {
                stringBuffer.append(goId);
            }
            stringBuffer.append(":");
            stringBuffer.append(goTerm.getName());
            if (!bl2) {
                if (this.getGoNamespaceLimit() == null) {
                    stringBuffer.append(":");
                    stringBuffer.append(goTerm.getGoNameSpace().toString());
                }
                for (GoXRef goXRef : goTerm.getGoXRefs()) {
                    stringBuffer.append(":");
                    stringBuffer.append(goXRef.toString());
                }
            }
            return false;
        }
        return true;
    }

    private void boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, StringBuffer stringBuffer) {
        if (this.getSortField() == domainSimilaritySortField) {
            stringBuffer.append("</b>");
        }
    }

    private void boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, StringBuffer stringBuffer) {
        if (this.getSortField() == domainSimilaritySortField) {
            stringBuffer.append("<b>");
        }
    }

    private int compareByDomainId(DomainSimilarity domainSimilarity) {
        return this.getDomainId().compareTo(domainSimilarity.getDomainId());
    }

    private int compareBySpeciesCount(DomainSimilarity domainSimilarity) {
        int n;
        int n2 = this.getSpeciesData().size();
        if (n2 < (n = domainSimilarity.getSpeciesData().size())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(DomainSimilarity domainSimilarity) {
        if (this == domainSimilarity) {
            return 0;
        }
        if (domainSimilarity == null) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to null");
        }
        if (domainSimilarity.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to " + domainSimilarity.getClass());
        }
        switch (this.getSortField()) {
            case MIN: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getMinimalSimilarityScore() < domainSimilarity.getMinimalSimilarityScore()) {
                    return -1;
                }
                if (this.getMinimalSimilarityScore() > domainSimilarity.getMinimalSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case MAX: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getMaximalSimilarityScore() < domainSimilarity.getMaximalSimilarityScore()) {
                    return -1;
                }
                if (this.getMaximalSimilarityScore() > domainSimilarity.getMaximalSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case MEAN: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getMeanSimilarityScore() < domainSimilarity.getMeanSimilarityScore()) {
                    return -1;
                }
                if (this.getMeanSimilarityScore() > domainSimilarity.getMeanSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case SD: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getStandardDeviationOfSimilarityScore() < domainSimilarity.getStandardDeviationOfSimilarityScore()) {
                    return -1;
                }
                if (this.getStandardDeviationOfSimilarityScore() > domainSimilarity.getStandardDeviationOfSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case MAX_DIFFERENCE: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getMaximalDifference() > domainSimilarity.getMaximalDifference()) {
                    return -1;
                }
                if (this.getMaximalDifference() < domainSimilarity.getMaximalDifference()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                int n;
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (Math.abs(this.getMaximalDifferenceInCounts()) > Math.abs(domainSimilarity.getMaximalDifferenceInCounts())) {
                    return -1;
                }
                if (Math.abs(this.getMaximalDifferenceInCounts()) < Math.abs(domainSimilarity.getMaximalDifferenceInCounts())) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case MAX_COUNTS_DIFFERENCE: {
                int n;
                if (this.getSpeciesData().size() != 2) {
                    throw new RuntimeException("attempt to sort by maximal difference with species not equal to two");
                }
                if (this.isSortBySpeciesCountFirst() && (n = this.compareBySpeciesCount(domainSimilarity)) != 0) {
                    return n;
                }
                if (this.getMaximalDifferenceInCounts() > domainSimilarity.getMaximalDifferenceInCounts()) {
                    return -1;
                }
                if (this.getMaximalDifferenceInCounts() < domainSimilarity.getMaximalDifferenceInCounts()) {
                    return 1;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case SPECIES_COUNT: {
                int n = this.compareBySpeciesCount(domainSimilarity);
                if (n != 0) {
                    return n;
                }
                return this.compareByDomainId(domainSimilarity);
            }
            case DOMAIN_ID: {
                return this.compareByDomainId(domainSimilarity);
            }
        }
        throw new AssertionError((Object)("Unknown sort method: " + (Object)((Object)this.getSortField())));
    }

    @Override
    public SortedSet<DomainId> getCombinableDomainIds(Species species) {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        if (this.getSpeciesData().containsKey(species)) {
            for (DomainId domainId : ((SpeciesSpecificDomainSimilariyData)this.getSpeciesData().get(species)).getCombinableDomainIdToCountsMap().keySet()) {
                treeSet.add(domainId);
            }
        }
        return treeSet;
    }

    private CombinableDomains getCombinableDomains() {
        return this._combinable_domains;
    }

    private DomainSimilarityCalculator.Detailedness getDetaildness() {
        return this._detailedness;
    }

    @Override
    public DomainId getDomainId() {
        return this.getCombinableDomains().getKeyDomain();
    }

    private DomainSimilarityCalculator.GoAnnotationOutput getGoAnnotationOutput() {
        return this._go_annotation_output;
    }

    private Map<GoId, GoTerm> getGoIdToTermMap() {
        return this._go_id_to_term_map;
    }

    public GoNameSpace getGoNamespaceLimit() {
        return this._go_namespace_limit;
    }

    @Override
    public int getMaximalDifference() {
        return this._max_difference;
    }

    @Override
    public int getMaximalDifferenceInCounts() {
        return this._max_difference_in_counts;
    }

    @Override
    public double getMaximalSimilarityScore() {
        return this._max;
    }

    @Override
    public double getMeanSimilarityScore() {
        return this._mean;
    }

    @Override
    public double getMinimalSimilarityScore() {
        return this._min;
    }

    @Override
    public int getN() {
        return this._n;
    }

    private DomainSimilarity.DomainSimilaritySortField getSortField() {
        return this._sort_field;
    }

    @Override
    public SortedSet<Species> getSpecies() {
        TreeSet<Species> treeSet = new TreeSet<Species>();
        for (Species species : this.getSpeciesData().keySet()) {
            treeSet.add(species);
        }
        return treeSet;
    }

    public List<Species> getSpeciesCustomOrder() {
        return this._species_order;
    }

    @Override
    public SortedMap<Species, SpeciesSpecificDomainSimilariyData> getSpeciesData() {
        return this._species_data;
    }

    private StringBuffer getSpeciesDataInAlphabeticalOrder(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Species species : this.getSpeciesData().keySet()) {
            this.addSpeciesSpecificDomainData(stringBuffer, species, bl);
        }
        return stringBuffer;
    }

    private StringBuffer getSpeciesDataInCustomOrder(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Species species : this.getSpeciesCustomOrder()) {
            if (this.getSpeciesData().keySet().contains(species)) {
                this.addSpeciesSpecificDomainData(stringBuffer, species, bl);
                continue;
            }
            stringBuffer.append(NO_SPECIES);
            stringBuffer.append(SPECIES_SEPARATOR);
        }
        return stringBuffer;
    }

    @Override
    public double getStandardDeviationOfSimilarityScore() {
        return this._sd;
    }

    private void init() {
        this._detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
        this._go_annotation_output = null;
        this._go_id_to_term_map = null;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    public void setDetailedness(DomainSimilarityCalculator.Detailedness detailedness) {
        this._detailedness = detailedness;
    }

    public void setGoAnnotationOutput(DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput) {
        this._go_annotation_output = goAnnotationOutput;
    }

    public void setGoIdToTermMap(Map<GoId, GoTerm> map) {
        this._go_id_to_term_map = map;
    }

    public void setGoNamespaceLimit(GoNameSpace goNameSpace) {
        this._go_namespace_limit = goNameSpace;
    }

    public void setSpeciesOrder(List<Species> list) {
        if (!list.containsAll(this.getSpeciesData().keySet())) {
            throw new IllegalArgumentException("list to order species must contain all species of multiple combinable domains similarity");
        }
        this._species_order = list;
    }

    public String toString() {
        return this.toStringBuffer(null).toString();
    }

    @Override
    public StringBuffer toStringBuffer(PRINT_OPTION pRINT_OPTION) {
        switch (pRINT_OPTION) {
            case SIMPLE_TAB_DELIMITED: {
                return this.toStringBufferSimpleTabDelimited();
            }
            case HTML: {
                return this.toStringBufferDetailedHTML();
            }
        }
        throw new AssertionError((Object)("Unknown print option: " + (Object)((Object)pRINT_OPTION)));
    }

    private StringBuffer toStringBufferDetailedHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, stringBuffer);
        stringBuffer.append("<a href=\"http://pfam.sanger.ac.uk/family?id=" + this.getDomainId() + "\">" + this.getDomainId() + "</a>");
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, stringBuffer);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MEAN, stringBuffer);
        stringBuffer.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MEAN, stringBuffer);
        stringBuffer.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            stringBuffer.append("<td>");
            stringBuffer.append("(");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.SD, stringBuffer);
            stringBuffer.append(ForesterUtil.round(this.getStandardDeviationOfSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.SD, stringBuffer);
            stringBuffer.append(")");
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append("[");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MIN, stringBuffer);
            stringBuffer.append(ForesterUtil.round(this.getMinimalSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MIN, stringBuffer);
            stringBuffer.append(",");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX, stringBuffer);
            stringBuffer.append(ForesterUtil.round(this.getMaximalSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX, stringBuffer);
            stringBuffer.append("]");
            stringBuffer.append("</td>");
        }
        stringBuffer.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE, stringBuffer);
        stringBuffer.append(this.getMaximalDifference());
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE, stringBuffer);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.isTreatAsBinaryComparison()) {
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, stringBuffer);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, stringBuffer);
            stringBuffer.append(this.getMaximalDifferenceInCounts());
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, stringBuffer);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, stringBuffer);
        } else {
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, stringBuffer);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, stringBuffer);
            stringBuffer.append(Math.abs(this.getMaximalDifferenceInCounts()));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, stringBuffer);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, stringBuffer);
        }
        stringBuffer.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            stringBuffer.append("<td>");
            if (this.getSortField() == DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT || this.isSortBySpeciesCountFirst()) {
                stringBuffer.append("<b>");
            }
            stringBuffer.append(this.getSpeciesData().size());
            if (this.getSortField() == DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT || this.isSortBySpeciesCountFirst()) {
                stringBuffer.append("</b>");
            }
            stringBuffer.append("</td>");
        }
        if (this.getGoAnnotationOutput() != DomainSimilarityCalculator.GoAnnotationOutput.NONE) {
            stringBuffer.append("<td>");
            this.addGoInformation(stringBuffer, true, true);
            stringBuffer.append("</td>");
        }
        if (this.getSpeciesCustomOrder() == null || this.getSpeciesCustomOrder().isEmpty()) {
            stringBuffer.append("<td>");
            stringBuffer.append(this.getSpeciesDataInAlphabeticalOrder(true));
            stringBuffer.append("</td>");
        } else {
            stringBuffer.append("<td>");
            stringBuffer.append(this.getSpeciesDataInCustomOrder(true));
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</tr>");
        return stringBuffer;
    }

    private StringBuffer toStringBufferSimpleTabDelimited() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDomainId());
        switch (this.getSortField()) {
            case MIN: {
                stringBuffer.append('\t');
                stringBuffer.append(ForesterUtil.round(this.getMinimalSimilarityScore(), 3));
                break;
            }
            case MAX: {
                stringBuffer.append('\t');
                stringBuffer.append(ForesterUtil.round(this.getMaximalSimilarityScore(), 3));
                break;
            }
            case MEAN: {
                stringBuffer.append('\t');
                stringBuffer.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
                break;
            }
            case SD: {
                stringBuffer.append('\t');
                stringBuffer.append(ForesterUtil.round(this.getStandardDeviationOfSimilarityScore(), 3));
                break;
            }
            case MAX_DIFFERENCE: {
                stringBuffer.append('\t');
                stringBuffer.append(this.getMaximalDifference());
            }
            case ABS_MAX_COUNTS_DIFFERENCE: 
            case MAX_COUNTS_DIFFERENCE: {
                stringBuffer.append('\t');
                if (this.isTreatAsBinaryComparison()) {
                    stringBuffer.append(this.getMaximalDifferenceInCounts());
                    break;
                }
                stringBuffer.append(Math.abs(this.getMaximalDifferenceInCounts()));
                break;
            }
            case SPECIES_COUNT: {
                stringBuffer.append('\t');
                stringBuffer.append(this.getSpeciesData().size());
                break;
            }
            case DOMAIN_ID: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown sort method: " + (Object)((Object)this.getSortField())));
            }
        }
        if (this.getGoAnnotationOutput() != DomainSimilarityCalculator.GoAnnotationOutput.NONE) {
            stringBuffer.append('\t');
            this.addGoInformation(stringBuffer, true, false);
        }
        return stringBuffer;
    }

    public static enum PRINT_OPTION {
        SIMPLE_TAB_DELIMITED,
        HTML;

    }
}

