/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.PhyloCognateInference;
import goblin.Taxon;

public class CognateData {
    private String sequence;
    private Taxon taxon;
    private double[][] likelihood;

    public CognateData(String sequence, Taxon taxon) {
        this.sequence = sequence;
        this.taxon = taxon;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public String getSequence() {
        return this.sequence;
    }

    public double[] getLikelihood(int pos) {
        if (this.likelihood == null) {
            int B = PhyloCognateInference.phonemeIndexer.size();
            int P = this.sequence.length();
            this.likelihood = new double[P][B];
            for (int b = 0; b < P; ++b) {
                int index = PhyloCognateInference.phonemeIndexer.getIndex(Character.valueOf(this.sequence.charAt(b)));
                this.likelihood[b][index] = 1.0;
            }
        }
        return this.likelihood[pos];
    }
}

