/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateTree;
import cognates.CognateTreeNode;
import java.util.List;
import nuts.math.TabularGMFct;
import nuts.math.TreeSumProd;
import nuts.util.CollUtils;

public class CognateTable {
    private String gloss;
    private List<CognateTreeNode> customers = CollUtils.list();
    private List<TabularGMFct<CognateTreeNode>> fcts;
    private double logLik = 0.0;

    public CognateTable(CognateTreeNode customer, String gloss, CognateTree tree) {
        this.gloss = gloss;
        this.customers.add(customer);
        this.fcts = CollUtils.list();
        this.getFctHelper(customer, tree);
    }

    private void getFctHelper(CognateTreeNode customer, CognateTree tree) {
        String sequence = customer.getData(this.gloss);
        for (int i = 0; i < sequence.length(); ++i) {
            TabularGMFct<CognateTreeNode> fct = tree.getDefaultGMFct();
            double[] lik = customer.getLikelihood(this.gloss, i);
            for (int s = 0; s < lik.length; ++s) {
                fct.set(customer, s, lik[s]);
            }
            TreeSumProd<CognateTreeNode> tsp = new TreeSumProd<CognateTreeNode>(fct);
            this.logLik += tsp.logZ();
            this.fcts.add(fct);
        }
    }

    public CognateTable(CognateTable oldTable) {
        for (CognateTreeNode customer : oldTable.customers) {
            this.customers.add(customer);
        }
        this.fcts = oldTable.fcts;
        this.gloss = oldTable.gloss;
        this.logLik = 0.0;
    }

    public CognateTable seat(CognateTreeNode customer) {
        CognateTable newTable = new CognateTable(this);
        newTable.customers.add(customer);
        String seq = customer.getData(this.gloss);
        for (int i = 0; i < seq.length(); ++i) {
            TabularGMFct<CognateTreeNode> fct = newTable.fcts.get(i);
            double[] lik = customer.getLikelihood(newTable.gloss, i);
            for (int s = 0; s < lik.length; ++s) {
                fct.set(customer, s, lik[s]);
            }
            TreeSumProd<CognateTreeNode> tsp = new TreeSumProd<CognateTreeNode>(fct);
            newTable.logLik += tsp.logZ();
        }
        return newTable;
    }

    public double getLogLik() {
        if (this.logLik == 0.0) {
            throw new RuntimeException();
        }
        return this.logLik;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.customers.size() + ", " + this.gloss + ", " + this.logLik + ", ( ");
        for (CognateTreeNode node : this.customers) {
            sb.append(node.getTaxon() + " ");
        }
        sb.append(")]");
        return sb.toString();
    }
}

