/*
 * Decompiled with CFR 0.152.
 */
package conifer.exp;

import conifer.data.PhylogeneticData;
import conifer.exp.Experiment;
import conifer.exp.ExperimentOptions;
import conifer.exp.ExperimentsUtils;
import conifer.exp.PrepareExperimentsContext;
import conifer.msa.TreeMSAState;
import conifer.particle.PhyloParticle;
import fig.basic.IOUtils;
import fig.basic.StrUtils;
import gep.util.OutputManager;
import goblin.Taxon;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.Map;
import ma.GreedyDecoder;
import ma.MSAEvaluator;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.io.OutputProducer;
import nuts.math.Evaluator;
import nuts.util.Counter;
import pty.smc.ParticleFilter;

public class MSAInferenceExperiment
implements Experiment,
OutputProducer {
    private final PhylogeneticData originalData;
    private final OutputManager manager = new OutputManager();
    private final MSAProcessor msaProcessor;
    private final PrepareExperimentsContext experimentContext;
    private final ExperimentOptions options;

    public MSAInferenceExperiment(PhylogeneticData data, ExperimentOptions options, PrepareExperimentsContext context) {
        this.originalData = data;
        this.experimentContext = context;
        this.options = options;
        this.msaProcessor = new MSAProcessor(data.getMsa().sequences());
    }

    @Override
    public PhylogeneticData getDataAfterHoldingOut() {
        return this.originalData.holdoutMSA();
    }

    @Override
    public void monitor(Object ... _algorithmContext) {
        Object[] currentContext = ExperimentsUtils.concat(_algorithmContext, this.experimentContext.getContext());
        if (this.options.useMaxRecallMSAReconstruction) {
            this.monitorReconstruction("maxRecallMSA", this.msaProcessor.getMaxRecallConsensus(), Double.NaN, currentContext);
        }
        if (this.options.useLikelihoodMode) {
            this.monitorReconstruction("likelihoodMode-msa", this.msaProcessor.getMode(), this.msaProcessor.bestLogLikelihood, currentContext);
        }
        if (this.options.saveModeParticle) {
            this.saveParticle("modeParticles", this.msaProcessor.getMode(), currentContext);
        }
    }

    public void saveParticle(String string, MSAPoset mode, Object[] context) {
        File mainSavedParticlesDir = new File(this.manager.getOutputFolder(), "savedParticles-msa");
        mainSavedParticlesDir.mkdir();
        File subDir = new File(mainSavedParticlesDir, string);
        subDir.mkdir();
        File name = new File(subDir, IO.cleanFileName(StrUtils.join(context)));
        ObjectOutputStream out = IOUtils.openBinOutEasy(name);
        try {
            out.writeObject(mode);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void monitorReconstruction(String methodName, MSAPoset consensus, double ll, Object[] currentContext) {
        MSAPoset original = this.originalData.getMsa();
        for (Evaluator.EvaluationScorer<MSAPoset> scorer : MSAEvaluator.msaEvaluationScorers) {
            double value = scorer.score(original, consensus);
            String name = scorer.toString();
            this.manager.write("msaMetrics", ExperimentsUtils.concat(currentContext, "reconstruction-method", methodName, "metric", name, "value", value, "loglikelihood", Double.isNaN(ll) ? "" : Double.valueOf(ll)));
        }
    }

    @Override
    public ParticleFilter.ParticleProcessor<PhyloParticle> getProcessor() {
        return this.msaProcessor;
    }

    @Override
    public void setOutputFolder(File f) {
        this.manager.setOutputFolder(f);
    }

    @Override
    public String name() {
        return "msa-reconstructions";
    }

    public static class MSAProcessor
    implements ParticleFilter.ParticleProcessor<PhyloParticle> {
        private final Counter<GreedyDecoder.Edge> edgeCounts = new Counter();
        private double denom = 0.0;
        private double bestLogLikelihood = Double.NEGATIVE_INFINITY;
        private final Map<Taxon, String> sequences;
        private MSAPoset best = null;

        public MSAProcessor(Map<Taxon, String> sequences) {
            this.sequences = sequences;
        }

        @Override
        public void process(PhyloParticle _state, double weight) {
            TreeMSAState state = (TreeMSAState)_state;
            this.edgeCounts.incrementAll(state.msa.edges(), 1.0);
            this.denom += 1.0;
            double currentLogLL = state.getLogLikelihood();
            if (currentLogLL > this.bestLogLikelihood) {
                this.best = new MSAPoset(state.msa);
                this.bestLogLikelihood = currentLogLL;
            }
        }

        public Counter<GreedyDecoder.Edge> getPosteriorEdgeProbabilities() {
            Counter<GreedyDecoder.Edge> result = new Counter<GreedyDecoder.Edge>(this.edgeCounts);
            for (GreedyDecoder.Edge key : result.keySet()) {
                result.setCount(key, result.getCount(key) / this.denom);
            }
            return result;
        }

        public MSAPoset getMode() {
            return this.best;
        }

        public MSAPoset getMaxRecallConsensus() {
            return MSAPoset.maxRecallMSA(this.sequences, this.edgeCounts);
        }
    }
}

