/*
 * Decompiled with CFR 0.152.
 */
package conifer.fastpf;

import fig.prob.Gaussian;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.MathUtils;

public class FastBranchEstimate {
    public static final double min = 0.01;
    public static final double max = 0.74;
    public static final double minF = FastBranchEstimate.JC(0.01);
    public static final double maxF = FastBranchEstimate.JC(0.74);
    public static final double b = 0.75;

    public static double fastBranchEstimateSample(double fractionThatDiffers, double variance, Random rand) {
        double logMean = Math.log(FastBranchEstimate.TJC(fractionThatDiffers));
        double logPoint = Gaussian.sample(rand, logMean, variance);
        return Math.exp(logPoint);
    }

    public static double fastBranchEstimateLogDensity(double fractionThatDiffers, double variance, double point) {
        double logMean = Math.log(FastBranchEstimate.TJC(fractionThatDiffers));
        double logPoint = Math.log(point);
        double normalLogDensity = Gaussian.logProb(logMean, variance, logPoint);
        return normalLogDensity - logPoint;
    }

    public static double fractionThatDiffers(double[][] c0, double[][] c1) {
        int nSites = c0.length;
        int nChars = c0[0].length;
        if (c0.length != c1.length) {
            throw new RuntimeException();
        }
        double expectedNMismatches = 0.0;
        for (int i = 0; i < nSites; ++i) {
            double check0 = 0.0;
            double check1 = 0.0;
            double expectedMatch = 0.0;
            double[] cur0 = c0[i];
            double[] cur1 = c1[i];
            for (int x = 0; x < nChars; ++x) {
                double v0 = cur0[x];
                double v1 = cur1[x];
                check0 += v0;
                check1 += v1;
                expectedMatch += v0 * v1;
            }
            if (!MathUtils.close(1.0, check0) || !MathUtils.close(1.0, check1)) {
                throw new RuntimeException();
            }
            expectedNMismatches += 1.0 - expectedMatch;
        }
        return expectedNMismatches / (double)nSites;
    }

    public static double TJC(double fractionThatDiffers) {
        if (fractionThatDiffers <= 0.01) {
            return minF;
        }
        if (fractionThatDiffers >= 0.74) {
            return maxF;
        }
        return FastBranchEstimate.JC(fractionThatDiffers);
    }

    public static double JC(double fractionThatDiffers) {
        return -0.75 * Math.log(1.0 - fractionThatDiffers / 0.75);
    }

    public static void main(String[] args) {
        Random rand = new Random(1L);
        double num = 0.0;
        double denom = 0.0;
        double frac = 0.3;
        double var = 1.0;
        for (int i = 0; i < 100000; ++i) {
            double sample = Sampling.sampleExponential(rand, 1.0);
            num += Math.exp(FastBranchEstimate.fastBranchEstimateLogDensity(frac, var, sample) - Sampling.exponentialLogDensity(1.0, sample));
            denom += 1.0;
        }
        System.out.println(num / denom);
    }
}

