/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.GammaFunction;

public class ErrorFunction {
    public static double erf(double x) {
        if (x > 0.0) {
            return GammaFunction.incompleteGammaP(0.5, x * x);
        }
        if (x < 0.0) {
            return -GammaFunction.incompleteGammaP(0.5, x * x);
        }
        return 0.0;
    }

    public static double erfc(double x) {
        return 1.0 - ErrorFunction.erf(x);
    }

    public static double inverseErf(double z) {
        return ErrorFunction.pointNormal(0.5 * z + 0.5) / Math.sqrt(2.0);
    }

    private static double pointNormal(double prob) {
        double p1;
        double a0 = -0.322232431088;
        double a1 = -1.0;
        double a2 = -0.342242088547;
        double a3 = -0.0204231210245;
        double a4 = -4.53642210148E-5;
        double b0 = 0.099348462606;
        double b1 = 0.588581570495;
        double b2 = 0.531103462366;
        double b3 = 0.10353775285;
        double b4 = 0.0038560700634;
        double z = 0.0;
        double p = prob;
        double d = p1 = p < 0.5 ? p : 1.0 - p;
        if (p1 < 1.0E-20) {
            new IllegalArgumentException("Argument prob out of range");
        }
        double y = Math.sqrt(Math.log(1.0 / (p1 * p1)));
        z = y + ((((y * a4 + a3) * y + a2) * y + a1) * y + a0) / ((((y * b4 + b3) * y + b2) * y + b1) * y + b0);
        return p < 0.5 ? -z : z;
    }
}

