/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import cern.jet.math.Bessel;

public class ModifiedBesselFirstKind {
    public static final int ACC = 40;
    public static final double BIGNO = 1.0E10;
    public static final double BIGNI = 1.0E-10;

    public static double bessi(double x, int n) {
        if (n == 0) {
            return Bessel.i0((double)x);
        }
        if (n == 1) {
            return Bessel.i1((double)x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        double tox = 2.0 / Math.abs(x);
        double ans = 0.0;
        double bip = 0.0;
        double bi = 1.0;
        for (int j = 2 * (n + (int)Math.sqrt(40 * n)); j > 0; --j) {
            double bim = bip + (double)j * tox * bi;
            bip = bi;
            bi = bim;
            if (Math.abs(bi) > 1.0E10) {
                ans *= 1.0E-10;
                bi *= 1.0E-10;
                bip *= 1.0E-10;
            }
            if (j != n) continue;
            ans = bip;
        }
        return x < 0.0 && (n & 1) != 0 ? -ans : (ans *= Bessel.i0((double)x) / bi);
    }
}

