/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class ExponentialDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return ExponentialDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    double lambda;

    public ExponentialDistribution(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double pdf(double x) {
        return ExponentialDistribution.pdf(x, this.lambda);
    }

    @Override
    public double logPdf(double x) {
        return ExponentialDistribution.logPdf(x, this.lambda);
    }

    @Override
    public double cdf(double x) {
        return ExponentialDistribution.cdf(x, this.lambda);
    }

    @Override
    public double quantile(double y) {
        return ExponentialDistribution.quantile(y, this.lambda);
    }

    @Override
    public double mean() {
        return ExponentialDistribution.mean(this.lambda);
    }

    @Override
    public double variance() {
        return ExponentialDistribution.variance(this.lambda);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double lambda) {
        return lambda * Math.exp(-lambda * x);
    }

    public static double logPdf(double x, double lambda) {
        return Math.log(lambda) - lambda * x;
    }

    public static double cdf(double x, double lambda) {
        return 1.0 - Math.exp(-lambda * x);
    }

    public static double quantile(double y, double lambda) {
        return -(1.0 / lambda) * Math.log(1.0 - y);
    }

    public static double mean(double lambda) {
        return 1.0 / lambda;
    }

    public static double variance(double lambda) {
        return 1.0 / (lambda * lambda);
    }
}

