/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

public class FrequencyDistribution {
    private double binSize;
    private double start = 0.0;
    private double smaller;
    private double larger;
    private int[] bins;

    public FrequencyDistribution(double start, int numBins, double binSize) {
        this.init(start, numBins, binSize);
    }

    public FrequencyDistribution(int numBins, double binSize) {
        this.init(0.0, numBins, binSize);
    }

    public FrequencyDistribution(double[] stats, int numBins, double binSize) {
        this.init(0.0, numBins, binSize);
        for (double stat : stats) {
            this.addValue(stat);
        }
    }

    public int getBinCount() {
        return this.bins.length;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public double getLowerBound() {
        return this.start;
    }

    public int getFrequency(int bin) {
        return this.bins[bin];
    }

    public double getProb(int bin) {
        int total = 0;
        for (int b : this.bins) {
            total += b;
        }
        if (total == 0) {
            return 0.0;
        }
        return (double)this.bins[bin] / (double)total;
    }

    public void addValue(double value) {
        double diff = value - this.start;
        int index = (int)(diff / this.binSize);
        if (index < 0) {
            this.smaller += 1.0;
        } else if (index >= this.bins.length) {
            this.larger += 1.0;
        } else {
            int n = index;
            this.bins[n] = this.bins[n] + 1;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("< ").append(this.start).append("\t").append(this.smaller).append("\n");
        for (int i = 0; i < this.bins.length; ++i) {
            double mean = this.start + this.binSize * ((double)i + 0.5);
            buffer.append(mean).append("\t").append(this.bins[i]).append("\n");
        }
        double end = this.start + this.binSize * (double)this.bins.length;
        buffer.append(">= ").append(end).append("\t").append(this.larger).append("\n");
        return new String(buffer);
    }

    private void init(double start, int numBins, double binSize) {
        this.bins = new int[numBins];
        this.binSize = binSize;
        this.smaller = 0.0;
        this.larger = 0.0;
        this.start = start;
    }
}

