/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

public class Timer {
    private long start = 0L;
    private long stop = 0L;

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
    }

    public void update() {
        this.stop = System.currentTimeMillis();
    }

    public long calibrate(double fraction) {
        long timeTaken = System.currentTimeMillis() - this.start;
        return Math.round((double)timeTaken / fraction * (1.0 - fraction));
    }

    public double toSeconds() {
        this.update();
        return Timer.toSeconds(this.stop - this.start);
    }

    public static double toSeconds(long millis) {
        return (double)millis / 1000.0;
    }

    public static double toMinutes(long millis) {
        return Timer.toSeconds(millis) / 60.0;
    }

    public static double toHours(long millis) {
        return Timer.toMinutes(millis) / 60.0;
    }

    public static double toDays(long millis) {
        return Timer.toHours(millis) / 24.0;
    }

    public String toString() {
        this.update();
        return Timer.toString(this.stop - this.start);
    }

    public static String toString(long millis) {
        if (Timer.toDays(millis) > 1.0) {
            return Timer.toDays(millis) + " days";
        }
        if (Timer.toHours(millis) > 1.0) {
            return Timer.toHours(millis) + " hours";
        }
        if (Timer.toMinutes(millis) > 1.0) {
            return Timer.toMinutes(millis) + " minutes";
        }
        return Timer.toSeconds(millis) + " seconds";
    }
}

