/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.EMCNode;
import emc.EMCParticle;
import emc.EntangledStatistics;
import emc.Genealogy;
import emc.SimulateEMC;
import emc.StochasticMaps;
import emc.Timer;
import emc.TransferExperiment;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class LocalGenealogy<S>
implements Genealogy<S> {
    private List<EMCParticle<S>> genealogy = CollUtils.list();
    private ParticleKernel<S> kernel;
    private StochasticMaps maps;
    private int K;
    private int max;
    private int nodeId;
    private boolean transferExperiment;
    private ParticleFilter.ParticleProcessor<S> processor;
    public TransferExperiment<S> te;
    public Timer reconstructionTimer;
    public int numReconstructed = 0;

    public LocalGenealogy(int nodeId, int K, int max, ParticleKernel<S> kernel, StochasticMaps maps, boolean transferExperiment, ParticleFilter.ParticleProcessor<S> processor) {
        this.K = K;
        this.max = max;
        this.nodeId = nodeId;
        this.kernel = kernel;
        this.maps = maps;
        this.processor = processor;
        this.transferExperiment = transferExperiment;
        if (transferExperiment) {
            this.te = new TransferExperiment();
        }
        this.init();
    }

    private void init() {
        EMCParticle<S> root = new EMCParticle<S>(this.nodeId, -1L, 0L, this.K, this.max);
        root.setSample(this.kernel.getInitial(), 0.0);
        for (int k = 0; k < this.max; ++k) {
            EMCParticle<S> particle = new EMCParticle<S>(this.nodeId, 0L, k, this.K, this.max);
            particle.setParent(root);
            this.genealogy.add(k, particle);
        }
    }

    @Override
    public List<Double> generateSamples(long r) {
        EMCNode.Loginfo("Generating samples..");
        ArrayList<Double> weights = CollUtils.list();
        this.reconstructionTimer = new Timer(true);
        this.numReconstructed = 0;
        for (EMCParticle particle : this.genealogy) {
            long id = particle.getId();
            Pair<S, Double> pair = this.kernel.next(new Random(this.maps.getSamplingSeed(id)), particle.getSample() == null ? this.reconstruct(particle.getParent()) : particle.getSample());
            particle.setSample(pair.getFirst(), (double)pair.getSecond());
            particle.setParent(null);
            weights.add(pair.getSecond());
        }
        EMCNode.Loginfo("The last particle ID=" + this.genealogy.get(this.genealogy.size() - 1).getId());
        EMCNode.Loginfo("This node generated samples for " + weights.size() + " particles.");
        EMCNode.Loginfo("This node reconstructed " + this.numReconstructed + " times.");
        return weights;
    }

    @Override
    public S reconstruct(EMCParticle<S> p) {
        ++this.numReconstructed;
        this.reconstructionTimer.begin();
        Stack<Long> seeds = new Stack<Long>();
        Object sample = null;
        for (EMCParticle<S> parent = p; parent != null; parent = parent.getParent()) {
            if (parent.getSample() != null) {
                sample = parent.getSample();
                break;
            }
            seeds.push(parent.getSeed());
        }
        if (sample == null) {
            throw new RuntimeException();
        }
        Pair<Object, Double> pair = null;
        double w = 0.0;
        int T = 0;
        while (!seeds.empty()) {
            pair = this.kernel.next(new Random((Long)seeds.pop()), sample);
            sample = pair.getFirst();
            w = pair.getSecond();
            ++T;
        }
        if (this.transferExperiment) {
            EMCNode.Loginfo("measure particle size.");
            this.te.measureSize(sample);
        }
        this.reconstructionTimer.pause();
        if (T > 0) {
            EntangledStatistics.getEntangledStatistics().setCoalescentStat(p.getGeneration() + 1L, T);
            EntangledStatistics.getEntangledStatistics().addReconstructionStat(T);
        }
        return sample;
    }

    @Override
    public int getCapacity() {
        return this.max - this.genealogy.size();
    }

    @Override
    public List<EMCParticle<S>> resample(long r, Random resampler, List<Double> weights, double localSum, int n) {
        EMCNode.Loginfo("Begin resampling... This node resamples " + n + " items.");
        if (n == 0) {
            this.genealogy.clear();
            EMCNode.Loginfo("genealogy size=" + this.genealogy.size());
            return CollUtils.list();
        }
        EMCNode.Loginfo("localSum=" + localSum);
        ArrayList<Double> ww = CollUtils.list();
        for (int i = 0; i < weights.size(); ++i) {
            ww.add(new Double(weights.get(i) / localSum));
        }
        Counter<Integer> counts = Sampling.efficientMultinomialSampling(resampler, ww, n);
        if (SimulateEMC.scheme == SimulateEMC.Allocation.Chaos) {
            ArrayList<EMCParticle<S>> resampledParticles = CollUtils.list();
            for (Integer id : counts) {
                int numResampled = (int)counts.getCount(id);
                for (int j = 0; j < numResampled; ++j) {
                    resampledParticles.add(this.genealogy.get(id));
                }
            }
            this.genealogy.clear();
            if (n != resampledParticles.size()) {
                throw new RuntimeException();
            }
            return resampledParticles;
        }
        ArrayList<EMCParticle> resampledParticles = CollUtils.list();
        for (Integer id : counts) {
            int numResampled = (int)counts.getCount(id);
            if (numResampled <= 0) continue;
            EMCParticle<S> particle = this.genealogy.get(id);
            for (int j = 0; j < numResampled; ++j) {
                resampledParticles.add(particle);
            }
        }
        this.genealogy.clear();
        ArrayList<EMCParticle<S>> rejectedParticles = CollUtils.list();
        int index = 0;
        for (int rejectionCount = Math.max(n - this.max, 0); rejectionCount > 0; --rejectionCount) {
            index = resampler.nextInt(resampledParticles.size());
            rejectedParticles.add((EMCParticle<S>)resampledParticles.remove(index));
        }
        for (EMCParticle particle : resampledParticles) {
            this.allocate(particle, r);
        }
        return rejectedParticles;
    }

    @Override
    public void allocate(List<EMCParticle<S>> rejected, long r) {
        EMCNode.Loginfo(this.nodeId + " attempt to allocate rejected particles");
        if (this.genealogy.size() >= this.max) {
            EMCNode.Loginfo("this node reached the capacity: " + this.genealogy.size());
            return;
        }
        EMCNode.Loginfo("Room=" + (this.max - this.genealogy.size()));
        while (rejected.size() > 0 && this.max - this.genealogy.size() > 0) {
            int numResampled;
            EMCParticle<S> p = rejected.remove(rejected.size() - 1);
            EMCNode.Loginfo(p.getId() + " resampled=" + numResampled);
            for (numResampled = p.getNumResampled(); this.genealogy.size() < this.max && numResampled > 0; --numResampled) {
                EMCParticle<S> newParticle = new EMCParticle<S>(this.nodeId, r + 1L, this.genealogy.size(), this.K, this.max);
                newParticle.setParent(p);
                this.genealogy.add(newParticle);
            }
            if (numResampled <= 0) continue;
            p.setNumResampled(numResampled);
            rejected.add(p);
        }
    }

    @Override
    public boolean allocate(EMCParticle<S> particle, long r) {
        if (this.max - this.genealogy.size() <= 0) {
            return false;
        }
        EMCParticle<S> newParticle = new EMCParticle<S>(this.nodeId, r + 1L, this.genealogy.size(), this.K, this.max);
        if (particle.getSample() != null) {
            newParticle.setSample(particle.getSample(), particle.getWeight());
        } else {
            newParticle.setParent(particle);
        }
        this.genealogy.add(newParticle);
        return true;
    }

    @Override
    public void processParticles() {
        EMCNode.Loginfo("Processing particles...");
        for (EMCParticle<S> p : this.genealogy) {
            if (p.getSample() == null) {
                EMCNode.Loginfo("sample is null");
                throw new RuntimeException();
            }
            this.processor.process(p.getSample(), p.getWeight());
        }
    }

    public String toString() {
        return "" + this.reconstructionTimer.cumulativeTimeInMinutes();
    }

    @Override
    public long getGenerations() {
        return this.genealogy.get(0).getGeneration();
    }
}

