/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import nuts.io.IO;
import nuts.util.Indexer;

public class CreateIndex
implements Runnable {
    @Option
    public String file = "/Users/bouchard/w/scratch/data/conll2000/train";

    public static void main(String[] args) {
        IO.run(args, new CreateIndex());
    }

    @Override
    public void run() {
        Indexer<String> inputIdx = new Indexer<String>();
        Indexer<String> ouputIdx = new Indexer<String>();
        for (String line : IO.i(this.file)) {
            if (line.isEmpty()) continue;
            String[] fields = line.split("\\s+");
            inputIdx.addToIndex((String[])new String[]{fields[0]});
            ouputIdx.addToIndex((String[])new String[]{fields[12]});
        }
        File iIdxFile = new File(Execution.getFile("input-index.txt"));
        File oIdxFile = new File(Execution.getFile("output-index.txt"));
        this.writeIndex(iIdxFile, inputIdx);
        this.writeIndex(oIdxFile, ouputIdx);
    }

    private void writeIndex(File file, Indexer<String> idx) {
        PrintWriter out = IOUtils.openOutEasy(file);
        for (int i = 0; i < idx.size(); ++i) {
            out.println("" + i + " " + idx.i2o(i));
        }
        out.close();
    }
}

