/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import goblin.Taxon;
import java.io.File;
import java.util.List;
import java.util.Map;
import ma.SequenceType;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.smc.models.DiscreteModelCalculator;
import pty.smc.models.LikelihoodModelCalculator;

public class SimpleCoalescentState {
    private List<RootedTree> forest = CollUtils.list();
    private List<LikelihoodModelCalculator> modelCalculators = CollUtils.list();

    public int nRoots() {
        return this.forest.size();
    }

    public double height() {
        double max = Double.NEGATIVE_INFINITY;
        for (RootedTree tree : this.forest) {
            double d;
            double current = RootedTree.Util.height(tree);
            if (!(d > max)) continue;
            max = current;
        }
        return max;
    }

    public double logLikelihood() {
        double result = 0.0;
        for (LikelihoodModelCalculator calc : this.modelCalculators) {
            result += calc.logLikelihood();
        }
        return result;
    }

    public static SimpleCoalescentState getInit(File alignment, SequenceType sequenceType) {
        Map<Taxon, DiscreteModelCalculator> inits = DiscreteModelCalculator.getInit(alignment, SequenceType.RNA);
        SimpleCoalescentState result = new SimpleCoalescentState();
        for (Taxon t : inits.keySet()) {
            RootedTree rt = RootedTree.Util.singleton(t);
            result.forest.add(rt);
            result.modelCalculators.add(inits.get(t));
        }
        return result;
    }

    public SimpleCoalescentState coalesce(int left, int right, double delta) {
        SimpleCoalescentState result = new SimpleCoalescentState();
        for (int i = 0; i < this.forest.size(); ++i) {
            if (i == left || i == right) continue;
            result.forest.add(this.forest.get(i));
            result.modelCalculators.add(this.modelCalculators.get(i));
        }
        double newHeight = this.height() + delta;
        double blLeft = newHeight - RootedTree.Util.height(this.forest.get(left));
        double blRight = newHeight - RootedTree.Util.height(this.forest.get(right));
        Taxon internal = new Taxon("internal_" + this.forest.size());
        RootedTree coalesced = RootedTree.Util.coalesce(internal, this.forest.get(left), this.forest.get(right), blLeft, blRight);
        LikelihoodModelCalculator leftCalc = this.modelCalculators.get(left);
        LikelihoodModelCalculator rightCalc = this.modelCalculators.get(right);
        LikelihoodModelCalculator newCalc = leftCalc.combine(leftCalc, rightCalc, blLeft, blRight, false);
        result.forest.add(coalesced);
        result.modelCalculators.add(newCalc);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (RootedTree rt : this.forest) {
            result.append(rt + "\n");
        }
        return result.toString();
    }
}

