/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import fig.prob.SampleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.math.Sampling;
import nuts.util.CollUtils;

public class ForwardSimulation
implements Runnable {
    @Option
    public double T = 1000.0;
    @Option
    public Random rand = new Random(2L);
    @Option
    public double tkfDelRate = 0.0505;
    @Option
    public double tkfInsRate = 0.050449550449550455;
    @Option
    public double pipDelRate = 0.0505;
    @Option
    public double pipInsRate = 50.5;
    @Option
    public boolean useTKF = true;

    public static void main(String[] args) {
        IO.run(args, new ForwardSimulation());
    }

    @Override
    public void run() {
        IndelDistribution dist = this.getIndelDist();
        ArrayList<Pair<Double, Double>> points = CollUtils.list();
        double t = 0.0;
        int n = dist.initial(this.rand);
        points.add(Pair.makePair(0.0, Double.valueOf(n)));
        while (t < this.T) {
            Pair<Double, Integer> deltas = dist.next(n, this.rand);
            int deltaN = deltas.getSecond();
            points.add(Pair.makePair(t += deltas.getFirst().doubleValue(), Double.valueOf(n)));
            points.add(Pair.makePair(t, Double.valueOf(n += deltaN)));
        }
        Plot2D plot = new Plot2D();
        plot.addSeries(points, true, null);
        plot.savePlot(new File(Execution.getFile("plot.pdf")));
    }

    private IndelDistribution getIndelDist() {
        return this.useTKF ? new TKF() : new PIP();
    }

    public static interface IndelDistribution {
        public Pair<Double, Integer> next(int var1, Random var2);

        public int initial(Random var1);
    }

    public class PIP
    implements IndelDistribution {
        @Override
        public Pair<Double, Integer> next(int current, Random rand) {
            double insExp;
            double delExp = current == 0 ? Double.POSITIVE_INFINITY : Sampling.sampleExponential(rand, 1.0 / ForwardSimulation.this.pipDelRate / (double)current);
            if (delExp < (insExp = Sampling.sampleExponential(rand, 1.0 / ForwardSimulation.this.pipInsRate))) {
                return Pair.makePair(delExp, -1);
            }
            return Pair.makePair(insExp, 1);
        }

        @Override
        public int initial(Random rand) {
            return (int)SampleUtils.samplePoisson(rand, ForwardSimulation.this.pipInsRate / ForwardSimulation.this.pipDelRate);
        }
    }

    public class TKF
    implements IndelDistribution {
        @Override
        public Pair<Double, Integer> next(int current, Random rand) {
            double insExp;
            double delExp = current == 0 ? Double.POSITIVE_INFINITY : Sampling.sampleExponential(rand, 1.0 / ForwardSimulation.this.tkfDelRate / (double)current);
            if (delExp < (insExp = Sampling.sampleExponential(rand, 1.0 / ForwardSimulation.this.tkfInsRate / (1.0 + (double)current)))) {
                return Pair.makePair(delExp, -1);
            }
            return Pair.makePair(insExp, 1);
        }

        @Override
        public int initial(Random rand) {
            return Sampling.sampleGeometric(rand, 1.0 - ForwardSimulation.this.tkfInsRate / ForwardSimulation.this.tkfDelRate);
        }
    }
}

