/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.proposals;

import ev.poi.PoissonModel;
import ev.poi.proposals.PoissonProposal;
import ev.poi.proposals.RootingProposal;
import fig.basic.Pair;
import java.util.Random;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.mcmc.ProposalDistribution;

public class TreeProposal
implements PoissonProposal {
    private final ProposalDistribution prop;
    private RootedTree oldRootedTree = null;
    private PoissonModel model;
    private boolean used = false;

    public TreeProposal(PoissonModel model, ProposalDistribution prop) {
        this.model = model;
        this.prop = prop;
    }

    @Override
    public double doProposal(Random rand, boolean maximize) {
        if (this.used) {
            throw new RuntimeException();
        }
        this.used = true;
        Pair<UnrootedTree, Double> proposed = this.prop.propose(this.model.currentUnrooted(), rand);
        if (proposed == null) {
            return 0.0;
        }
        RootedTree.RootingInfo currentRooting = RootedTree.Util.getRootingInfo(this.model.currentRooted());
        RootedTree newRootedTree = proposed.getFirst().reRoot(currentRooting);
        if (newRootedTree == null) {
            newRootedTree = proposed.getFirst().reRoot(RootingProposal.nextRerooting(this.model.currentRooted(), rand, proposed.getFirst()));
        }
        this.oldRootedTree = this.model.currentRooted();
        this.model.setPhylogeneticTree(newRootedTree);
        return proposed.getSecond();
    }

    @Override
    public void undo() {
        if (this.oldRootedTree != null) {
            this.model.setPhylogeneticTree(this.oldRootedTree);
        }
    }

    @Override
    public String description() {
        return this.prop.description();
    }
}

