/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.FullStatFig;

public class CarefulFullStatFig
extends FullStatFig {
    private int numNaN;
    private int numPosInf;
    private int numNegInf;

    public CarefulFullStatFig() {
    }

    public CarefulFullStatFig(Iterable<Double> c) {
        super(c);
    }

    public int numNaN() {
        return this.numNaN;
    }

    public int numPosInf() {
        return this.numPosInf;
    }

    public int numNegInf() {
        return this.numNegInf;
    }

    @Override
    public void add(double x) {
        if (Double.isNaN(x)) {
            ++this.numNaN;
        } else if (x == Double.NEGATIVE_INFINITY) {
            ++this.numNegInf;
        } else if (x == Double.POSITIVE_INFINITY) {
            ++this.numPosInf;
        } else {
            super.add(x);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.numNaN > 0) {
            sb.append(" NaN:" + this.numNaN);
        }
        if (this.numPosInf > 0) {
            sb.append(" +Inf:" + this.numPosInf);
        }
        if (this.numNegInf > 0) {
            sb.append(" -Inf:" + this.numNegInf);
        }
        return sb.toString();
    }
}

