/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.basic.Pair;
import fig.exec.remote.DummyExecutorService;
import fig.exec.remote.PollingExecutorService;
import fig.exec.remote.RemoteExecutorServiceProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EnsembleExecutorService
implements PollingExecutorService {
    private List<ExecutorService> executors;
    private List<ExecutorService> tmpExecutors;
    private Iterator<ExecutorService> nextExecutor;

    public EnsembleExecutorService(List<ExecutorService> executorServices) {
        this.executors = executorServices;
    }

    public static List<Pair<Integer, Integer>> segmentData(int dataLength, int numDivide) {
        ArrayList<Pair<Integer, Integer>> retVal = new ArrayList<Pair<Integer, Integer>>();
        int lim = dataLength / numDivide;
        int curr = -1;
        for (int seq = 0; seq < dataLength; ++seq) {
            if (seq % lim != 0 || curr >= numDivide - 1) continue;
            ++curr;
            int last = seq + lim;
            if (dataLength - seq < 2 * lim) {
                last = dataLength;
            }
            retVal.add(new Pair<Integer, Integer>(seq, last));
        }
        return retVal;
    }

    @Override
    public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
        try {
            boolean terminatedNormally = true;
            for (ExecutorService exec : this.executors) {
                terminatedNormally &= exec.awaitTermination(arg0, arg1);
            }
            return terminatedNormally;
        }
        catch (Exception e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (Callable<T> callable : arg0) {
            futures.add(this.submit(callable));
        }
        return futures;
    }

    private ExecutorService getNextExecutor() {
        if (this.nextExecutor == null) {
            throw new IllegalStateException("Must call pollExecutors first");
        }
        if (!this.nextExecutor.hasNext()) {
            this.nextExecutor = this.tmpExecutors.iterator();
        }
        ExecutorService next = this.nextExecutor.next();
        return next;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        try {
            boolean isShutdown = true;
            for (ExecutorService exec : this.executors) {
                isShutdown &= exec.isShutdown();
            }
            return isShutdown;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTerminated() {
        try {
            boolean isTerminated = true;
            for (ExecutorService exec : this.executors) {
                isTerminated &= exec.isTerminated();
            }
            return isTerminated;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            for (ExecutorService exec : this.executors) {
                exec.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        try {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>();
            for (ExecutorService exec : this.executors) {
                runnables.addAll(exec.shutdownNow());
            }
            return runnables;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> arg0) {
        return this.getNextExecutor().submit(arg0);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(Executors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.getNextExecutor().execute(command);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int pollExecutors() {
        this.tmpExecutors = new ArrayList<ExecutorService>();
        int sum = 0;
        for (ExecutorService e : this.executors) {
            int c = -1;
            if (e instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor t = (ThreadPoolExecutor)e;
                c = t.getPoolSize() - t.getActiveCount();
            } else if (e instanceof RemoteExecutorServiceProxy) {
                c = ((RemoteExecutorServiceProxy)e).pollExecutors();
            } else if (e instanceof DummyExecutorService) {
                c = 1;
            } else {
                throw new IllegalArgumentException("Illegal executor service " + e);
            }
            sum += c;
            for (int i = 0; i < c; ++i) {
                this.tmpExecutors.add(e);
            }
        }
        this.nextExecutor = this.tmpExecutors.iterator();
        return sum;
    }

    public static <T> List<T> runAndWaitForJobs(ExecutorService exec, List<Callable<T>> jobs) {
        boolean done;
        List<Future<T>> futures = null;
        try {
            futures = exec.invokeAll(jobs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        do {
            done = true;
            for (Future<T> future : futures) {
                done &= future.isDone();
            }
        } while (!done);
        ArrayList<T> doneCounts = new ArrayList<T>();
        for (Future<T> future : futures) {
            try {
                doneCounts.add(future.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return doneCounts;
    }
}

