/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.exec.remote.PollingExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExecutorServiceWrapper
implements PollingExecutorService {
    private ExecutorService execService;

    public ExecutorServiceWrapper(ExecutorService execService) {
        this.execService = execService;
    }

    @Override
    public int pollExecutors() {
        if (this.execService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.execService).getCorePoolSize() - ((ThreadPoolExecutor)this.execService).getActiveCount();
        }
        throw new RuntimeException("Can't use this wrapper class on anything but a ThreadPoolExecutor");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.execService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.execService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.execService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.execService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.execService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.execService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.execService.isShutdown();
    }

    @Override
    public void shutdown() {
        this.execService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.execService.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.execService.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.execService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.execService.submit(task, result);
    }

    @Override
    public void execute(Runnable command) {
        this.execService.execute(command);
    }
}

