/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Trail {
    private List<String> names;
    private int startIndex;
    private static final String delim = "\t";

    public Trail() {
        this.names = new ArrayList<String>();
        this.startIndex = -1;
    }

    public Trail(String[] names) {
        this.names = new ArrayList<String>(Arrays.asList(names));
        this.startIndex = 0;
    }

    public Trail(String namesStr) {
        this.names = new ArrayList<String>(Arrays.asList(StrUtils.split(namesStr, delim)));
        this.startIndex = 0;
    }

    public Trail(List<String> names, int startIndex) {
        this.names = names;
        this.startIndex = startIndex;
    }

    public Trail(Trail trail, String name) {
        this.names = new ArrayList<String>(trail.names);
        this.names.add(name);
        this.startIndex = this.names.size();
    }

    private Trail(String[] names, int startIndex) {
        this.names = new ArrayList<String>(Arrays.asList(names));
        this.startIndex = startIndex;
    }

    public int length() {
        return this.names.size() - this.startIndex;
    }

    public String getName() {
        return this.names.size() == 0 ? "" : this.names.get(this.names.size() - 1);
    }

    public String getHead() {
        return this.names.get(this.startIndex);
    }

    public Trail getBack() {
        return new Trail(this.names, this.startIndex - 1);
    }

    public Trail getTail() {
        return new Trail(this.names, this.startIndex + 1);
    }

    public Trail getFull() {
        return new Trail(this.names, 0);
    }

    public boolean atEnd() {
        return this.startIndex == this.names.size();
    }

    public String toStringValueFromHead() {
        return StrUtils.join(this.names.subList(this.startIndex, this.names.size()), delim);
    }

    public String toStringValue() {
        return StrUtils.join(this.names, delim);
    }

    public String toString() {
        return StrUtils.join(this.names, " | ");
    }
}

