/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.FullStatFig;
import fig.basic.NumUtils;
import java.util.Random;

public class SampleUtils {
    private static double oldm = -1.0;
    private static double g;
    private static double sq;
    private static double alxm;

    public static int[] samplePermutation(Random random, int n) {
        int i;
        int[] perm = new int[n];
        for (i = 0; i < n; ++i) {
            perm[i] = i;
        }
        for (i = 0; i < n - 1; ++i) {
            int j = i + random.nextInt(n - i);
            int tmp = perm[i];
            perm[i] = perm[j];
            perm[j] = tmp;
        }
        return perm;
    }

    public static int sampleMultinomial(Random random, double[] probs) {
        double v = random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(v < (sum += probs[i]))) continue;
            return i;
        }
        throw new RuntimeException(sum + " < " + v);
    }

    public static double[] sampleUnitVector(Random random, int n) {
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = random.nextDouble() - 0.5;
        }
        double norm = NumUtils.l2Norm(x);
        int i = 0;
        while (i < n) {
            int n2 = i++;
            x[n2] = x[n2] / norm;
        }
        return x;
    }

    public static double sampleGamma(Random random, double a, double rate) {
        double v;
        double boost;
        if (rate <= 0.0) {
            throw new RuntimeException();
        }
        if (a < 1.0) {
            boost = Math.exp(Math.log(random.nextDouble()) / a);
            a += 1.0;
        } else {
            boost = 1.0;
        }
        double d = a - 0.3333333333333333;
        double c = 1.0 / Math.sqrt(9.0 * d);
        while (true) {
            double x;
            if ((v = 1.0 + c * (x = SampleUtils.sampleGaussian(random))) <= 0.0) {
                continue;
            }
            v = v * v * v;
            x *= x;
            double u = random.nextDouble();
            if (u < 1.0 - 0.0331 * x * x || Math.log(u) < 0.5 * x + d * (1.0 - v + Math.log(v))) break;
        }
        return boost * d * v / rate;
    }

    public static double sampleErlang(Random random, int ia, double rate) {
        double x;
        assert (ia >= 1);
        if (ia < 6) {
            x = 1.0;
            for (int j = 1; j <= ia; ++j) {
                x *= random.nextDouble();
            }
            x = -Math.log(x);
        } else {
            while (true) {
                double v2;
                double v1;
                if ((v1 = 2.0 * random.nextDouble() - 1.0) * v1 + (v2 = 2.0 * random.nextDouble() - 1.0) * v2 > 1.0) {
                    continue;
                }
                double y = v2 / v1;
                double am = ia - 1;
                double s = Math.sqrt(2.0 * am + 1.0);
                x = s * y + am;
                if (x <= 0.0) continue;
                double e = (1.0 + y * y) * Math.exp(am * Math.log(x / am) - s * y);
                if (!(random.nextDouble() > e)) break;
            }
        }
        return x / rate;
    }

    public static double sampleGaussian(Random random) {
        double x1 = random.nextDouble();
        double x2 = random.nextDouble();
        double z = Math.sqrt(-2.0 * Math.log(x1)) * Math.cos(Math.PI * 2 * x2);
        return z;
    }

    public static double samplePoisson(Random random, double rate) {
        double em;
        double xm = rate;
        if (xm < 12.0) {
            if (xm != oldm) {
                oldm = xm;
                g = Math.exp(-xm);
            }
            em = -1.0;
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= random.nextDouble()) > g);
        } else {
            if (xm != oldm) {
                oldm = xm;
                sq = Math.sqrt(2.0 * xm);
                alxm = Math.log(xm);
                g = xm * alxm - NumUtils.logGamma(xm + 1.0);
            }
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * random.nextDouble())) + xm) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - NumUtils.logGamma(em + 1.0) - g);
                if (!(random.nextDouble() > t)) break;
            }
        }
        return (int)em;
    }

    public static void main(String[] args) {
        FullStatFig fig = new FullStatFig();
        Random random = new Random(1L);
        for (int i = 0; i < 100000; ++i) {
            fig.add(SampleUtils.samplePoisson(random, 4.0));
        }
        System.out.println(fig);
    }
}

